/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentstreak.repository;

import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.streak.repository.StreakRepositoryImpl;
import com.infinite.focus.server.studentstreak.repository.StudentStreakCoreRepository;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StudentStreakCoreRepositoryImpl
implements StudentStreakCoreRepository {
    private final JdbcTemplate jdbcTemplate;

    public StudentStreakCoreRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<StreakDTO> getByStudentId(long student_id) {
        String SQL = "SELECT s.*, COUNT(stu_s.student_id) AS count FROM streak s LEFT JOIN student_streak stu_s ON s.streak_id = stu_s.streak_id AND stu_s.student_id = ? GROUP BY s.streak_id";
        try {
            return this.jdbcTemplate.query(SQL, (rs, i) -> {
                StreakDTO streakDTO = StreakRepositoryImpl.mapRow((ResultSet)rs, (int)i);
                if (rs.getLong("count") > 0L) {
                    streakDTO.setReceived(true);
                }
                return streakDTO;
            }, new Object[]{student_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<StreakDTO>();
        }
    }
}

