/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.email.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.client.TemplateClient;
import com.infinite.focus.server.email.request.SendEmailRequest;
import com.infinite.focus.server.email.request.SendForgotPasswordEmailRequest;
import com.infinite.focus.server.email.request.SendSOSAlertEmailRequest;
import com.infinite.focus.server.email.service.EmailService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.template.request.GetForgotPasswordTemplateRequest;
import com.infinite.focus.server.template.request.GetSOSEmailAskForHelpTemplateRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/email"})
public class EmailController {
    private final MessageService messageService;
    private final EmailService emailService;
    private final TemplateClient templateClient;

    public EmailController(MessageService messageService, EmailService emailService, TemplateClient templateClient) {
        this.messageService = messageService;
        this.emailService = emailService;
        this.templateClient = templateClient;
    }

    @PostMapping(value={"/send-email"})
    ResponseEntity<Message> sendEmail(@RequestBody SendEmailRequest request) {
        try {
            this.emailService.sendHtmlMail(request.getTo(), request.getSubject(), request.getBody());
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        Message message = new Message(this.messageService.getMessage("emails.have.been.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/send-sos-alert-email"})
    ResponseEntity<Message> sendSOSAlertEmail(@RequestBody SendSOSAlertEmailRequest request) {
        String language = LocaleContextHolder.getLocale().getLanguage();
        System.out.println(language);
        String sosEmailAskForHelpTemplate = this.templateClient.getSOSEmailAskForHelpTemplate(GetSOSEmailAskForHelpTemplateRequest.builder().student_name(request.getStudent_name()).grade(request.getGrade()).sos_request_id(request.getSos_request_id()).language(request.getLanguage()).parent(request.isParent()).build());
        try {
            this.emailService.sendHtmlMail(request.getEmail(), request.getStudent_name() + (Language.isSpanish((String)request.getLanguage()) ? " est\u00e1 solicitando ayuda." : " is asking for help."), sosEmailAskForHelpTemplate);
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        Message message = new Message(this.messageService.getMessage("emails.have.been.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/send-sos-email"})
    ResponseEntity<Message> sendSOSEmail(@RequestBody SendSOSAlertEmailRequest request) {
        String language = LocaleContextHolder.getLocale().getLanguage();
        System.out.println(language);
        String sosEmailAskForHelpTemplate = this.templateClient.getSOSEmailAskForHelpTemplate(GetSOSEmailAskForHelpTemplateRequest.builder().student_name(request.getStudent_name()).grade(request.getGrade()).sos_request_id(request.getSos_request_id()).language(request.getLanguage()).parent(request.isParent()).build());
        try {
            this.emailService.sendHtmlMail(request.getEmail(), request.getStudent_name() + (Language.isSpanish((String)request.getLanguage()) ? " est\u00e1 solicitando ayuda." : " is asking for help."), sosEmailAskForHelpTemplate);
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        Message message = new Message(this.messageService.getMessage("emails.have.been.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/forgot-password"})
    ResponseEntity<Message> forgotPassword(@RequestBody SendForgotPasswordEmailRequest request) {
        String forgotPasswordTemplate = this.templateClient.getForgotPasswordTemplate(GetForgotPasswordTemplateRequest.builder().reset_password_link(request.getReset_password_link()).language(request.getLanguage()).build());
        try {
            this.emailService.sendHtmlMail(request.getTo(), Language.isSpanish((String)request.getLanguage()) ? "Restablecer contrase\u00f1a de Clymb" : "Reset Your Clymb Password", forgotPasswordTemplate);
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getMessage());
        }
        Message message = new Message(this.messageService.getMessage("emails.have.been.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }
}

