/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.freetrial.repository;

import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.repository.FreeTrialCoreRepository;
import com.infinite.focus.server.freetrial.request.GetFreeTrialsRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class FreeTrialCoreRepositoryImpl
implements FreeTrialCoreRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public FreeTrialCoreRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<FreeTrial> getFreeTrials(GetFreeTrialsRequest request) {
        ArrayList<String> organizationTypes = new ArrayList<String>();
        for (String organization_type : Arrays.asList(request.getOrganization_types().split("\\s*,\\s*"))) {
            if (organization_type.equals(OrganizationType.LARGE_ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.LARGE_ORGANIZATION.name());
            }
            if (organization_type.equals(OrganizationType.ORGANIZATION.toString())) {
                organizationTypes.add(OrganizationType.ORGANIZATION.name());
            }
            if (!organization_type.equals(OrganizationType.CORPORATE.toString())) continue;
            organizationTypes.add(OrganizationType.CORPORATE.name());
        }
        StringBuilder sql = new StringBuilder("SELECT * FROM free_trial WHERE deleted = false");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM free_trial WHERE deleted = false");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (AppUtils.isNotNullOrEmpty((String)request.getName_of_organization())) {
            sql.append(" AND LOWER(name_of_organization) LIKE :name_of_organization");
            countSql.append(" AND LOWER(name_of_organization) LIKE :name_of_organization");
            params.put("name_of_organization", "%" + request.getName_of_organization().toLowerCase() + "%");
        }
        if (AppUtils.isNotNullOrEmpty((String)request.getOrganization_types())) {
            sql.append(" AND organization_type IN (:organizationTypes)");
            countSql.append(" AND organization_type IN (:organizationTypes)");
            params.put("organizationTypes", organizationTypes);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            sql.append(" AND created_at BETWEEN :fromDate AND :toDate");
            countSql.append(" AND created_at BETWEEN :fromDate AND :toDate");
            params.put("fromDate", request.getFromDate());
            params.put("toDate", request.getToDate());
        }
        String sortBy = request.getSortBy();
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)orderBy), (String[])new String[]{sortBy}));
        sql.append(" LIMIT :limit OFFSET :offset");
        params.put("limit", pageable.getPageSize());
        params.put("offset", pageable.getOffset());
        List resultSet = this.namedParameterJdbcTemplate.query(sql.toString(), params, (rs, i) -> {
            FreeTrial freeTrial = new FreeTrial();
            freeTrial.setFree_trial_id(rs.getLong("free_trial_id"));
            freeTrial.setName_of_organization(rs.getString("name_of_organization"));
            freeTrial.setOrganization_type(OrganizationType.valueOf((String)rs.getString("organization_type")));
            String focusOn = rs.getString("focus_on");
            if (!AppUtils.isNullOrEmpty((String)focusOn)) {
                freeTrial.setFocus_on(FocusOn.valueOf((String)focusOn));
            }
            freeTrial.setStatus(rs.getInt("status"));
            freeTrial.setDeleted(rs.getBoolean("deleted"));
            freeTrial.setTrial_start_date((Date)rs.getTimestamp("trial_start_date"));
            freeTrial.setTrial_end_date((Date)rs.getTimestamp("trial_end_date"));
            freeTrial.setCheck_point_1((Date)rs.getTimestamp("check_point_1"));
            freeTrial.setCheck_point_2((Date)rs.getTimestamp("check_point_2"));
            freeTrial.setDescisions_points_date((Date)rs.getDate("descisions_points_date"));
            freeTrial.setTrial_evaluation_priorities(rs.getString("trial_evaluation_priorities"));
            freeTrial.setOrganization_id(rs.getLong("organization_id"));
            freeTrial.setCreatedAt((Date)rs.getTimestamp("created_at"));
            freeTrial.setUpdatedAt((Date)rs.getTimestamp("updated_at"));
            return freeTrial;
        });
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), params, Long.class);
        return new PageImpl(resultSet, (Pageable)pageable, count.longValue());
    }

    public FreeTrial findByOrganizationTypeAndOrganizationId(String organizationType, long organization_id) {
        String SQL = "SELECT * FROM free_trial WHERE organization_type = :organizationType AND organization_id = :organizationId";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("organizationType", organizationType);
        params.put("organizationId", organization_id);
        return (FreeTrial)this.namedParameterJdbcTemplate.queryForObject(SQL, params, (RowMapper)new BeanPropertyRowMapper(FreeTrial.class));
    }
}

