/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.organizationsurveychoice.service;

import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationsurveychoice.entity.OrganizationSurveyChoice;
import com.infinite.focus.server.organizationsurveychoice.repository.OrganizationSurveyChoiceRepository;
import com.infinite.focus.server.organizationsurveychoice.service.OrganizationSurveyChoiceService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.survey.entity.Survey;
import com.infinite.focus.server.survey.model.LabelAndCountAndAverage;
import com.infinite.focus.server.survey.model.QuestionAndData;
import com.infinite.focus.server.survey.repository.SurveyRepository;
import com.infinite.focus.server.survey.wrapper.SurveyWrapper;
import com.infinite.focus.server.surveychoice.entity.SurveyChoice;
import com.infinite.focus.server.surveychoice.repository.SurveyChoiceRepository;
import com.infinite.focus.server.surveyquestion.entity.SurveyQuestion;
import com.infinite.focus.server.surveyquestion.model.SurveyChoiceType;
import com.infinite.focus.server.surveyquestion.model.SurveyType;
import com.infinite.focus.server.surveyquestion.repository.SurveyQuestionRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class OrganizationSurveyChoiceServiceImpl
implements OrganizationSurveyChoiceService {
    @Autowired
    SchoolRepository schoolRepository;
    @Autowired
    SurveyRepository surveyRepository;
    @Autowired
    SurveyQuestionRepository surveyQuestionRepository;
    @Autowired
    SurveyChoiceRepository surveyChoiceRepository;
    @Autowired
    OrganizationSurveyChoiceRepository organizationSurveyChoiceRepository;
    @Autowired
    MessageService messageService;

    public void assignSurveyToOrganization(Date date) {
        Survey survey = this.surveyRepository.findSurveyByDate(date);
        if (survey == null) {
            System.out.println(this.messageService.getMessage("survey.is.not.found.for.the.date"));
            return;
        }
        System.out.println("GetSurveyByDate: " + survey.getSurvey_id());
        long days = DateUtils.getDayCountByFromDateAndToDate((Date)date, (Date)survey.getEnd_time(), (TimeZone)TimeZone.getTimeZone(ZoneId.systemDefault()));
        System.out.println("countDaysBetweenFromDateAndToDate: " + days);
        Set organizationIds = this.schoolRepository.getAllSchools().stream().map(School::getSchool_id).collect(Collectors.toSet());
        System.out.println("All Organizations: " + organizationIds.size());
        Set organizationIdsFromOrganizationSurveyChoice = this.getAllBySurveyId(survey.getSurvey_id()).stream().map(OrganizationSurveyChoice::getOrganization_id).collect(Collectors.toSet());
        System.out.println("AllBySurveyId: " + organizationIdsFromOrganizationSurveyChoice.size());
        organizationIds.removeAll(organizationIdsFromOrganizationSurveyChoice);
        System.out.println("All Organizations - AllBySurveyId = " + organizationIds.size());
        if (!organizationIds.isEmpty() && days > 0L) {
            int countToAssign = 0;
            try {
                countToAssign = (int)((long)organizationIds.size() / days);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (countToAssign == 0) {
                countToAssign = 1;
            }
            System.out.println("countToAssign: " + countToAssign);
            organizationIds = AppUtils.getRandomStreamSubset(organizationIds.stream(), (int)countToAssign).collect(Collectors.toSet());
            System.out.println("OrganizationIds to assign: " + organizationIds.size());
            SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.ORGANIZATION.toString());
            List surveyChoices = this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id()));
            System.out.println("SurveyChoices: " + surveyChoices.size());
            this.create(survey.getSurvey_id(), surveyQuestion.getChoice_type() == SurveyChoiceType.SINGLE ? 1L : (long)surveyChoices.size(), new ArrayList(organizationIds));
        }
    }

    @Async
    public void create(long survey_id, long surveyChoicesSize, List<Long> organizationIds) {
        if (!organizationIds.isEmpty()) {
            for (long organization_Id : organizationIds) {
                int i = 0;
                while ((long)i < surveyChoicesSize) {
                    OrganizationSurveyChoice organizationSurveyChoice = new OrganizationSurveyChoice();
                    organizationSurveyChoice.setOrganization_id(organization_Id);
                    organizationSurveyChoice.setSurvey_id(survey_id);
                    this.organizationSurveyChoiceRepository.save((Object)organizationSurveyChoice);
                    ++i;
                }
            }
        }
    }

    public List<OrganizationSurveyChoice> getAllBySurveyId(long surveyId) {
        return this.organizationSurveyChoiceRepository.findBySurveyId(Long.valueOf(surveyId));
    }

    public LinkedHashSet<SurveyWrapper> getSurveyWrappersForOrganization(long organization_id) {
        LinkedHashSet<SurveyWrapper> surveyWrappers = new LinkedHashSet<SurveyWrapper>();
        List organizationSurveyChoices = this.organizationSurveyChoiceRepository.findByOrganizationId(organization_id);
        if (!organizationSurveyChoices.isEmpty()) {
            Map<Long, LinkedHashSet> organizationSurveyChoiceBySurveyId = organizationSurveyChoices.stream().collect(Collectors.groupingBy(OrganizationSurveyChoice::getSurvey_id, Collectors.toCollection(LinkedHashSet::new)));
            Set<Long> surveyIds = organizationSurveyChoiceBySurveyId.keySet();
            for (long surveyId : surveyIds) {
                LinkedHashSet organizationSurveyChoicesFilled = organizationSurveyChoiceBySurveyId.get(surveyId).stream().filter(organizationSurveyChoice -> organizationSurveyChoice.getSurvey_choice_id() > 0L).collect(Collectors.toCollection(LinkedHashSet::new));
                if (!organizationSurveyChoicesFilled.isEmpty()) continue;
                Survey survey = this.surveyRepository.findBySurveyId(Long.valueOf(surveyId));
                SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.ORGANIZATION.toString());
                surveyWrappers.add(new SurveyWrapper(surveyQuestion, new LinkedHashSet(this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id())))));
            }
        }
        return surveyWrappers;
    }

    public void updateOrganizationSurveyChoice(long organization_id, long survey_id, Set<Long> survey_choices) {
        List organizationSurveyChoices = this.organizationSurveyChoiceRepository.findBySurveyIdAndOrganizationIdOrderByOrganizationSurveyChoiceASC(survey_id, organization_id);
        ArrayList<Long> surveyChoices = new ArrayList<Long>(survey_choices);
        if (!AppUtils.isNullOrEmpty(survey_choices)) {
            for (int i = 0; i < surveyChoices.size(); ++i) {
                OrganizationSurveyChoice organizationSurveyChoice = (OrganizationSurveyChoice)organizationSurveyChoices.get(i);
                organizationSurveyChoice.setSurvey_choice_id(((Long)surveyChoices.get(i)).longValue());
                this.organizationSurveyChoiceRepository.save((Object)organizationSurveyChoice);
            }
        }
    }

    public QuestionAndData getDataAnalytics(String fromDate, String toDate, String fromTimeZone, String toTimeZone) {
        Survey survey = this.surveyRepository.findSurveyByDate(fromDate, fromTimeZone, toTimeZone);
        if (survey == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("survey.is.not.found.for.the.date"));
        }
        SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.ORGANIZATION.toString());
        List surveyChoices = this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id()));
        LinkedHashSet<LabelAndCountAndAverage> labelAndCountAndAverages = new LinkedHashSet<LabelAndCountAndAverage>();
        for (SurveyChoice surveyChoice : surveyChoices) {
            LabelAndCountAndAverage labelAndValueAndAverage = new LabelAndCountAndAverage(surveyChoice.getChoice(), surveyChoice.getChoice_es(), 0L);
            labelAndCountAndAverages.add(labelAndValueAndAverage);
        }
        List organizationSurveyChoices = this.organizationSurveyChoiceRepository.findByCreatedAtBetweenFromDateAndEndDateOrderByDESC(fromDate, toDate);
        Map<Long, LinkedHashSet> organizationSurveyChoiceBySurveyChoiceId = organizationSurveyChoices.stream().filter(organizationSurveyChoice -> organizationSurveyChoice.getSurvey_choice_id() > 0L).collect(Collectors.groupingBy(OrganizationSurveyChoice::getSurvey_choice_id, Collectors.toCollection(LinkedHashSet::new)));
        Set<Long> surveyChoiceIds = organizationSurveyChoiceBySurveyChoiceId.keySet();
        long totalCount = 0L;
        for (long survey_choice_id : surveyChoiceIds) {
            SurveyChoice surveyChoice = this.surveyChoiceRepository.findSurveyChoiceById(survey_choice_id);
            LinkedHashSet organizationSurveyChoiceList = organizationSurveyChoiceBySurveyChoiceId.get(survey_choice_id);
            totalCount += (long)organizationSurveyChoiceList.size();
            for (LabelAndCountAndAverage labelAndValueAndAverage : labelAndCountAndAverages) {
                if (!labelAndValueAndAverage.getLabel().equals(surveyChoice.getChoice())) continue;
                labelAndValueAndAverage.setCount((long)organizationSurveyChoiceList.size());
            }
        }
        for (LabelAndCountAndAverage labelAndCountAndAverage : labelAndCountAndAverages) {
            labelAndCountAndAverage.setAverage(DigitUtils.getPercentageInTwoDigit((Long)labelAndCountAndAverage.getCount(), (Long)totalCount).doubleValue());
        }
        QuestionAndData questionAndData = new QuestionAndData();
        questionAndData.setSurveyQuestion(surveyQuestion);
        questionAndData.setLabelAndCountAndAverages(labelAndCountAndAverages);
        questionAndData.setTotal_survey_sent(this.organizationSurveyChoiceRepository.countByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        questionAndData.setActive_users_who_received_survey((Object)"N/A");
        questionAndData.setFilled_survey(this.organizationSurveyChoiceRepository.countFilledByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        return questionAndData;
    }

    public void syncOrganizationSurvey() {
        List organizationSurveyChoices = this.organizationSurveyChoiceRepository.findAll();
        for (OrganizationSurveyChoice organizationSurveyChoice : organizationSurveyChoices) {
            List items = this.organizationSurveyChoiceRepository.findBySurveyIdAndOrganizationIdOrderByOrganizationSurveyChoiceASC(organizationSurveyChoice.getSurvey_id(), organizationSurveyChoice.getOrganization_id());
            if (!AppUtils.isNullOrEmpty((List)items)) {
                OrganizationSurveyChoice firstItem = (OrganizationSurveyChoice)items.get(0);
                for (OrganizationSurveyChoice item : items) {
                    item.setCreatedAt(firstItem.getCreatedAt());
                }
            }
            this.organizationSurveyChoiceRepository.saveAll((Iterable)items);
        }
    }
}

