/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.student.repository;

import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.utils.AppUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StudentCriteriaRepositoryImpl
implements StudentCriteriaRepository {
    @Autowired
    EntityManager entityManager;
    @Autowired
    JdbcTemplate jdbcTemplate;

    private static StudentDTO mapRow(ResultSet rs, int i) throws SQLException {
        return StudentDTO.builder().student_id(Long.valueOf(rs.getLong("student_id"))).account_id(Long.valueOf(rs.getLong("account_id"))).avatar_id(Long.valueOf(rs.getLong("avatar_id"))).first_name(rs.getString("first_name")).last_name(rs.getString("last_name")).gender(rs.getString("gender")).date_of_birth(rs.getDate("date_of_birth")).ethnicity(rs.getString("ethnicity")).standard_id(Long.valueOf(rs.getLong("standard_id"))).demo(Boolean.valueOf(rs.getBoolean("demo"))).school_id(Long.valueOf(rs.getLong("school_id"))).instructor_id(Long.valueOf(rs.getLong("instructor_id"))).parent_id(Long.valueOf(rs.getLong("parent_id"))).build();
    }

    public List<StudentDTO> getStudentsByDemographics(GetDataDashBoardRequest request, boolean useFromDateToDate) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Object[].class);
        Root root = c.from(Student.class);
        List predicates = this.getPredicatesForStudentDemographics(qb, (Path)root, request.getGenders(), request.getAges(), request.getEthnicity(), request.getGradeIds(), request.getClassIds(), request.getFromDate(), request.getToDate(), useFromDateToDate, false);
        c.multiselect(this.getStudentDTOSelection(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List studentDTOList = this.mapStudentObjectsToStudentDTOs(typedQuery);
        return studentDTOList;
    }

    public List<Long> getStudentIdsByDemographics(GetDataDashBoardRequest request, boolean useFromDateToDate, boolean isFromSELAnalytics) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Long.class);
        Root root = c.from(Student.class);
        List predicates = this.getPredicatesForStudentDemographics(qb, (Path)root, request.getGenders(), request.getAges(), request.getEthnicity(), request.getGradeIds(), request.getClassIds(), request.getFromDate(), request.getToDate(), useFromDateToDate, isFromSELAnalytics);
        c.select((Selection)root.get("student_id")).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List student_ids = typedQuery.getResultList();
        return student_ids;
    }

    public List<StudentDTO> getStudentsByDemographics(GetDataDashBoardRequest request, boolean useFromDateToDate, boolean isFromSELAnalytics) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Object[].class);
        Root root = c.from(Student.class);
        List predicates = this.getPredicatesForStudentDemographics(qb, (Path)root, request.getGenders(), request.getAges(), request.getEthnicity(), request.getGradeIds(), request.getClassIds(), request.getFromDate(), request.getToDate(), useFromDateToDate, isFromSELAnalytics);
        c.multiselect(this.getStudentDTOSelection(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(c);
        List studentDTOList = this.mapStudentObjectsToStudentDTOs(typedQuery);
        return studentDTOList;
    }

    public List<Long> getActiveStudentIdsBySchool(Long school_id, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds, java.util.Date fromDate, java.util.Date toDate, boolean isFromSELAnalytics) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Long.class);
        Root rootClass = c.from(Class.class);
        Join rootInstructor = rootClass.join("instructor");
        Join rootStudent = rootClass.join("students");
        List predicates = this.getPredicatesForStudentDemographics(qb, (Path)rootStudent, genders, ages, ethnicity, gradeIds, classIds, fromDate, toDate, false, isFromSELAnalytics);
        predicates.add(qb.equal((Expression)rootInstructor.get("school_id"), (Object)school_id));
        if (AppUtils.isNotNullOrEmpty(classIds)) {
            predicates.add(qb.in((Expression)rootClass.get("class_id")).value(classIds));
        }
        c.select((Selection)rootStudent.get("student_id")).distinct(true).where(predicates.toArray(new Predicate[0]));
        c.orderBy(new Order[]{qb.asc((Expression)rootStudent.get("student_id"))});
        TypedQuery typedQueryStudentIds = this.entityManager.createQuery(c);
        List studentIds = typedQueryStudentIds.getResultList();
        return studentIds;
    }

    public List<Long> getActiveStudentIdsByClass(Long class_id, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds, java.util.Date fromDate, java.util.Date toDate, boolean isFromSELAnalytics) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = qb.createQuery(Long.class);
        Root rootClass = c.from(Class.class);
        Join rootStudent = rootClass.join("students");
        List predicates = this.getPredicatesForStudentDemographics(qb, (Path)rootStudent, genders, ages, ethnicity, gradeIds, classIds, fromDate, toDate, false, isFromSELAnalytics);
        predicates.add(qb.equal((Expression)rootClass.get("class_id"), (Object)class_id));
        c.select((Selection)rootStudent.get("student_id")).distinct(true).where(predicates.toArray(new Predicate[0]));
        c.orderBy(new Order[]{qb.asc((Expression)rootStudent.get("student_id"))});
        TypedQuery typedQueryStudentIds = this.entityManager.createQuery(c);
        List studentIds = typedQueryStudentIds.getResultList();
        return studentIds;
    }

    public StudentDTO getStudentById(long student_id) {
        String SQL = "SELECT * FROM student WHERE student_id = ?";
        return (StudentDTO)this.jdbcTemplate.queryForObject(SQL, (rs, i) -> StudentDTO.builder().student_id(Long.valueOf(rs.getLong("student_id"))).account_id(Long.valueOf(rs.getLong("account_id"))).gender(rs.getString("gender")).date_of_birth(rs.getDate("date_of_birth")).ethnicity(rs.getString("ethnicity")).standard_id(Long.valueOf(rs.getLong("standard_id"))).demo(Boolean.valueOf(rs.getBoolean("demo"))).build(), new Object[]{student_id});
    }

    public List<Long> getStudentIdsByInstructorIds(List<Long> instructor_ids) {
        if (AppUtils.isNullOrEmpty(instructor_ids)) {
            return new ArrayList<Long>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(instructor_ids.size(), "?"));
        String SQL = "SELECT DISTINCT(student_id) FROM active_student WHERE instructor_id IN(%s) ORDER BY student_id ASC";
        List studentIds = this.jdbcTemplate.query(String.format(SQL, inSql), instructor_ids.toArray(), (rs, i) -> rs.getLong("student_id"));
        return studentIds;
    }

    private List<Predicate> getPredicatesForStudentDemographics(CriteriaBuilder qb, Path root, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds, java.util.Date fromDate, java.util.Date toDate, boolean useFromDateToDate, boolean isFromSELAnalytics) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty(genders)) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("gender")).value(genders);
            predicates.add((Predicate)genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty(ages)) {
            Expression birthYear = qb.function("YEAR", Integer.class, new Expression[]{root.get("date_of_birth")});
            Expression currentYear = qb.function("YEAR", Integer.class, new Expression[]{qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            Expression ageDifference = qb.diff(currentYear, birthYear);
            CriteriaBuilder.In inClause = qb.in(ageDifference);
            for (Integer age : ages) {
                inClause.value((Object)age);
            }
            predicates.add((Predicate)inClause);
        }
        if (AppUtils.isNotNullOrEmpty(ethnicity)) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)root.get("ethnicity")).value(ethnicity);
            predicates.add((Predicate)ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty(gradeIds)) {
            Predicate gradePredicate = root.get("standard").get("grade").get("grade_id").in(gradeIds);
            predicates.add(gradePredicate);
        }
        if (useFromDateToDate && fromDate != null && toDate != null) {
            predicates.add(qb.between((Expression)root.get("account").get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        if (isFromSELAnalytics) {
            predicates.add(qb.notEqual((Expression)root.get("standard").get("grade").get("grade_id"), (Object)1));
        }
        predicates.add(qb.isNotNull((Expression)root.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)root.get("account").get("username"), (Object)""));
        CriteriaBuilder.In statusPredicate = qb.in((Expression)root.get("accessCode").get("status")).value(Collections.singletonList(Status.ACCEPTED));
        predicates.add((Predicate)statusPredicate);
        return predicates;
    }

    private List<Selection<?>> getStudentDTOSelection(Root<Student> root) {
        ArrayList selectionList = new ArrayList();
        selectionList.add((Selection<?>)root.get("student_id"));
        selectionList.add((Selection<?>)root.get("account").get("account_id"));
        selectionList.add((Selection<?>)root.get("gender"));
        selectionList.add((Selection<?>)root.get("date_of_birth"));
        selectionList.add((Selection<?>)root.get("ethnicity"));
        selectionList.add((Selection<?>)root.get("standard").get("grade").get("grade_id"));
        selectionList.add((Selection<?>)root.get("demo"));
        return selectionList;
    }

    private List<StudentDTO> mapStudentObjectsToStudentDTOs(TypedQuery<Object[]> typedQuery) {
        List<StudentDTO> studentDTOList = typedQuery.getResultList().stream().map(item -> StudentDTO.builder().student_id((Long)item[0]).account_id((Long)item[1]).gender((String)item[2]).date_of_birth((Date)item[3]).ethnicity((String)item[4]).grade_id((Long)item[5]).demo((Boolean)item[6]).build()).collect(Collectors.toList());
        return studentDTOList;
    }

    public List<Long> getStudentIdsByInstructorId(long instructor_id) {
        String SQL = "SELECT DISTINCT(student_id) FROM active_student WHERE instructor_id = ? ";
        try {
            List studentIds = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("student_id"), new Object[]{instructor_id});
            return studentIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public List<Long> getStudentIdsBySchoolId(long school_id) {
        String SQL = "SELECT DISTINCT(student_id) FROM active_student WHERE school_id = ? ";
        try {
            List studentIds = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("student_id"), new Object[]{school_id});
            return studentIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public List<Long> findBySchoolIdAndShareJournalWithInstructor(long school_id, boolean share_journal_with_instructor) {
        String SQL = "SELECT DISTINCT(a.student_id) FROM active_student a JOIN student s ON s.student_id = a.student_id WHERE a.school_id = ? AND s.share_journal_with_instructor = ? ";
        try {
            List studentIds = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("student_id"), new Object[]{school_id, share_journal_with_instructor});
            return studentIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }

    public List<StudentDTO> findByIds(List<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<StudentDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM student WHERE student_id IN(%s) ORDER BY student_id ASC";
        List studentDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), StudentCriteriaRepositoryImpl::mapRow);
        return studentDTOS;
    }

    public List<Long> findStudentIdsByDemographics(long school_id, String name, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, Set<Long> student_ids_by_class_ids) {
        String student_name = AppUtils.isNullOrEmpty((String)name) ? null : "'" + name + "'";
        Object NAME_CONDITION = AppUtils.isNullOrEmpty((String)name) ? "FALSE" : " CONCAT(first_name,' ', last_name) LIKE '%" + name + "%' ";
        String GENDER_CONDITION = AppUtils.isNullOrEmpty(genders) ? "FALSE" : " gender IN(" + AppUtils.strListToCommaSeparatedString(genders) + ") ";
        String AGE_CONDITION = AppUtils.isNullOrEmpty(ages) ? "FALSE" : " age IN(" + AppUtils.integerListToCommaSeparatedString(ages) + ") ";
        String ETHNICITY_CONDITION = AppUtils.isNullOrEmpty(ethnicity) ? "FALSE" : " ethnicity IN(" + AppUtils.strListToCommaSeparatedString(ethnicity) + ") ";
        String GRADE_CONDITION = AppUtils.isNullOrEmpty(gradeIds) ? "FALSE" : " grade_id IN(" + AppUtils.longListToCommaSeparatedString(gradeIds) + ") ";
        String CLASS_CONDITION = AppUtils.isNullOrEmpty(student_ids_by_class_ids) ? "FALSE" : " student_id IN(" + AppUtils.longSetToCommaSeparatedString(student_ids_by_class_ids) + ") ";
        String SQL = "SELECT DISTINCT(student_id) FROM active_student WHERE  IF(" + school_id + " > 0, school_id = " + school_id + ", TRUE) AND IF(" + student_name + " IS NOT NULL AND " + student_name + " != '', " + (String)NAME_CONDITION + " , TRUE) AND IF(" + (genders == null ? 0 : genders.size()) + " > 0, " + GENDER_CONDITION + " , TRUE) AND IF(" + (ages == null ? 0 : ages.size()) + " > 0, " + AGE_CONDITION + " , TRUE) AND IF(" + (ethnicity == null ? 0 : ethnicity.size()) + " > 0, " + ETHNICITY_CONDITION + " , TRUE) AND IF(" + (gradeIds == null ? 0 : gradeIds.size()) + " > 0, " + GRADE_CONDITION + " , TRUE) AND IF(" + (student_ids_by_class_ids == null ? 0 : student_ids_by_class_ids.size()) + " > 0, " + CLASS_CONDITION + " , TRUE) ";
        List student_ids = this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong("student_id"));
        return student_ids;
    }

    public List<StudentDTO> findByInstructorIdAndStudentName(Long instructor_id, String student_name) {
        String SQL = "SELECT * FROM student WHERE instructor_id = ? AND CONCAT(first_name,' ', last_name) LIKE '%" + student_name + "%' ORDER BY student_id ASC ";
        return this.jdbcTemplate.query(SQL, StudentCriteriaRepositoryImpl::mapRow, new Object[]{instructor_id});
    }
}

