/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.account.wrapper.AccountDataWrapper;
import com.infinite.focus.server.auth.exception.NotFoundException;
import com.infinite.focus.server.auth.exception.TimeOutException;
import com.infinite.focus.server.auth.request.ChangePasswordRequest;
import com.infinite.focus.server.auth.request.CheckLicenseKeyStatusRequest;
import com.infinite.focus.server.auth.request.CheckUsername2AvailabilityRequest;
import com.infinite.focus.server.auth.request.CheckUsernameAvailabilityRequest;
import com.infinite.focus.server.auth.request.CorporateSignUpRequest;
import com.infinite.focus.server.auth.request.DistrictSignUpRequest;
import com.infinite.focus.server.auth.request.ForgotUserPasswordRequest;
import com.infinite.focus.server.auth.request.InstructorSignUpRequest;
import com.infinite.focus.server.auth.request.IsActiveUserRequest;
import com.infinite.focus.server.auth.request.NumberOfStudentsWhoDidClymbRequest;
import com.infinite.focus.server.auth.request.ParentSignUpRequest;
import com.infinite.focus.server.auth.request.ResetPasswordRequest;
import com.infinite.focus.server.auth.request.SchoolSignUpRequest;
import com.infinite.focus.server.auth.request.SearchCorporateRequest;
import com.infinite.focus.server.auth.request.SearchDistrictRequest;
import com.infinite.focus.server.auth.request.SearchInstructorRequest;
import com.infinite.focus.server.auth.request.SearchParentRequest;
import com.infinite.focus.server.auth.request.SearchSchoolRequest;
import com.infinite.focus.server.auth.request.StudentSignUpRequest;
import com.infinite.focus.server.auth.request.StudentsSignUpRequest;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.auth.service.StudentAuthService;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.avatar.entity.Avatar;
import com.infinite.focus.server.avatar.repository.AvatarRepository;
import com.infinite.focus.server.avatar.service.AvatarService;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverDistrict;
import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverParent;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.clever.service.district.CleverDistrictService;
import com.infinite.focus.server.clever.service.instructor.CleverInstructorService;
import com.infinite.focus.server.clever.service.parent.CleverParentService;
import com.infinite.focus.server.clever.service.school.CleverSchoolService;
import com.infinite.focus.server.clever.service.school.CleverSchoolSyncService;
import com.infinite.focus.server.client.EmailClient;
import com.infinite.focus.server.configuration.entity.Configuration;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.confirmationtoken.entity.ConfirmationToken;
import com.infinite.focus.server.confirmationtoken.repository.ConfirmationTokenRepository;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.repository.DistrictRepository;
import com.infinite.focus.server.email.request.SendEmailRequest;
import com.infinite.focus.server.email.request.SendForgotPasswordEmailRequest;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.service.InvoiceService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.entity.Message;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organization.service.OrganizationService;
import com.infinite.focus.server.parent.dto.ParentCoreDTO;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.repository.ParentCoreRepository;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.standard.entity.Standard;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.service.StandardService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.twilio.service.SmsService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/auth"})
public class AuthenticationController {
    private final ConfigurationService configurationService;
    private final FreeTrialService freeTrialService;
    private final InvoiceService invoiceService;
    private final StudentService studentService;
    private final ValidationService validationService;
    private final AccountRepository accountRepository;
    private final AccountService accountService;
    private final StudentRepository studentRepository;
    private final ParentCoreRepository parentCoreRepository;
    private final StandardJPARepository standardRepository;
    private final StandardService standardService;
    private final InstructorRepository instructorRepository;
    private final AvatarRepository avatarRepository;
    private final AvatarService avatarService;
    private final CleverService cleverService;
    private final CleverDistrictService cleverDistrictService;
    private final CleverSchoolService cleverSchoolService;
    private final CleverInstructorService cleverInstructorService;
    private final CleverParentService cleverParentService;
    private final CleverDataService cleverDataService;
    private final BCryptPasswordEncoder bCryptPasswordEncoder;
    private final SchoolRepository schoolRepository;
    private final DistrictRepository districtRepository;
    private final ConfirmationTokenRepository confirmationTokenRepository;
    private final AuthService authService;
    private final StudentAuthService studentAuthService;
    private final SchoolService schoolService;
    private final InstructorService instructorService;
    private final OrganizationService organizationService;
    private final ParentService parentService;
    private final SmsService smsService;
    private final MessageService messageService;
    private final CorporateService corporateService;
    private final CleverSchoolSyncService cleverSchoolSyncService;
    private final JwtHelper jwtHelper;
    private final EmailClient emailClient;

    public AuthenticationController(ConfigurationService configurationService, FreeTrialService freeTrialService, InvoiceService invoiceService, StudentService studentService, ValidationService validationService, AccountService accountService, ParentCoreRepository parentCoreRepository, StandardService standardService, AvatarService avatarService, CleverDistrictService cleverDistrictService, DistrictRepository districtRepository, SchoolRepository schoolRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, StandardJPARepository standardRepository, AccountRepository accountRepository, CleverService cleverService, CleverSchoolService cleverSchoolService, CleverInstructorService cleverInstructorService, CleverParentService cleverParentService, CleverDataService cleverDataService, BCryptPasswordEncoder bCryptPasswordEncoder, ConfirmationTokenRepository confirmationTokenRepository, AuthService authService, StudentAuthService studentAuthService, SchoolService schoolService, InstructorService instructorService, OrganizationService organizationService, ParentService parentService, SmsService smsService, MessageService messageService, CorporateService corporateService, CleverSchoolSyncService cleverSchoolSyncService, JwtHelper jwtHelper, EmailClient emailClient) {
        this.configurationService = configurationService;
        this.freeTrialService = freeTrialService;
        this.invoiceService = invoiceService;
        this.studentService = studentService;
        this.validationService = validationService;
        this.accountService = accountService;
        this.parentCoreRepository = parentCoreRepository;
        this.standardService = standardService;
        this.avatarService = avatarService;
        this.cleverDistrictService = cleverDistrictService;
        this.districtRepository = districtRepository;
        this.schoolRepository = schoolRepository;
        this.avatarRepository = avatarRepository;
        this.cleverService = cleverService;
        this.cleverSchoolService = cleverSchoolService;
        this.cleverInstructorService = cleverInstructorService;
        this.cleverParentService = cleverParentService;
        this.cleverDataService = cleverDataService;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.standardRepository = standardRepository;
        this.accountRepository = accountRepository;
        this.confirmationTokenRepository = confirmationTokenRepository;
        this.authService = authService;
        this.studentAuthService = studentAuthService;
        this.schoolService = schoolService;
        this.instructorService = instructorService;
        this.organizationService = organizationService;
        this.parentService = parentService;
        this.smsService = smsService;
        this.messageService = messageService;
        this.corporateService = corporateService;
        this.cleverSchoolSyncService = cleverSchoolSyncService;
        this.jwtHelper = jwtHelper;
        this.emailClient = emailClient;
    }

    @GetMapping(value={"/getUserAuthDetails"})
    public ResponseEntity<Void> getUserAuthDetails(@RequestHeader(value="Authorization") String token) {
        String decryptedToken = EncryptDecryptHelper.decrypt((String)EncryptDecryptHelper.base64Decode((String)token));
        System.out.println("decrypted token is:-" + decryptedToken);
        String[] elements = decryptedToken.split(" ");
        String username = elements[2];
        System.out.println("username is:-" + username);
        String newToken = this.jwtHelper.generateToken(username);
        String newRefreshToken = this.jwtHelper.generateRefreshToken(username);
        System.out.println("new token is:-" + newToken);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", newToken);
        responseHeaders.set("Authorization_Refresh_Token", newRefreshToken);
        return new ResponseEntity((MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/refreshToken"})
    public ResponseEntity<Void> refreshToken(@RequestHeader(value="Authorization_Refresh_Token") String refreshToken) {
        String username = this.jwtHelper.extractUsernameForRefreshToken(refreshToken);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", this.jwtHelper.generateToken(username));
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(username));
        return new ResponseEntity((MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/data"})
    public ResponseEntity<List<AccountDataWrapper>> getUserData(@RequestHeader(value="Authorization") String token, @RequestHeader(value="operating_system", required=false) String operating_system, @RequestHeader(value="browser", required=false) String browser) {
        AccountDataWrapper corporateAdw;
        AccountDataWrapper parentAdw;
        AccountDataWrapper districtAdw;
        List schoolAdw;
        AccountDataWrapper studentAdw;
        HttpHeaders responseHeaders = new HttpHeaders();
        if (this.jwtHelper.isTokenExpired(token).booleanValue()) {
            String user = this.jwtHelper.extractUsernameForExpiredToken(token);
            token = this.jwtHelper.generateToken(user);
        }
        responseHeaders.set("Authorization", token);
        String theClymbingGuide = this.configurationService.getConfiguration().getBaseUrlApi() + "/documents/privacy_policy/The_Clymbing_Guide.pdf";
        ArrayList<AccountDataWrapper> accountDataWrappers = new ArrayList<AccountDataWrapper>();
        AccountDataWrapper adminAdw = this.authService.getAdminAccountLoginData(token);
        if (adminAdw != null) {
            adminAdw.setContact(this.configurationService.getConfiguration().getContact());
            adminAdw.setTheClymbingGuide(theClymbingGuide);
            accountDataWrappers.add(adminAdw);
            return new ResponseEntity(accountDataWrappers, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        AccountDataWrapper instructorAdw = this.authService.getInstructorAccountLoginData(token);
        if (instructorAdw != null) {
            instructorAdw.setContact(this.configurationService.getConfiguration().getContact());
            instructorAdw.setSupport(this.configurationService.getConfiguration().getSupport_instructor());
            this.instructorService.setOperatingSystemAndBrowser(instructorAdw.getI().getInstructor_id(), operating_system, browser);
            instructorAdw.setTheClymbingGuide(theClymbingGuide);
            accountDataWrappers.add(instructorAdw);
        }
        if ((studentAdw = this.authService.getStudentAccountLoginData(token)) != null) {
            Configuration configuration = this.configurationService.getConfiguration();
            studentAdw.setContact(configuration.getContact());
            studentAdw.setSupport(configuration.getSupport());
            studentAdw.setClymb_community_guidelines(configuration.getClymb_community_guidelines());
            studentAdw.setHelp_assistant(configuration.getClymb_help_assistant());
            studentAdw.setHelp_assistant_es(configuration.getClymb_help_assistant_es());
            Message message = this.messageService.getMessage();
            studentAdw.setAfh_pop_up_message(message.getAfh_pop_up_message());
            studentAdw.setAfh_pop_up_message_es(message.getAfh_pop_up_message_es());
            this.studentService.setOperatingSystemAndBrowser(studentAdw.getS().getStudent_id(), operating_system, browser);
            accountDataWrappers.add(studentAdw);
        }
        if (!AppUtils.isNullOrEmpty((List)(schoolAdw = this.authService.getSchoolAccountLoginData(token)))) {
            for (AccountDataWrapper wrapper : schoolAdw) {
                wrapper.setContact(this.configurationService.getConfiguration().getContact());
                wrapper.setSupport(this.configurationService.getConfiguration().getSupport_instructor());
                wrapper.setTheClymbingGuide(theClymbingGuide);
            }
            accountDataWrappers.addAll(schoolAdw);
        }
        if ((districtAdw = this.authService.getDistrictAccountLoginData(token)) != null) {
            districtAdw.setContact(this.configurationService.getConfiguration().getContact());
            districtAdw.setSupport(this.configurationService.getConfiguration().getSupport_instructor());
            districtAdw.setTheClymbingGuide(theClymbingGuide);
            accountDataWrappers.add(districtAdw);
        }
        if ((parentAdw = this.authService.getParentAccountLoginData(token)) != null) {
            this.parentService.setOperatingSystemAndBrowser(parentAdw.getParent().getParent_id(), operating_system, browser);
            parentAdw.setBest_practices(this.configurationService.getConfiguration().getBest_practices());
            parentAdw.setMarketing_materials(this.configurationService.getConfiguration().getMarketing_materials());
            parentAdw.setContact(this.configurationService.getConfiguration().getContact());
            parentAdw.setTheClymbingGuide(theClymbingGuide);
            accountDataWrappers.add(parentAdw);
        }
        if ((corporateAdw = this.authService.getCorporateAccountLoginData(token)) != null) {
            corporateAdw.setBest_practices(this.configurationService.getConfiguration().getBest_practices());
            corporateAdw.setMarketing_materials(this.configurationService.getConfiguration().getMarketing_materials());
            corporateAdw.setContact(this.configurationService.getConfiguration().getContact());
            corporateAdw.setTheClymbingGuide(theClymbingGuide);
            accountDataWrappers.add(corporateAdw);
        }
        if (!AppUtils.isNullOrEmpty(accountDataWrappers)) {
            return new ResponseEntity(accountDataWrappers, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/sign-up/instructor"})
    @ResponseBody
    public ResponseEntity<Instructor> signUpInstructor(@RequestBody InstructorSignUpRequest request) throws IOException {
        Object cleverSchool;
        if (AppUtils.isNullOrEmpty((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        School school = this.schoolRepository.findBySchoolId(Long.valueOf(request.getInstructor().getSchool_id()));
        if (school == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        Instructor instructor = new Instructor();
        instructor.setAuto_approve_wall_posts(school.isAuto_approve_wall_posts());
        District district = this.districtRepository.findByDistrictId(Long.valueOf(school.getDistrict_id()));
        if (district != null) {
            if (this.organizationService.isDeletedDistrict(district.getDistrict_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
            }
            if (!this.organizationService.isActiveDistrict(district.getDistrict_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
            }
            if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
                this.isActiveAndValidLicenseKey(district.getLicense_key(), district.getLicence_key_expiry_date());
            } else {
                trialIsActivie = this.freeTrialService.checkTrialActiveByDistrictId(district.getDistrict_id());
                if (!trialIsActivie) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getFree_trial_expired());
                }
            }
            if (!AppUtils.isNullOrEmpty((String)request.getInstructor().getClever_id())) {
                this.cleverDataService.isCleverIdAlreadyInUse(request.getInstructor().getClever_id());
                if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.clever.id"));
                }
                AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
                if (accessToken == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.valid.clever.id"));
                }
                if (AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.has.no.clever.id"));
                }
                cleverSchool = this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), school.getClever_id());
                if (cleverSchool == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.has.no.valid.clever.id"));
                }
                if (!cleverSchool.getDistrict().equals(district.getClever_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("your.school.s.clever.district.is.different.than.clymb.district"));
                }
                CleverInstructor cleverInstructor = this.cleverInstructorService.getCleverInstructorByCleverId(accessToken.getAccess_token(), request.getInstructor().getClever_id());
                if (cleverInstructor == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
                }
                if (!cleverInstructor.getRoles().getTeacher().getSchool().equals(cleverSchool.getId())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.primary.school.is.different.than.clymb.primary.school"));
                }
                instructor.setClever_id(request.getInstructor().getClever_id());
            }
        } else {
            if (this.organizationService.isDeletedSchool(school.getSchool_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
            }
            if (!this.organizationService.isActiveSchool(school.getSchool_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
            }
            if (AppUtils.isNotNullOrEmpty((String)school.getLicense_key())) {
                this.isActiveAndValidLicenseKey(school.getLicense_key(), school.getLicence_key_expiry_date());
            } else {
                trialIsActivie = this.freeTrialService.checkTrialActiveBySchoolId(school.getSchool_id());
                if (!trialIsActivie) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getFree_trial_expired());
                }
            }
        }
        Account account = this.accountService.createAccountByEmailAndPassword(request.getUsername(), request.getPassword());
        instructor.setFirst_name(request.getInstructor().getFirst_name());
        instructor.setLast_name(request.getInstructor().getLast_name());
        instructor.setAccount(account);
        instructor.setSchool_id(request.getInstructor().getSchool_id());
        instructor.setState(request.getInstructor().getState());
        instructor.setCity(request.getInstructor().getCity());
        instructor.setLanguage(Language.getLanguage());
        cleverSchool = request.getStandard_ids().iterator();
        while (cleverSchool.hasNext()) {
            long standard_id = (Long)cleverSchool.next();
            Standard standard = this.standardRepository.findByStandardId(Long.valueOf(standard_id));
            if (standard == null) continue;
            instructor.getStandards().add(standard);
        }
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Instructor x = this.instructorRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                instructor.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        Instructor i = (Instructor)this.instructorRepository.save((Object)instructor);
        return new ResponseEntity((Object)i, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/parent"})
    @ResponseBody
    public ResponseEntity<Parent> signUpParent(@RequestBody ParentSignUpRequest request) throws IOException {
        ValidationResponse validationResponse;
        if (AppUtils.isNullOrEmpty((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        Corporate corporate = this.corporateService.getCorporateById(request.getParent().getCorporate_id());
        School school = this.schoolService.getSchoolById(request.getParent().getSchool_id());
        Student student = this.studentRepository.findByStudentId(Long.valueOf(request.getParent().getStudent_id()));
        if (corporate == null && school == null && student == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        if (corporate != null) {
            if (this.corporateService.isDeletedCorporate(corporate.getCorporate_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
            }
            if (!this.corporateService.isActiveCorporate(corporate.getCorporate_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
            }
            if (AppUtils.isNotNullOrEmpty((String)corporate.getLicense_key())) {
                this.isActiveAndValidLicenseKey(corporate.getLicense_key(), corporate.getLicence_key_expiry_date());
            }
        }
        if (corporate != null) {
            if (this.corporateService.isDeletedCorporate(corporate.getCorporate_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
            }
            if (!this.corporateService.isActiveCorporate(corporate.getCorporate_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
            }
            if (AppUtils.isNotNullOrEmpty((String)corporate.getLicense_key())) {
                this.isActiveAndValidLicenseKey(corporate.getLicense_key(), corporate.getLicence_key_expiry_date());
            }
        }
        Parent parent = new Parent();
        if (school != null) {
            District district = this.districtRepository.findByDistrictId(Long.valueOf(school.getDistrict_id()));
            if (district != null) {
                if (this.organizationService.isDeletedDistrict(district.getDistrict_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
                }
                if (!this.organizationService.isActiveDistrict(district.getDistrict_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
                }
                if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
                    this.isActiveAndValidLicenseKey(district.getLicense_key(), district.getLicence_key_expiry_date());
                } else {
                    trialIsActivie = this.freeTrialService.checkTrialActiveByDistrictId(district.getDistrict_id());
                    if (!trialIsActivie) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getFree_trial_expired());
                    }
                }
                if (!AppUtils.isNullOrEmpty((String)request.getParent().getClever_id())) {
                    this.cleverDataService.isCleverIdAlreadyInUse(request.getParent().getClever_id());
                    if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.clever.id"));
                    }
                    AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
                    if (accessToken == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.valid.clever.id"));
                    }
                    if (AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.has.no.clever.id"));
                    }
                    CleverSchool cleverSchool = this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), school.getClever_id());
                    if (cleverSchool == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.school.has.no.valid.clever.id"));
                    }
                    if (!cleverSchool.getDistrict().equals(district.getClever_id())) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("your.school.s.clever.district.is.different.than.clymb.district"));
                    }
                    CleverParent cleverParent = this.cleverParentService.getCleverParentById(accessToken.getAccess_token(), request.getParent().getClever_id());
                    if (cleverParent == null) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
                    }
                    if (!cleverParent.getDistrict().equals(cleverSchool.getDistrict())) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("your.clever.district.is.different.than.clymb.district"));
                    }
                    parent.setClever_id(request.getParent().getClever_id());
                }
                parent.setDistrict_id(district.getDistrict_id());
                parent.setSchool_id(request.getParent().getSchool_id());
            } else {
                if (this.organizationService.isDeletedSchool(school.getSchool_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
                }
                if (!this.organizationService.isActiveSchool(school.getSchool_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
                }
                if (AppUtils.isNotNullOrEmpty((String)school.getLicense_key())) {
                    this.isActiveAndValidLicenseKey(school.getLicense_key(), school.getLicence_key_expiry_date());
                } else {
                    trialIsActivie = this.freeTrialService.checkTrialActiveBySchoolId(school.getSchool_id());
                    if (!trialIsActivie) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getFree_trial_expired());
                    }
                }
            }
        }
        if (student != null && !(validationResponse = this.validationService.isValidStudent(request.getParent().getStudent_id())).isValid()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)this.accountRepository.save((Object)account);
        parent.setFirst_name(request.getParent().getFirst_name());
        parent.setLast_name(request.getParent().getLast_name());
        parent.setAccount(a);
        if (corporate != null) {
            parent.setCorporate_id(request.getParent().getCorporate_id());
        }
        if (school != null) {
            parent.setSchool_id(school.getSchool_id());
            parent.setDistrict_id(school.getDistrict_id());
        }
        if (student != null) {
            parent.getStudents().add(student);
            if (student.getSchool() != null) {
                parent.setSchool_id(student.getSchool().getSchool_id());
                parent.setDistrict_id(student.getSchool().getDistrict_id());
            }
        }
        parent.setCity(request.getParent().getCity());
        parent.setState(request.getParent().getState());
        parent.setLanguage(Language.getLanguage());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "P" + KeyGenerator.generateUniqueAuthCode();
            Parent x = this.parentService.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                parent.setRegistration_code("P" + possible_code);
                continue;
            }
            isUnique = false;
        }
        Parent p = this.parentService.save(parent);
        return new ResponseEntity((Object)p, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/district"})
    @ResponseBody
    public ResponseEntity<District> signUpDistrict(@RequestBody DistrictSignUpRequest request) throws IOException {
        if (AppUtils.isNullOrEmpty((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        this.checkLicenseKeyStatus(request.getDistrict().getLicense_key());
        Invoice invoice = this.invoiceService.getInvoiceByLicenseKey(request.getDistrict().getLicense_key());
        if (!invoice.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.create.account.at.the.moment.please.try.after.some.time"));
        }
        District d = new District();
        d.setDistrict_name(request.getDistrict().getDistrict_name());
        if (!AppUtils.isNullOrEmpty((String)request.getDistrict().getClever_id())) {
            this.cleverDataService.isCleverIdAlreadyInUse(request.getDistrict().getClever_id());
            AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(request.getDistrict().getClever_id());
            if (accessToken == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            CleverDistrict cleverDistrict = this.cleverDistrictService.getDistrictById(accessToken.getAccess_token(), request.getDistrict().getClever_id());
            if (cleverDistrict == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            d.setClever_id(request.getDistrict().getClever_id());
            d.setDistrict_name(cleverDistrict.getName());
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)this.accountRepository.save((Object)account);
        d.setCity(request.getDistrict().getCity());
        d.setState(request.getDistrict().getState());
        d.setAccount_id(a.getAccount_id());
        d.setLicense_key(request.getDistrict().getLicense_key());
        d.setLicence_key_added_date(new Date());
        d.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        d.setActive(true);
        d.setNumber_of_youth(invoice.getNumber_of_youth());
        d.setFocus_on(request.getDistrict().getFocus_on());
        d.setLanguage(Language.getLanguage());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "D" + KeyGenerator.generateUniqueAuthCode();
            District x = this.districtRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                d.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        District district = (District)this.districtRepository.save((Object)d);
        this.invoiceService.updateOrganizationIdByInvoiceId(invoice.getInvoice_id(), district.getDistrict_id());
        return new ResponseEntity((Object)d, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/school"})
    @ResponseBody
    public ResponseEntity<School> signUpSchool(@RequestBody SchoolSignUpRequest request) throws IOException {
        if (AppUtils.isNullOrEmpty((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        School s = new School();
        s.setAddress(request.getSchool().getAddress());
        s.setSchool_name(request.getSchool().getSchool_name());
        s.setAuto_approve_wall_posts(true);
        s.setEnable_wow(true);
        s.setEnable_journal(true);
        s.setLanguage(Language.getLanguage());
        District district = this.districtRepository.findByDistrictId(Long.valueOf(request.getSchool().getDistrict_id()));
        if (district != null) {
            if (this.organizationService.isDeletedDistrict(district.getDistrict_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deletes());
            }
            if (!this.organizationService.isActiveDistrict(district.getDistrict_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getAdmin_deactivates());
            }
            if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
                this.isActiveAndValidLicenseKey(district.getLicense_key(), district.getLicence_key_expiry_date());
            } else {
                boolean trialIsActive = this.freeTrialService.checkTrialActiveByDistrictId(district.getDistrict_id());
                if (!trialIsActive) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage().getFree_trial_expired());
                }
            }
            if (!AppUtils.isNullOrEmpty((String)request.getSchool().getClever_id())) {
                this.cleverDataService.isCleverIdAlreadyInUse(request.getSchool().getClever_id());
                if (AppUtils.isNullOrEmpty((String)district.getClever_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.has.no.valid.clever.id"));
                }
                AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(district.getClever_id());
                if (accessToken == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
                }
                CleverSchool cleverSchool = this.cleverSchoolService.getCleverSchoolById(accessToken.getAccess_token(), request.getSchool().getClever_id());
                if (cleverSchool == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
                }
                if (!cleverSchool.getDistrict().equals(district.getClever_id())) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("your.school.s.clever.district.is.different.than.clymb.district"));
                }
                s.setClever_id(request.getSchool().getClever_id());
                s.setSchool_name(cleverSchool.getName());
                s.setAddress(cleverSchool.getLocation().getAddress() + ", " + cleverSchool.getLocation().getCity() + ", " + cleverSchool.getLocation().getState() + " " + cleverSchool.getLocation().getZip());
            }
        } else {
            Invoice invoice;
            if (AppUtils.isNullOrEmpty((String)request.getSchool().getLicense_key()) && request.getSchool().getDistrict_id() < 1L) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("please.provide.a.license.key.or.valid.district_id"));
            }
            if (AppUtils.isNotNullOrEmpty((String)request.getSchool().getLicense_key())) {
                this.checkLicenseKeyStatus(request.getSchool().getLicense_key());
            }
            if (!(invoice = this.invoiceService.getInvoiceByLicenseKey(request.getSchool().getLicense_key())).getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
            }
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)this.accountRepository.save((Object)account);
        s.setDistrict_id(request.getSchool().getDistrict_id());
        s.setAccount_id(a.getAccount_id());
        s.setFocus_on(request.getSchool().getFocus_on());
        Invoice invoice = null;
        if (AppUtils.isNotNullOrEmpty((String)request.getSchool().getLicense_key()) && district == null) {
            invoice = this.invoiceService.getInvoiceByLicenseKey(request.getSchool().getLicense_key());
            s.setLicense_key(request.getSchool().getLicense_key());
            s.setLicence_key_added_date(new Date());
            s.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
            s.setNumber_of_youth(invoice.getNumber_of_youth());
        }
        s.setActive(district == null);
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = "S" + KeyGenerator.generateUniqueAuthCode();
            School x = this.schoolRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                s.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        School school = (School)this.schoolRepository.save((Object)s);
        if (invoice != null) {
            this.invoiceService.updateOrganizationIdByInvoiceId(invoice.getInvoice_id(), school.getSchool_id());
        }
        try {
            if (!AppUtils.isNullOrEmpty((String)school.getClever_id())) {
                this.cleverSchoolSyncService.syncSchool(school.getSchool_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResponseEntity((Object)s, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/corporate"})
    @ResponseBody
    public ResponseEntity<Corporate> signUpCorporate(@RequestBody CorporateSignUpRequest request) throws IOException {
        if (AppUtils.isNullOrEmpty((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)request.getUsername())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        this.checkLicenseKeyStatus(request.getCorporate().getLicense_key());
        Invoice invoice = this.invoiceService.getInvoiceByLicenseKey(request.getCorporate().getLicense_key());
        if (!invoice.getOrganization_type().equals((Object)OrganizationType.CORPORATE)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)this.accountRepository.save((Object)account);
        Corporate c = new Corporate();
        c.setCorporate_name(request.getCorporate().getCorporate_name());
        c.setAddress(request.getCorporate().getAddress());
        c.setAccount(a);
        c.setLicense_key(request.getCorporate().getLicense_key());
        c.setLicence_key_added_date(new Date());
        c.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        c.setActive(true);
        c.setNumber_of_youth(invoice.getNumber_of_youth());
        c.setCorporate_image(request.getCorporate().getCorporate_image());
        c.setCorporate_image_2(request.getCorporate().getCorporate_image_2());
        c.setLanguage(Language.getLanguage());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Corporate x = this.corporateService.getByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                c.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        Corporate corporate = this.corporateService.save(c);
        this.invoiceService.updateOrganizationIdByInvoiceId(invoice.getInvoice_id(), corporate.getCorporate_id());
        return new ResponseEntity((Object)c, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/schools"})
    public ResponseEntity<List<School>> getAllSchools() {
        return new ResponseEntity((Object)this.schoolRepository.findAll(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/districts"})
    public ResponseEntity<List<District>> getAllDistricts() {
        return new ResponseEntity((Object)this.districtRepository.findAll(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/import/students"})
    public ResponseEntity<List<Student>> importStudents(@RequestBody List<StudentsSignUpRequest> studentsSignUpRequests) {
        if (AppUtils.isNullOrEmpty(studentsSignUpRequests)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("students.are.not.found"));
        }
        ObjectMapper mapper = new ObjectMapper();
        List students = (List)mapper.convertValue(studentsSignUpRequests, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        ValidationResponse validationResponse = this.validationService.isValidInstructor(((StudentsSignUpRequest)students.get(0)).getInstructor_id());
        if (!validationResponse.isValid()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
        }
        validationResponse = this.validationService.isReachedToTierNoOfYouthLimitByInstructorId(((StudentsSignUpRequest)students.get(0)).getInstructor_id(), (long)students.size());
        if (!validationResponse.isValid()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
        }
        students = students.parallelStream().peek(request -> {
            if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("first.name.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("last.name.is.required"));
            }
            if (AppUtils.isNullOrEmpty((String)request.getPassword())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("password.is.required"));
            }
            this.instructorService.isValidInstructor(request.getInstructor_id());
            if (AppUtils.isNotNullOrEmpty((String)request.getPhone()) && !this.smsService.isValidPhone(request.getPhone())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, request.getFirst_name() + " " + request.getLast_name() + "'s " + this.messageService.getMessage("phone.number.is.not.valid"));
            }
            if (AppUtils.isNotNullOrEmpty((String)request.getEmail()) && !AppUtils.isValidateEmail((String)request.getEmail())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
            }
        }).collect(Collectors.toList());
        List registeredStudents = students.parallelStream().map(request -> {
            Account a = this.accountService.createAccountByPassword(request.getPassword());
            Instructor i = this.instructorService.isValidInstructor(request.getInstructor_id());
            Parent parent = this.parentService.createParent(i.getSchool_id(), request.getCountry_code(), request.getPhone(), request.getEmail());
            Student student = new Student();
            student.setAccount(a);
            student.setFirst_name(request.getFirst_name());
            student.setLast_name(request.getLast_name());
            student.setInstructor(i);
            student.setParent(parent);
            return student;
        }).collect(Collectors.toList());
        this.studentRepository.saveAll(registeredStudents);
        new Thread(() -> {
            for (Student student : registeredStudents) {
                this.studentService.generateRegistrationCodeForStudent(student);
            }
        }).start();
        new Thread(() -> {
            for (Student s : registeredStudents) {
                this.parentService.sendSMSandEmailToParent(s);
            }
        }).start();
        return new ResponseEntity(registeredStudents, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/first/sign-in/student"})
    @ResponseBody
    public ResponseEntity<Student> firstSignInStudent(@RequestBody StudentsSignUpRequest request) {
        List students = this.studentService.getStudentsByFirstNameAndLastName(request.getFirst_name(), request.getLast_name());
        if (AppUtils.isNotNullOrEmpty((List)students)) {
            for (Student student : students) {
                Account a = this.accountService.getAccountById(student.getAccount_id());
                if (!AppUtils.isNullOrEmpty((String)a.getUsername2()) || !this.bCryptPasswordEncoder.matches((CharSequence)request.getPassword(), a.getPassword())) continue;
                ValidationResponse isValidStudent = this.validationService.isValidStudent(student.getStudent_id());
                if (!isValidStudent.isValid()) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, isValidStudent.getMessage());
                }
                return new ResponseEntity((Object)student, (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/first/sign-in/update/student-details"})
    @ResponseBody
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> firstSignInUpdateStudentDetails(@RequestHeader(value="operating_system", required=false) String operating_system, @RequestBody StudentSignUpRequest request) {
        Account account;
        if (!AppUtils.isNullOrEmpty((String)request.getStudent().getClever_id())) {
            this.cleverDataService.isCleverIdAlreadyInUse(request.getStudent().getClever_id());
        }
        if (AppUtils.isNotNullOrEmpty((String)(account = this.accountService.isValidAccount(request.getStudent().getAccount_id())).getUsername2())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("this.user.have.already.completed.the.first.sign.in.process"));
        }
        Student student = this.studentService.isValidStudent(request.getStudent().getStudent_id());
        this.validationService.isValidStudentSignUpRequest(request, operating_system);
        account = this.accountService.updateAccount(account.getAccount_id(), request.getPassword(), request.getUsername(), request.getUsername2());
        Avatar avatar = this.avatarService.getAvatarById(request.getStudent().getAvatar_id());
        Standard std = this.standardService.getStandardById(request.getStudent().getStandard_id());
        Instructor instructor = this.instructorService.getInstructorById(request.getStudent().getInstructor_id());
        Parent parent = this.parentService.getParentById(request.getStudent().getParent_id());
        if (parent == null) {
            parent = this.parentService.getParentById(student.getParent_id());
        }
        Student s = this.studentAuthService.updateStudent(student.getStudent_id(), request.getStudent().getFirst_name(), request.getStudent().getLast_name(), instructor, account, avatar, request.getStudent().getDate_of_birth(), request.getStudent().getEthnicity(), request.getStudent().getGender(), std, request.getStudent().getAppType(), request.getStudent().getOperating_system(), request.getStudent().getBrowser(), parent, request.getStudent().getClever_id());
        return new ResponseEntity((Object)new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage().getStudent_sign_up()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/student"})
    @ResponseBody
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> signUpStudent(@RequestHeader(value="operating_system", required=false) String operating_system, @RequestBody StudentSignUpRequest request) {
        if (!AppUtils.isNullOrEmpty((String)request.getStudent().getClever_id())) {
            this.cleverDataService.isCleverIdAlreadyInUse(request.getStudent().getClever_id());
        }
        this.validationService.isValidStudentSignUpRequest(request, operating_system);
        ValidationResponse validationResponse = this.validationService.isReachedToTierNoOfYouthLimitByInstructorIdOrParentId(request.getStudent().getInstructor_id(), request.getStudent().getParent_id(), 1L);
        if (!validationResponse.isValid()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
        }
        Account account = this.accountService.createAccount(request.getUsername(), request.getUsername2(), request.getPassword());
        Avatar avatar = this.avatarService.getAvatarById(request.getStudent().getAvatar_id());
        Standard std = this.standardService.getStandardById(request.getStudent().getStandard_id());
        Instructor instructor = this.instructorService.getInstructorById(request.getStudent().getInstructor_id());
        Parent parent = this.parentService.getParentById(request.getStudent().getParent_id());
        Student s = this.studentAuthService.createStudent(request.getStudent().getFirst_name(), request.getStudent().getLast_name(), instructor, account, avatar, request.getStudent().getDate_of_birth(), request.getStudent().getEthnicity(), request.getStudent().getGender(), std, request.getStudent().getAppType(), request.getStudent().getOperating_system(), request.getStudent().getBrowser(), parent, request.getStudent().getClever_id());
        return new ResponseEntity((Object)new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage().getStudent_sign_up()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/school"})
    public ResponseEntity<School> searchForSchool(@RequestBody SearchSchoolRequest request) {
        School s = this.schoolRepository.findByRegistrationCode(request.getCode());
        if (s == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)s, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/district"})
    public ResponseEntity<District> searchForDistrict(@RequestBody SearchDistrictRequest request) {
        District d = this.districtRepository.findByRegistrationCode(request.getCode());
        if (d == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.districtRepository.findByRegistrationCode(request.getCode()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/student"})
    public ResponseEntity<StudentView> searchForStudent(@RequestBody SearchInstructorRequest request) {
        StudentView studentView = this.studentRepository.findStudentViewByRegistrationCode(request.getCode());
        if (studentView == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)studentView, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/instructor"})
    public ResponseEntity<Instructor> searchForInstructor(@RequestBody SearchInstructorRequest request) {
        Instructor i = this.instructorRepository.findByRegistrationCode(request.getCode());
        if (i == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)i, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/search/instructorWithGradeId"})
    public ResponseEntity<Instructor> searchForInstructorWithGrade(@RequestParam(value="code", defaultValue="aEn24") String code, @RequestParam(value="grade_id", defaultValue="aEn24") Integer grade_id) {
        Instructor i = this.instructorRepository.findByRegistrationCode(code);
        if (i == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("teacher.could.not.be.found"));
        }
        Account account = this.accountRepository.findByAccountId(i.getAccount_id());
        if (account == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("teacher.could.not.be.found"));
        }
        for (Standard standard : i.getStandards()) {
            if (standard.getGrade_id() != (long)grade_id.intValue()) continue;
            return new ResponseEntity((Object)i, (HttpStatusCode)HttpStatus.OK);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("teacher.could.not.be.found"));
    }

    @PostMapping(value={"/search/corporate"})
    public ResponseEntity<Corporate> searchForCorporate(@RequestBody SearchCorporateRequest request) {
        Corporate c = this.corporateService.getByRegistrationCode(request.getCode());
        if (c == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)c, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/search/parent"})
    public ResponseEntity<ParentCoreDTO> searchForParent(@RequestBody SearchParentRequest request) {
        ParentCoreDTO p = this.parentCoreRepository.findByRegistrationCode(request.getCode());
        if (p == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)p, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/set/avatar"})
    public ResponseEntity<Student> setAvatar(@RequestParam(value="student_id", defaultValue="aEn24") long student_id, @RequestParam(value="avatar_id", defaultValue="aEn24") long avatar_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        Avatar a = (Avatar)this.avatarRepository.getOne((Object)avatar_id);
        if (a == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        s.setAvatar_id(avatar_id);
        return new ResponseEntity((Object)((Student)this.studentRepository.save((Object)s)), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/avatars"})
    public ResponseEntity<List<Avatar>> getAvatars() {
        return new ResponseEntity((Object)this.avatarRepository.findAll(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/check-username-availability"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> checkUsernameAvailability(@RequestBody CheckUsernameAvailabilityRequest request) {
        Account account = this.accountRepository.findByUsername(request.getUsername());
        if (account != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("this.email.not.registered"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/check-username2-availability"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> checkUsername2Availability(@RequestBody CheckUsername2AvailabilityRequest request) {
        Account existingUser = this.accountRepository.findByUsername2(request.getUsername2());
        if (existingUser != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("this.user.name.is.not.available"));
        }
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("this.user.name.is.available"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/request-subscription"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> requestSubscription(@RequestHeader(value="Authorization") String token, @RequestBody CheckLicenseKeyStatusRequest request) throws IOException {
        String name_of_organization = null;
        String language = null;
        if (request.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.authService.isDistrict(token);
            name_of_organization = district.getDistrict_name();
            language = district.getLanguage();
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            List schools = this.authService.isSchool(token);
            School school = null;
            if (!AppUtils.isNullOrEmpty((List)schools)) {
                school = schools.stream().filter(item -> item.getSchool_id() == request.getOrganization_id()).findFirst().orElse(null);
            }
            if (school == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            name_of_organization = school.getSchool_name();
            language = school.getLanguage();
        }
        try {
            this.emailClient.sendEmail(token, SendEmailRequest.builder().to(this.configurationService.getConfiguration().getAdmin_email()).subject(Language.isSpanish((String)language) ? "Clymb - Solicitar suscripci\u00f3n" : "Clymb - Request Subscription").body(name_of_organization + (Language.isSpanish((String)language) ? " ha solicitado la suscripci\u00f3n.<br>" : " has requested for subscription.<br>") + "<br>" + (Language.isSpanish((String)language) ? "Hacia arriba,<br>" : "Upward,<br>") + (Language.isSpanish((String)language) ? "El equipo Clymb" : "The Clymb Team")).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, e.getLocalizedMessage());
        }
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("subscription.request.submitted.successfully"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/check-licenses-key-status"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> checkLicenseKeyStatus(@RequestBody CheckLicenseKeyStatusRequest request) throws IOException {
        this.checkLicenseKeyStatus(request.getLicense_key());
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("the.license.key.is.an.active.license.key"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/renew-subscription"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> renewSubscription(@RequestHeader(value="Authorization") String token, @RequestBody CheckLicenseKeyStatusRequest request) throws IOException {
        if (AppUtils.isNullOrEmpty((String)request.getLicense_key())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("require.a.license.key"));
        }
        Invoice invoice = this.invoiceService.getInvoiceByLicenseKey(request.getLicense_key());
        if (invoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.license.key"));
        }
        if (!invoice.getOrganization_type().toString().equals(request.getOrganization_type().toString())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.license.key"));
        }
        if (DateUtils.checkDateTimeIsPassed((Date)DateUtils.getNextYearDateFromDate((Date)invoice.getCreatedAt()))) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.license.key.is.expired"));
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.authService.isDistrict(token);
            if (invoice.getOrganization_id() != district.getDistrict_id()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.license.key"));
            }
            district.setLicense_key(invoice.getLicense_key());
            district.setLicence_key_added_date(new Date());
            district.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
            district.setActive(true);
            district.setNumber_of_youth(invoice.getNumber_of_youth());
            this.districtRepository.save((Object)district);
            FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.LARGE_ORGANIZATION.toString(), district.getDistrict_id());
            if (freeTrial != null) {
                this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
            }
            com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("the.license.key.is.updated.successfully"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            List schools = this.authService.isSchool(token);
            School school = null;
            if (!AppUtils.isNullOrEmpty((List)schools)) {
                school = schools.stream().filter(item -> item.getSchool_id() == request.getOrganization_id()).findFirst().orElse(null);
            }
            if (school == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
            }
            if (invoice.getOrganization_id() != school.getSchool_id()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("invalid.license.key"));
            }
            school.setLicense_key(invoice.getLicense_key());
            school.setLicence_key_added_date(new Date());
            school.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
            school.setActive(true);
            school.setNumber_of_youth(invoice.getNumber_of_youth());
            this.schoolRepository.save((Object)school);
            FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.ORGANIZATION.toString(), school.getSchool_id());
            if (freeTrial != null) {
                this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
            }
            com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("the.license.key.is.updated.successfully"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.type.is.not.found"));
    }

    private void checkLicenseKeyStatus(String license_key) throws IOException {
        boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
        if (!should_validate_license_key) {
            return;
        }
        if (AppUtils.isNullOrEmpty((String)license_key)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("require.a.license.key"));
        }
        List schools = this.schoolRepository.findByLicenseKey(license_key);
        if (schools != null && !schools.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.license.key.already.exists"));
        }
        List districts = this.districtRepository.findByLicenseKey(license_key);
        if (districts != null && !districts.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.license.key.already.exists"));
        }
        Invoice invoice = this.invoiceService.getInvoiceByLicenseKey(license_key);
        if (invoice == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
        }
        this.isActiveAndValidLicenseKey(invoice.getLicense_key(), DateUtils.getNextYearDateFromDate((Date)invoice.getUpdatedAt()));
    }

    private void isActiveAndValidLicenseKey(String license_key, Date expiryDate) throws IOException {
        boolean should_validate_license_key = this.configurationService.getConfiguration().isShould_validate_license_key();
        if (!should_validate_license_key) {
            return;
        }
        if (AppUtils.isNullOrEmpty((String)license_key)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
        }
        if (expiryDate != null && DateUtils.checkDateTimeIsPassed((Date)expiryDate)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage().getSubscription_expired());
        }
    }

    @PostMapping(value={"/is-active-user"})
    public ResponseEntity<Object> isActiveUser(@RequestHeader(value="Authorization") String token, @RequestBody(required=false) IsActiveUserRequest request) {
        Student s = this.authService.getStudentByToken(token);
        if (s != null) {
            ValidationResponse validationResponse = this.validationService.isValidStudent(s.getStudent_id());
            if (validationResponse.isValid()) {
                ValidationResponse validationResponse1 = this.validationService.isOverToNoOfYouthLimit(s);
                if (!validationResponse1.isValid()) {
                    validationResponse.setValid(validationResponse1.isValid());
                    validationResponse.setMessage(validationResponse1.getMessage());
                } else {
                    validationResponse.setFromCorporate(validationResponse1.isFromCorporate());
                    validationResponse.setFromDistrict(validationResponse1.isFromDistrict());
                    validationResponse.setFromSchool(validationResponse1.isFromSchool());
                }
            }
            if (!validationResponse.isValid()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message();
            if (validationResponse.isFromSchool()) {
                if (!validationResponse.isOnTrial()) {
                    message.setMessage(this.messageService.getMessage("the.school.subscription.is.active"));
                } else {
                    message.setMessage(this.messageService.getMessage("the.school.trial.is.active"));
                }
            } else if (validationResponse.isFromDistrict()) {
                if (!validationResponse.isOnTrial()) {
                    message.setMessage(this.messageService.getMessage("the.district.subscription.is.active"));
                } else {
                    message.setMessage(this.messageService.getMessage("the.district.trial.is.active"));
                }
            } else if (validationResponse.isFromCorporate()) {
                if (!validationResponse.isOnTrial()) {
                    message.setMessage(this.messageService.getMessage("the.corporate.subscription.is.active"));
                } else {
                    message.setMessage(this.messageService.getMessage("the.corporate.trial.is.active"));
                }
            }
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        List schools = this.authService.getSchoolByToken(token);
        School school = null;
        if (!AppUtils.isNullOrEmpty((List)schools) && request != null && request.getOrganization_id() != null && request.getOrganization_id() > 0L && (school = (School)schools.stream().filter(item -> item.getSchool_id() == request.getOrganization_id().longValue()).findFirst().orElse(null)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        if (school != null) {
            ValidationResponse validationResponse = this.validationService.isValidSchool(school.getSchool_id());
            if (!(validationResponse.isFromSchool() || !validationResponse.isDeleted() && validationResponse.isActive() && validationResponse.isSubscriptionActive())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            if (!validationResponse.isFromSchool()) {
                if (!validationResponse.isOnTrial()) {
                    validationResponse.setMessage(this.messageService.getMessage("the.district.subscription.is.active"));
                } else {
                    validationResponse.setMessage(this.messageService.getMessage("the.district.trial.is.active"));
                }
            } else {
                if (!validationResponse.isOnTrial() && validationResponse.isSubscriptionActive() && validationResponse.isActive()) {
                    validationResponse.setMessage(this.messageService.getMessage("the.school.subscription.is.active"));
                }
                if (validationResponse.isOnTrial() && validationResponse.isSubscriptionActive() && validationResponse.isActive()) {
                    validationResponse.setMessage(this.messageService.getMessage("the.school.trial.is.active"));
                }
            }
            return new ResponseEntity((Object)validationResponse, (HttpStatusCode)HttpStatus.OK);
        }
        Instructor instructor = this.authService.getInstructorByToken(token);
        if (instructor != null) {
            ValidationResponse validationResponse = this.validationService.isValidInstructor(instructor.getInstructor_id());
            if (!validationResponse.isValid()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message();
            if (validationResponse.isFromSchool()) {
                if (!validationResponse.isOnTrial()) {
                    message.setMessage(this.messageService.getMessage("the.school.subscription.is.active"));
                } else {
                    message.setMessage(this.messageService.getMessage("the.school.trial.is.active"));
                }
            } else if (!validationResponse.isOnTrial()) {
                message.setMessage(this.messageService.getMessage("the.district.subscription.is.active"));
            } else {
                message.setMessage(this.messageService.getMessage("the.district.trial.is.active"));
            }
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        District district = this.authService.getDistrictByToken(token);
        if (district != null) {
            ValidationResponse validationResponse = this.validationService.isValidDistrict(district.getDistrict_id());
            if (!validationResponse.isOnTrial() && validationResponse.isSubscriptionActive() && validationResponse.isActive()) {
                validationResponse.setMessage(this.messageService.getMessage("the.district.subscription.is.active"));
            }
            if (validationResponse.isOnTrial() && validationResponse.isSubscriptionActive() && validationResponse.isActive()) {
                validationResponse.setMessage(this.messageService.getMessage("the.district.trial.is.active"));
            }
            return new ResponseEntity((Object)validationResponse, (HttpStatusCode)HttpStatus.OK);
        }
        Parent parent = this.authService.getParentByToken(token);
        if (parent != null) {
            ValidationResponse validationResponse = this.validationService.isValidParent(parent.getParent_id());
            if (!validationResponse.isValid()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message();
            if (!validationResponse.isOnTrial()) {
                message.setMessage(this.messageService.getMessage("the.corporate.subscription.is.active"));
            } else {
                message.setMessage(this.messageService.getMessage("the.corporate.trial.is.active"));
            }
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        Corporate corporate = this.authService.getCorporateByToken(token);
        if (corporate != null) {
            ValidationResponse validationResponse = this.validationService.isValidCorporate(corporate.getCorporate_id());
            if (!validationResponse.isOnTrial() && validationResponse.isSubscriptionActive() && validationResponse.isActive()) {
                validationResponse.setMessage(this.messageService.getMessage("the.corporate.subscription.is.active"));
            }
            if (validationResponse.isOnTrial() && validationResponse.isSubscriptionActive() && validationResponse.isActive()) {
                validationResponse.setMessage(this.messageService.getMessage("the.corporate.trial.is.active"));
            }
            return new ResponseEntity((Object)validationResponse, (HttpStatusCode)HttpStatus.OK);
        }
        throw new NotFoundException(this.messageService.getMessage("user.not.found"));
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> forgotUserPassword(@RequestBody ForgotUserPasswordRequest request) throws MessagingException {
        Account account = this.accountRepository.findByUsername(request.getUsername());
        String errorMessage = this.messageService.getMessage("this.email.does.not.exist");
        if (account == null) {
            account = this.accountRepository.findByUsername2(request.getUsername());
            errorMessage = this.messageService.getMessage("this.email.or.username.does.not.exist");
        }
        if (account == null) {
            throw new NotFoundException(errorMessage);
        }
        ConfirmationToken confirmationToken = new ConfirmationToken(account);
        this.confirmationTokenRepository.save((Object)confirmationToken);
        String baseUrl = this.configurationService.getConfiguration().getBaseUrl() + "reset/password/";
        Student s = this.studentRepository.findByAccountId(Long.valueOf(account.getAccount_id()));
        if (s != null) {
            baseUrl = this.configurationService.getConfiguration().getBaseUrlStudent() + "account/reset-password/";
        }
        String resetPasswordLink = baseUrl + confirmationToken.getConfirmationToken();
        this.emailClient.forgotPassword(SendForgotPasswordEmailRequest.builder().to(account.getUsername()).reset_password_link(resetPasswordLink).language(LocaleContextHolder.getLocale().getLanguage()).build());
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("request.to.reset.password.received.check.your.inbox.for.the.reset.link"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/confirm-reset"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> validateResetToken(@RequestBody ResetPasswordRequest resetPasswordRequest) {
        ConfirmationToken token = this.confirmationTokenRepository.findByConfirmationToken(resetPasswordRequest.getToken());
        if (token != null) {
            long diff = new Date().getTime() - token.getCreatedDate().getTime();
            long diffMinutes = diff / 60000L;
            if (diffMinutes > 15L) {
                throw new TimeOutException(this.messageService.getMessage("the.link.has.been.expired") + diffMinutes);
            }
            com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("the.token.matched"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        throw new NotFoundException(this.messageService.getMessage("the.token.not.found"));
    }

    @PostMapping(value={"/reset-password"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> resetUserPassword(@RequestBody ResetPasswordRequest resetPasswordRequest) {
        ConfirmationToken token = this.confirmationTokenRepository.findByConfirmationToken(resetPasswordRequest.getToken());
        if (token == null) {
            throw new NotFoundException(this.messageService.getMessage("the.token.not.found"));
        }
        String username = token.getAccount().getUsername();
        if (username == null || username.isEmpty()) {
            throw new NotFoundException(this.messageService.getMessage("the.email.not.found"));
        }
        long diff = new Date().getTime() - token.getCreatedDate().getTime();
        long diffMinutes = diff / 60000L;
        if (diffMinutes > 15L) {
            throw new TimeOutException(this.messageService.getMessage("the.link.has.been.expired") + diffMinutes);
        }
        Account account = this.accountRepository.findByUsername(username);
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)resetPasswordRequest.getPassword()));
        this.accountRepository.save((Object)account);
        this.confirmationTokenRepository.delete((Object)token);
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("password.successfully.reset.you.can.now.log.in.with.the.new.credentials"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    public static boolean isValid(String email) {
        String regex = "^[\\w-_\\.+]*[\\w-_\\.]\\@([\\w]+\\.)+[\\w]+[\\w]$";
        return email.matches(regex);
    }

    @PostMapping(value={"/change-password"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> changePassword(@RequestHeader(value="Authorization") String token, @RequestBody ChangePasswordRequest changePasswordRequest) {
        Account account = this.authService.getAccountByToken(token);
        if (changePasswordRequest == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.request.params.does.not.match"));
        }
        this.validatePassword(this.bCryptPasswordEncoder, account.getPassword(), changePasswordRequest.getOldPassword(), changePasswordRequest.getNewPassword());
        Student student = this.authService.getStudentByToken(token);
        if (student == null || !student.isDemo()) {
            account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)changePasswordRequest.getNewPassword()));
            this.accountRepository.save((Object)account);
        }
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(this.messageService.getMessage("password.successfully.reset.you.can.now.log.in.with.the.new.credentials"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    public void validatePassword(BCryptPasswordEncoder bCryptPasswordEncoder, String password, String oldPassword, String newPassword) throws ResponseStatusException {
        if (oldPassword == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.old.password.does.not.found"));
        }
        if (oldPassword.trim().isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.old.password.is.empty"));
        }
        if (newPassword == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.new.password.does.not.found"));
        }
        if (newPassword.trim().isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.new.password.is.empty"));
        }
        if (newPassword.length() < 6) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.new.password.should.be.six.character.long"));
        }
        boolean isValidPassword = bCryptPasswordEncoder.matches((CharSequence)oldPassword, password);
        if (!isValidPassword) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.old.password.does.not.match"));
        }
    }

    @GetMapping(value={"/generate/licence-key"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> generateLicenceKey() {
        com.infinite.focus.server.auth.model.Message message = new com.infinite.focus.server.auth.model.Message(AppUtils.generateRandomCharsLicenceKey((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890", (int)16));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/number-of-students-who-did-clymb"})
    public ResponseEntity<com.infinite.focus.server.auth.model.Message> numberOfStudentsWhoDidClymb(@RequestHeader(value="Authorization") String token, @RequestBody NumberOfStudentsWhoDidClymbRequest request) {
        List schools = this.authService.getSchoolByToken(token);
        School school = null;
        if (!AppUtils.isNullOrEmpty((List)schools) && request.getOrganization_id() > 0L && (school = (School)schools.stream().filter(item -> item.getSchool_id() == request.getOrganization_id()).findFirst().orElse(null)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.organization.is.not.found"));
        }
        Instructor instructor = this.authService.getInstructorByToken(token);
        com.infinite.focus.server.auth.model.Message message = null;
        if (school != null) {
            message = new com.infinite.focus.server.auth.model.Message(this.schoolService.outOfStudentWhoLoggedBetween(school.getSchool_id(), request.getFromDate(), request.getToDate(), request.getTimeZone()));
        }
        if (instructor != null) {
            message = new com.infinite.focus.server.auth.model.Message(this.instructorService.outOfStudentWhoLoggedBetween(instructor.getInstructor_id(), request.getFromDate(), request.getToDate(), request.getTimeZone()));
        }
        return new ResponseEntity(message, (HttpStatusCode)HttpStatus.OK);
    }
}

