/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.mood.repository;

import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.repository.MoodRepository;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MoodRepositoryImpl
implements MoodRepository {
    private final JdbcTemplate jdbcTemplate;

    public MoodRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static MoodDTO mapRow(ResultSet rs, int i) throws SQLException {
        return MoodDTO.builder().mood_id(rs.getLong("mood_id")).mood(rs.getString("mood")).mood_es(rs.getString("mood_es")).images_elementary("/images/images_elementary/" + rs.getString("images_elementary")).images_others("/images/images_others/" + rs.getString("images_others")).animated_image("/images/mood_gifs/" + rs.getString("animated_image")).weight(rs.getDouble("weight")).happiness_altitude(rs.getBoolean("happiness_altitude")).for_elementary_grade_only(rs.getBoolean("for_elementary_grade_only")).ask_for_help(rs.getBoolean("ask_for_help")).active(rs.getBoolean("active")).color(rs.getString("color")).pv_state(PVState.valueOfOrDefault((String)rs.getString("pv_state"))).sort_index(rs.getInt("sort_index")).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public List<MoodDTO> getAllMoodsOrderBySortIndex() {
        String SQL = "SELECT * FROM mood WHERE active = 1 ORDER BY sort_index ASC";
        try {
            return this.jdbcTemplate.query(SQL, MoodRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodDTO>();
        }
    }

    public List<MoodDTO> getAllHappinessAltitudeMoodsOrderBySortIndex() {
        String SQL = "SELECT * FROM mood WHERE happiness_altitude = 1 AND active = 1 ORDER BY sort_index ASC";
        try {
            return this.jdbcTemplate.query(SQL, MoodRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodDTO>();
        }
    }

    public MoodDTO findById(long id) {
        String SQL = "SELECT * FROM mood WHERE mood_id = ? AND active = 1 ";
        try {
            return (MoodDTO)this.jdbcTemplate.queryForObject(SQL, MoodRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MoodDTO findByMood(String mood) {
        String SQL = "SELECT * FROM mood WHERE BINARY mood like ? AND active = 1 LIMIT 0, 1";
        try {
            return (MoodDTO)this.jdbcTemplate.queryForObject(SQL, MoodRepositoryImpl::mapRow, new Object[]{mood});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<MoodDTO> getAskForHelpMoods() {
        String SQL = "SELECT * FROM mood WHERE ask_for_help = 1 AND active = 1 ORDER BY sort_index ASC";
        try {
            return this.jdbcTemplate.query(SQL, MoodRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodDTO>();
        }
    }

    public List<MoodDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<MoodDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM mood WHERE mood_id IN(%s) ORDER BY mood_id ASC";
        try {
            return this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), MoodRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodDTO>();
        }
    }
}

