/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server;

import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.CacheControl;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ComponentScan(basePackages={"com.infinite.focus.server.about", "com.infinite.focus.server.accesscode", "com.infinite.focus.server.account", "com.infinite.focus.server.activity", "com.infinite.focus.server.activitytype", "com.infinite.focus.server.admin", "com.infinite.focus.server.allhybriduser", "com.infinite.focus.server.answer", "com.infinite.focus.server.appreciation", "com.infinite.focus.server.askforhelp", "com.infinite.focus.server.assessment", "com.infinite.focus.server.assessmentcategory", "com.infinite.focus.server.assessmentpost", "com.infinite.focus.server.auth", "com.infinite.focus.server.avatar", "com.infinite.focus.server.badge", "com.infinite.focus.server.category", "com.infinite.focus.server.clever", "com.infinite.focus.server.client", "com.infinite.focus.server.compassdashboard", "com.infinite.focus.server.config", "com.infinite.focus.server.configuration", "com.infinite.focus.server.confirmationtoken", "com.infinite.focus.server.content", "com.infinite.focus.server.converter", "com.infinite.focus.server.corporate", "com.infinite.focus.server.corporatenotification", "com.infinite.focus.server.correctanswer", "com.infinite.focus.server.cronjob", "com.infinite.focus.server.dailyappreciation", "com.infinite.focus.server.dashboard", "com.infinite.focus.server.data", "com.infinite.focus.server.dataset", "com.infinite.focus.server.district", "com.infinite.focus.server.email", "com.infinite.focus.server.ethnicity", "com.infinite.focus.server.favorite", "com.infinite.focus.server.fcm", "com.infinite.focus.server.fcm.model", "com.infinite.focus.server.fcm.service", "com.infinite.focus.server.feelslike", "com.infinite.focus.server.freetrial", "com.infinite.focus.server.gender", "com.infinite.focus.server.grade", "com.infinite.focus.server.group", "com.infinite.focus.server.home", "com.infinite.focus.server.instructor", "com.infinite.focus.server.instructorgroup", "com.infinite.focus.server.instructorsurveychoice", "com.infinite.focus.server.invoice", "com.infinite.focus.server.journal", "com.infinite.focus.server.language", "com.infinite.focus.server.largeorganizationsurveychoice", "com.infinite.focus.server.lesson", "com.infinite.focus.server.lessonrecord", "com.infinite.focus.server.lookslike", "com.infinite.focus.server.message", "com.infinite.focus.server.mobile", "com.infinite.focus.server.mood", "com.infinite.focus.server.moodandcolor", "com.infinite.focus.server.moodandstandard", "com.infinite.focus.server.moodupdate", "com.infinite.focus.server.multiplechoiceoption", "com.infinite.focus.server.notification", "com.infinite.focus.server.organization", "com.infinite.focus.server.organizationadmin", "com.infinite.focus.server.organizationsurveychoice", "com.infinite.focus.server.parent", "com.infinite.focus.server.payment", "com.infinite.focus.server.post", "com.infinite.focus.server.postcategory", "com.infinite.focus.server.postcontent", "com.infinite.focus.server.postmood", "com.infinite.focus.server.poststandard", "com.infinite.focus.server.pvstate", "com.infinite.focus.server.question", "com.infinite.focus.server.quote", "com.infinite.focus.server.relationshipskills", "com.infinite.focus.server.responsibledecisionmaking", "com.infinite.focus.server.rest", "com.infinite.focus.server.school", "com.infinite.focus.server.screen", "com.infinite.focus.server.security", "com.infinite.focus.server.selfmanagement", "com.infinite.focus.server.setting", "com.infinite.focus.server.sharedyouth", "com.infinite.focus.server.shortenurl", "com.infinite.focus.server.socialawareness", "com.infinite.focus.server.socioemotionaltestanswer", "com.infinite.focus.server.socioemotionaltestquestion", "com.infinite.focus.server.socioemotionaltestquestionoption", "com.infinite.focus.server.socioemotionaltestquestionoptionpvstate", "com.infinite.focus.server.socioemotionaltestquestiontype", "com.infinite.focus.server.socioemotionaltestresult", "com.infinite.focus.server.sosanswer", "com.infinite.focus.server.sosoption", "com.infinite.focus.server.sosquestion", "com.infinite.focus.server.sosrequest", "com.infinite.focus.server.sostime", "com.infinite.focus.server.standard", "com.infinite.focus.server.streak", "com.infinite.focus.server.student", "com.infinite.focus.server.studentbadge", "com.infinite.focus.server.studentgroup", "com.infinite.focus.server.studentprofileotp", "com.infinite.focus.server.studentpushnotification", "com.infinite.focus.server.studentpvstate", "com.infinite.focus.server.studentstreak", "com.infinite.focus.server.submood", "com.infinite.focus.server.submoodandfeelslike", "com.infinite.focus.server.submoodandlookslike", "com.infinite.focus.server.submoodandstandard", "com.infinite.focus.server.survey", "com.infinite.focus.server.surveychoice", "com.infinite.focus.server.surveyquestion", "com.infinite.focus.server.template", "com.infinite.focus.server.test", "com.infinite.focus.server.testresult", "com.infinite.focus.server.testresultgrade", "com.infinite.focus.server.toppicks", "com.infinite.focus.server.twilio", "com.infinite.focus.server.unsubscribe", "com.infinite.focus.server.upcomingupdate", "com.infinite.focus.server.utils", "com.infinite.focus.server.vimeo", "com.infinite.focus.server.wallpost", "com.infinite.focus.server.wallpostattachment", "com.infinite.focus.server.wallpostimage", "com.infinite.focus.server.wallpostreaction", "com.infinite.focus.server.wallpostrequest", "com.infinite.focus.server.wallpostrestriction", "com.infinite.focus.server.websocket", "com.infinite.focus.server.youthsurveychoice", "com.infinite.focus.server.logging", "com.infinite.focus.server.studentstandardlog", "com.infinite.focus.server.youtube"})
@EnableScheduling
@SpringBootApplication
@EnableAsync
@EnableFeignClients
public class InfiniteFocusApplication
implements WebMvcConfigurer {
    public static void main(String[] args) {
        SpringApplication.run(InfiniteFocusApplication.class, (String[])args);
    }

    @PostConstruct
    public void init() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"classpath:/statics/"}).setCacheControl(CacheControl.maxAge((long)2L, (TimeUnit)TimeUnit.HOURS).cachePublic());
    }

    @Bean
    public ResourceBundleMessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("messages");
        return messageSource;
    }

    @Bean(name={"appRestClient"})
    public RestTemplate getRestClient() {
        RestTemplate restClient = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        restClient.setInterceptors(Collections.singletonList((request, body, execution) -> execution.execute(request, body)));
        restClient.setInterceptors(Collections.singletonList(new /* Unavailable Anonymous Inner Class!! */));
        return restClient;
    }
}

