/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.notification.repository;

import com.infinite.focus.server.notification.dto.NotificationDTO;
import com.infinite.focus.server.notification.repository.NotificationCoreRepository;
import com.infinite.focus.server.notification.repository.mapper.NotificationRowMapper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class NotificationCoreRepositoryImpl
implements NotificationCoreRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public NotificationCoreRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<NotificationDTO> getPageByInstructorId(Long instructorId, List<Long> studentIds, List<String> notificationTypes, Boolean viewed, Date fromDate, Date toDate, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM notification WHERE instructor_id = :instructor_id");
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("instructor_id", (Object)instructorId);
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            sqlQuery.append(" AND student_id IN (:student_ids)");
            params.addValue("student_ids", studentIds);
        }
        if (AppUtils.isNotNullOrEmpty(notificationTypes)) {
            sqlQuery.append(" AND notification_type IN (:notification_types)");
            params.addValue("notification_types", notificationTypes);
        }
        if (viewed != null) {
            sqlQuery.append(" AND viewed_instructor = :viewed");
            params.addValue("viewed", (Object)viewed);
        }
        if (fromDate != null && toDate != null) {
            sqlQuery.append(" AND created_at BETWEEN :from_date AND :to_date");
            params.addValue("from_date", (Object)fromDate).addValue("to_date", (Object)toDate);
        }
        sqlQuery.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy.equals("desc") ? "DESC" : "ASC");
        sqlQuery.append(" LIMIT :limit OFFSET :offset");
        params.addValue("limit", (Object)pageSize).addValue("offset", (Object)(pageNo * pageSize));
        List notifications = this.namedParameterJdbcTemplate.query(sqlQuery.toString(), (SqlParameterSource)params, (RowMapper)new NotificationRowMapper());
        StringBuilder countQuery = new StringBuilder("SELECT COUNT(*) FROM notification WHERE instructor_id = :instructor_id");
        MapSqlParameterSource countParams = new MapSqlParameterSource().addValue("instructor_id", (Object)instructorId);
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            countQuery.append(" AND student_id IN (:student_ids)");
            countParams.addValue("student_ids", studentIds);
        }
        if (AppUtils.isNotNullOrEmpty(notificationTypes)) {
            countQuery.append(" AND notification_type IN (:notification_types)");
            countParams.addValue("notification_types", notificationTypes);
        }
        if (viewed != null) {
            countQuery.append(" AND viewed_instructor = :viewed");
            countParams.addValue("viewed", (Object)viewed);
        }
        if (fromDate != null && toDate != null) {
            countQuery.append(" AND created_at BETWEEN :from_date AND :to_date");
            countParams.addValue("from_date", (Object)fromDate).addValue("to_date", (Object)toDate);
        }
        Long total = (Long)this.namedParameterJdbcTemplate.queryForObject(countQuery.toString(), (SqlParameterSource)countParams, Long.class);
        PageImpl pagedResult = new PageImpl(notifications, (Pageable)PageRequest.of((int)pageNo, (int)pageSize), total.longValue());
        this.batchUpdateViewedInstructor(pagedResult.getContent());
        return pagedResult;
    }

    public void batchUpdateViewedInstructor(List<NotificationDTO> notifications) {
        String sqlUpdate = "UPDATE notification SET viewed_instructor = :viewed WHERE notification_id = :notification_id";
        List<MapSqlParameterSource> batchArgs = notifications.stream().map(notification -> {
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("viewed", (Object)true);
            params.addValue("notification_id", (Object)notification.getNotification_id());
            return params;
        }).collect(Collectors.toList());
        this.namedParameterJdbcTemplate.batchUpdate(sqlUpdate, (SqlParameterSource[])batchArgs.toArray(new MapSqlParameterSource[0]));
    }

    public long getCountForNotViewedByInstructorId(Long instructorId, boolean viewed) {
        String sql = "SELECT COUNT(*) FROM notification WHERE instructor_id = :instructor_id AND viewed_instructor = :viewed";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("instructor_id", (Object)instructorId);
        params.addValue("viewed", (Object)viewed);
        return (Long)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Long.class);
    }

    public Page<NotificationDTO> getPageByParentIds(List<Long> studentIds, List<Long> parentIds, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate, Boolean viewed) {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM notification WHERE parent_id IN (:parent_ids)");
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("parent_ids", parentIds);
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            sqlQuery.append(" AND student_id IN (:student_ids)");
            params.addValue("student_ids", studentIds);
        }
        if (viewed != null) {
            sqlQuery.append(" AND viewed_parent = :viewed");
            params.addValue("viewed", (Object)viewed);
        }
        if (fromDate != null && toDate != null) {
            sqlQuery.append(" AND created_at BETWEEN :from_date AND :to_date");
            params.addValue("from_date", (Object)fromDate).addValue("to_date", (Object)toDate);
        }
        sqlQuery.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy.equals("desc") ? "DESC" : "ASC").append(" LIMIT :limit OFFSET :offset");
        params.addValue("limit", (Object)pageSize).addValue("offset", (Object)(pageNo * pageSize));
        List notifications = this.namedParameterJdbcTemplate.query(sqlQuery.toString(), (SqlParameterSource)params, (RowMapper)new NotificationRowMapper());
        StringBuilder countQuery = new StringBuilder("SELECT COUNT(*) FROM notification WHERE parent_id IN (:parent_ids)");
        MapSqlParameterSource countParams = new MapSqlParameterSource().addValue("parent_ids", parentIds);
        if (AppUtils.isNotNullOrEmpty(studentIds)) {
            countQuery.append(" AND student_id IN (:student_ids)");
            countParams.addValue("student_ids", studentIds);
        }
        if (viewed != null) {
            countQuery.append(" AND viewed_parent = :viewed");
            countParams.addValue("viewed", (Object)viewed);
        }
        if (fromDate != null && toDate != null) {
            countQuery.append(" AND created_at BETWEEN :from_date AND :to_date");
            countParams.addValue("from_date", (Object)fromDate).addValue("to_date", (Object)toDate);
        }
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countQuery.toString(), (SqlParameterSource)countParams, Long.class);
        PageImpl pagedResult = new PageImpl(notifications, (Pageable)PageRequest.of((int)pageNo, (int)pageSize), count.longValue());
        List<MapSqlParameterSource> batchArgs = notifications.stream().filter(notification -> !notification.isViewed_parent()).map(notification -> new MapSqlParameterSource().addValue("viewed", (Object)true).addValue("notification_id", (Object)notification.getNotification_id())).collect(Collectors.toList());
        if (!batchArgs.isEmpty()) {
            this.namedParameterJdbcTemplate.batchUpdate("UPDATE notification SET viewed_parent = :viewed WHERE notification_id = :notification_id", (SqlParameterSource[])batchArgs.toArray(new MapSqlParameterSource[0]));
        }
        return pagedResult;
    }

    public long getCountForNotViewedByParentId(long parentId, boolean view) {
        String sql = "SELECT COUNT(*) FROM notification WHERE parent_id = :parent_id AND viewed_parent = :viewed";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("parent_id", (Object)parentId);
        params.addValue("viewed", (Object)view);
        return (Long)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, Long.class);
    }
}

