/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructor.repository;

import com.infinite.focus.server.instructor.dto.InstructorDTO;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorCriteriaRepository;
import com.infinite.focus.server.utils.DateUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class InstructorCriteriaRepositoryImpl
implements InstructorCriteriaRepository {
    private final EntityManager entityManager;
    private final JdbcTemplate jdbcTemplate;

    public InstructorCriteriaRepositoryImpl(EntityManager entityManager, JdbcTemplate jdbcTemplate) {
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
    }

    private static InstructorDTO mapRow(ResultSet rs, int i) throws SQLException {
        return InstructorDTO.builder().instructor_id(rs.getLong("instructor_id")).school_id(rs.getLong("school_id")).account_id(rs.getLong("account_id")).first_name(rs.getString("first_name")).last_name(rs.getString("last_name")).registration_code(rs.getString("registration_code")).operating_system(rs.getString("operating_system")).browser(rs.getString("browser")).city(rs.getString("city")).state(rs.getString("state")).new_notificaitons(rs.getBoolean("new_notificaitons")).clever_id(rs.getString("clever_id")).archived(rs.getBoolean("archived")).auto_approve_wall_posts(rs.getBoolean("auto_approve_wall_posts")).language(rs.getString("language")).last_sync((Date)rs.getDate("last_sync")).createdAt((Date)rs.getDate("created_at")).build();
    }

    public List<Long> getInstructorIdsByGradeIdAndCreatedAtBetweenFromDateAndToDate(long grade_id, Date fromDate, Date toDate) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Long.class);
        Root instructorRoot = query.from(Instructor.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
        Root sqRoot = sq.correlate(instructorRoot);
        Join sqJoin = sqRoot.join("standards");
        sq.where((Expression)sqJoin.get("grade").get("grade_id").in(Collections.singletonList(grade_id)));
        predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        predicates.add(qb.isNotNull((Expression)instructorRoot.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)instructorRoot.get("account").get("username"), (Object)""));
        if (fromDate != null && toDate != null) {
            System.out.println("getInstructorsByGradeIdAndCreatedAtBetweenFromDateAndToDate FromDate " + DateUtils.getDateInString((Date)fromDate) + " - ToDate " + DateUtils.getDateInString((Date)toDate));
            predicates.add(qb.between((Expression)instructorRoot.get("account").get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.select((Selection)instructorRoot.get("instructor_id")).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List instructor_ids = typedQuery.getResultList();
        return instructor_ids;
    }

    public InstructorDTO findById(long id) {
        String SQL = "SELECT * FROM instructor WHERE instructor_id = ?";
        return (InstructorDTO)this.jdbcTemplate.queryForObject(SQL, InstructorCriteriaRepositoryImpl::mapRow, new Object[]{id});
    }

    public void updateNewNotificationsById(long id, boolean new_notifications) {
        String SQL = "UPDATE instructor SET new_notificaitons = ? WHERE instructor_id = ? ";
        this.jdbcTemplate.update("UPDATE instructor SET new_notificaitons = ? WHERE instructor_id = ? ", new Object[]{new_notifications, id});
    }
}

