/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.school;

import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverInstructorWrapper;
import com.infinite.focus.server.clever.model.CleverSchool;
import com.infinite.focus.server.clever.model.CleverSchoolWrapper;
import com.infinite.focus.server.clever.model.CleverSection;
import com.infinite.focus.server.clever.model.CleverSectionWrapper;
import com.infinite.focus.server.clever.model.CleverStaff;
import com.infinite.focus.server.clever.model.CleverStudent;
import com.infinite.focus.server.clever.model.CleverStudentWrapper;
import com.infinite.focus.server.clever.response.GetCleverInstructorsResponse;
import com.infinite.focus.server.clever.response.GetCleverSchoolsResponse;
import com.infinite.focus.server.clever.response.GetCleverSectionsResponse;
import com.infinite.focus.server.clever.response.GetCleverStudentsResponse;
import com.infinite.focus.server.clever.response.GetSchoolByIdResponse;
import com.infinite.focus.server.clever.service.school.CleverSchoolApiService;
import com.infinite.focus.server.clever.service.school.CleverSchoolService;
import com.infinite.focus.server.clever.wrapper.CleverStaffWrapper;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CleverSchoolServiceImpl
implements CleverSchoolService {
    private CleverSchoolApiService service;

    public CleverSchoolServiceImpl() {
        OkHttpClient OClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.clever.com/v3.0/").client(OClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (CleverSchoolApiService)retrofit.create(CleverSchoolApiService.class);
    }

    public CleverSchool getCleverSchoolById(String token, String id) {
        try {
            Call getDistrictById = this.service.getCleverSchoolById("Bearer " + token, id);
            Response response = getDistrictById.execute();
            if (response.isSuccessful() && response.body() != null && ((GetSchoolByIdResponse)response.body()).getData() != null) {
                return ((GetSchoolByIdResponse)response.body()).getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Set<CleverSchool> getCleverSchools(String access_token) {
        try {
            Call getDistrictById = this.service.getCleverSchools("Bearer " + access_token);
            Response response = getDistrictById.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSchoolsResponse)response.body()).getData() != null) {
                return ((GetCleverSchoolsResponse)response.body()).getData().stream().map(CleverSchoolWrapper::getData).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new HashSet<CleverSchool>();
    }

    public LinkedHashSet<CleverSchool> getCleverSchools(String access_token, Integer limit, String starting_after, String ending_before) {
        try {
            Call getDistrictById = this.service.getCleverSchools("Bearer " + access_token, limit, starting_after, ending_before);
            Response response = getDistrictById.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSchoolsResponse)response.body()).getData() != null) {
                return ((GetCleverSchoolsResponse)response.body()).getData().stream().map(CleverSchoolWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LinkedHashSet<CleverSchool>();
    }

    public LinkedHashSet<CleverInstructor> getCleverInstructorsByCleverSchool(String access_token, String school_clever_id, Integer limit, String starting_after, String ending_before, String primary) {
        try {
            Call getDistrictById = this.service.getCleverInstructorsByCleverSchool("Bearer " + access_token, school_clever_id, "teacher", limit, starting_after, ending_before, primary);
            Response response = getDistrictById.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverInstructorsResponse)response.body()).getData() != null) {
                return ((GetCleverInstructorsResponse)response.body()).getData().stream().map(CleverInstructorWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LinkedHashSet<CleverInstructor>();
    }

    public LinkedHashSet<CleverInstructor> getCleverStaffByCleverSchool(String access_token, String school_clever_id, Integer limit, String starting_after, String ending_before, String primary) {
        try {
            Call getDistrictById = this.service.getCleverStaffByCleverSchool("Bearer " + access_token, school_clever_id, "staff", limit, starting_after, ending_before, null);
            Response response = getDistrictById.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverInstructorsResponse)response.body()).getData() != null) {
                return ((GetCleverInstructorsResponse)response.body()).getData().stream().map(CleverInstructorWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LinkedHashSet<CleverInstructor>();
    }

    public LinkedHashSet<CleverStudent> getCleverStudentsByCleverSchool(String access_token, String school_clever_id, Integer limit, String starting_after, String ending_before, String primary) {
        try {
            Call getCleverStudentsResponseCall = this.service.getCleverStudentsByCleverSchool("Bearer " + access_token, school_clever_id, "student", limit, starting_after, ending_before, primary);
            Response response = getCleverStudentsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverStudentsResponse)response.body()).getData() != null) {
                return ((GetCleverStudentsResponse)response.body()).getData().stream().map(CleverStudentWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LinkedHashSet<CleverStudent>();
    }

    public List<CleverStaff> getCleverStaffByCleverSchool(String access_token, String school_clever_id, Integer limit, String starting_after, String ending_before) {
        try {
            Call getStaff = this.service.getCleverStaffByCleverSchool("Bearer " + access_token, school_clever_id, "staff", limit, starting_after, ending_before);
            Response response = getStaff.execute();
            if (response.isSuccessful() && response.body() != null && ((CleverStaffWrapper)response.body()).getData() != null) {
                return ((CleverStaffWrapper)response.body()).getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedHashSet<CleverSection> getCleverSectionsByCleverSchool(String access_token, String school_clever_id, Integer limit, String starting_after, String ending_before) {
        try {
            Call getCleverSectionsResponseCall = this.service.getCleverSectionsByCleverSchool("Bearer " + access_token, school_clever_id, limit, starting_after, ending_before);
            Response response = getCleverSectionsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSectionsResponse)response.body()).getData() != null) {
                return ((GetCleverSectionsResponse)response.body()).getData().stream().map(CleverSectionWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new LinkedHashSet<CleverSection>();
    }
}

