/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentbadge.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.badge.entity.Badge;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.request.GetByStudentIdRequest;
import com.infinite.focus.server.studentbadge.model.AssignedByType;
import com.infinite.focus.server.studentbadge.request.AssignBadgeToClassesRequest;
import com.infinite.focus.server.studentbadge.request.AssignBadgeToStudentsRequest;
import com.infinite.focus.server.studentbadge.service.StudentBadgeService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student-badge"})
public class StudentBadgeController {
    private final AuthService authService;
    private final MessageService messageService;
    private final StudentBadgeService studentBadgeService;

    public StudentBadgeController(AuthService authService, MessageService messageService, StudentBadgeService studentBadgeService) {
        this.authService = authService;
        this.messageService = messageService;
        this.studentBadgeService = studentBadgeService;
    }

    @PostMapping(value={"/assign-badge-to-students"})
    @ResponseBody
    public ResponseEntity<Message> assignBadgeToStudents(@RequestHeader(value="Authorization") String token, @RequestBody AssignBadgeToStudentsRequest request) {
        Instructor instructor = this.authService.getInstructorByToken(token);
        Parent parent = this.authService.getParentByToken(token);
        if (instructor == null && parent == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        long assigned_by_id = 0L;
        AssignedByType assigned_by_type = null;
        String name = null;
        if (instructor != null) {
            assigned_by_id = instructor.getInstructor_id();
            assigned_by_type = AssignedByType.INSTRUCTOR;
            name = instructor.getFirst_name().trim() + " " + instructor.getLast_name().trim();
        }
        if (parent != null) {
            assigned_by_id = parent.getParent_id();
            assigned_by_type = AssignedByType.PARENT;
            name = parent.getFirst_name().trim() + " " + parent.getLast_name().trim();
        }
        this.studentBadgeService.assignBadgeToStudents(request.getStudent_ids(), assigned_by_type, assigned_by_id, name, request.getBadge_id(), request.getTitle(), request.getTitle_es(), request.getDescription(), request.getDescription_es());
        Message message = null;
        message = request.getStudent_ids().size() > 1 ? new Message(this.messageService.getMessage("assigned.to.students")) : new Message(this.messageService.getMessage("assigned.to.student"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/assign-badge-to-groups"})
    @ResponseBody
    public ResponseEntity<Message> assignBadgeToGroups(@RequestHeader(value="Authorization") String token, @RequestBody AssignBadgeToClassesRequest request) {
        Instructor instructor = this.authService.getInstructorByToken(token);
        Parent parent = this.authService.getParentByToken(token);
        if (instructor == null && parent == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        AssignedByType assigned_by_type = null;
        long assigned_by_id = 0L;
        String name = null;
        if (instructor != null) {
            assigned_by_type = AssignedByType.INSTRUCTOR;
            assigned_by_id = instructor.getInstructor_id();
            name = instructor.getFirst_name().trim() + " " + instructor.getLast_name().trim();
        }
        if (parent != null) {
            assigned_by_type = AssignedByType.PARENT;
            assigned_by_id = parent.getParent_id();
            name = parent.getFirst_name().trim() + " " + parent.getLast_name().trim();
        }
        this.studentBadgeService.assignBadgeToClasses(request.getClass_ids(), assigned_by_type, assigned_by_id, name, request.getBadge_id(), request.getTitle(), request.getTitle_es(), request.getDescription(), request.getDescription_es());
        Message message = null;
        message = request.getClass_ids().size() > 1 ? new Message(this.messageService.getMessage("assigned.to.groups")) : new Message(this.messageService.getMessage("assigned.to.group"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/badges/for/student"})
    public ResponseEntity<List<Badge>> getBadgesForStudent(@RequestHeader(value="Authorization") String token) {
        Student student = this.authService.isStudent(token);
        return new ResponseEntity((Object)this.studentBadgeService.getStudentBadgeByStudentId(Long.valueOf(student.getStudent_id())), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-student-id"})
    public ResponseEntity<List<Badge>> getByStudentId(@RequestHeader(value="Authorization") String token, @RequestBody GetByStudentIdRequest request) {
        return new ResponseEntity((Object)this.studentBadgeService.getByStudentId(request.getStudent_id()), (HttpStatusCode)HttpStatus.OK);
    }
}

