/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.avatar.controller;

import com.infinite.focus.server.avatar.dto.AvatarDTO;
import com.infinite.focus.server.avatar.request.GetByAvatarIdRequest;
import com.infinite.focus.server.avatar.service.AvatarService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/avatar"})
public class AvatarController {
    private final AvatarService avatarService;

    public AvatarController(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    @PostMapping(value={"/get-all"})
    ResponseEntity<List<AvatarDTO>> getAll() {
        return new ResponseEntity((Object)this.avatarService.getAll(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-id"})
    ResponseEntity<AvatarDTO> getById(@RequestBody GetByAvatarIdRequest request) {
        return new ResponseEntity((Object)this.avatarService.getById(request.getAvatar_id()), (HttpStatusCode)HttpStatus.OK);
    }
}

