/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructor.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.standard.entity.Standard;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"clever_id"})})
public class Instructor {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long instructor_id;
    @Transient
    private long account_id;
    @OneToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="account_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnore
    private Account account;
    private long school_id;
    @ManyToMany(targetEntity=Standard.class, fetch=FetchType.LAZY)
    @JoinTable(name="instructor_standard", joinColumns={@JoinColumn(nullable=false, name="instructor_id")}, inverseJoinColumns={@JoinColumn(nullable=false, name="standard_id")})
    private Set<Standard> standards = new HashSet();
    private String registration_code;
    private String first_name;
    private String last_name;
    private String operating_system;
    private String browser;
    private String city;
    private String state;
    @Transient
    public String username;
    private boolean new_notificaitons = false;
    @Column(unique=true)
    private String clever_id;
    private boolean archived;
    private boolean auto_approve_wall_posts = false;
    private String language = "en";
    @CreationTimestamp
    public Date createdAt;
    public Date last_sync;

    public Date getLast_sync() {
        return this.last_sync;
    }

    public void setLast_sync(Date last_sync) {
        this.last_sync = last_sync;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getRegistration_code() {
        return this.registration_code;
    }

    public void setRegistration_code(String registration_code) {
        this.registration_code = registration_code;
    }

    public long getAccount_id() {
        return this.account == null ? this.account_id : this.account.getAccount_id();
    }

    public void setAccount_id(long account_id) {
        this.account_id = account_id;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public long getInstructor_id() {
        return this.instructor_id;
    }

    public void setInstructor_id(long instructor_id) {
        this.instructor_id = instructor_id;
    }

    public String getFirst_name() {
        return this.first_name;
    }

    public void setFirst_name(String first_name) {
        this.first_name = first_name;
    }

    public String getLast_name() {
        return this.last_name;
    }

    public void setLast_name(String last_name) {
        this.last_name = last_name;
    }

    public long getSchool_id() {
        return this.school_id;
    }

    public void setSchool_id(long school_id) {
        this.school_id = school_id;
    }

    public Set<Standard> getStandards() {
        return this.standards;
    }

    public void setStandards(Set<Standard> standards) {
        this.standards = standards;
    }

    public String getOperating_system() {
        return this.operating_system;
    }

    public void setOperating_system(String operating_system) {
        this.operating_system = operating_system;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getUsername() {
        return this.account == null ? this.username : this.account.getUsername();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isNew_notificaitons() {
        return this.new_notificaitons;
    }

    public void setNew_notificaitons(boolean new_notificaitons) {
        this.new_notificaitons = new_notificaitons;
    }

    public String getClever_id() {
        return this.clever_id;
    }

    public void setClever_id(String clever_id) {
        this.clever_id = clever_id;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isAuto_approve_wall_posts() {
        return this.auto_approve_wall_posts;
    }

    public void setAuto_approve_wall_posts(boolean auto_approve_wall_posts) {
        this.auto_approve_wall_posts = auto_approve_wall_posts;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

