/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.controller;

import com.infinite.focus.server.logging.controller.LogController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class LogController {
    private static final String LOG_DIR = "logs/";
    private static final String LOG_FILE_PATTERN = "production%i.log";

    @GetMapping(value={"/api/logs"})
    public ResponseEntity<?> getLogs(@RequestParam(defaultValue="1") int file, @RequestParam(defaultValue="100") int lines, @RequestParam(defaultValue="0") int skip) {
        ResponseEntity responseEntity;
        block9: {
            String logFileName = file == 1 ? "production.log" : String.format(LOG_FILE_PATTERN, file);
            File logFile = new File(LOG_DIR + logFileName);
            if (!logFile.exists()) {
                return ResponseEntity.badRequest().body((Object)("Log file not found: " + logFileName));
            }
            BufferedReader reader = Files.newBufferedReader(Paths.get(LOG_DIR + logFileName, new String[0]));
            try {
                List allLines = reader.lines().collect(Collectors.toList());
                List reversedLines = allLines.stream().collect(Collectors.collectingAndThen(Collectors.toList(), lst -> {
                    Collections.reverse(lst);
                    return lst;
                })).stream().skip(skip).limit(lines).collect(Collectors.toList());
                long totalLines = allLines.size();
                responseEntity = ResponseEntity.ok((Object)new LogResponse(totalLines, reversedLines));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ResponseEntity.status((int)500).body((Object)("Error reading log file: " + e.getMessage()));
                }
            }
            reader.close();
        }
        return responseEntity;
    }

    private long countLines(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            long l = reader.lines().count();
            return l;
        }
    }
}

