/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.logging.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.logging.helper.LoggingHelper;
import com.infinite.focus.server.logging.service.LoggingService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private final LoggingService loggingService;
    private final ObjectMapper objectMapper;

    public ResponseBodyInterceptor(LoggingService loggingService, ObjectMapper objectMapper) {
        this.loggingService = loggingService;
        this.objectMapper = objectMapper;
    }

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        this.displayResp(((ServletServerHttpRequest)request).getServletRequest(), ((ServletServerHttpResponse)response).getServletResponse(), response.getHeaders(), body);
        return body;
    }

    public void displayResp(HttpServletRequest request, HttpServletResponse response, HttpHeaders httpHeaders, Object body) {
        String responseBody;
        String url = request.getRequestURI();
        String authorization = request.getHeader("Authorization");
        String method = request.getMethod();
        Map headers = LoggingHelper.getHeaders((HttpServletResponse)response, (HttpHeaders)httpHeaders);
        Map parameters = LoggingHelper.getParameters((HttpServletRequest)request);
        try {
            responseBody = this.objectMapper.writeValueAsString(body);
        }
        catch (Exception e) {
            responseBody = e.toString();
        }
        this.loggingService.saveResponse(authorization, url, method, headers, parameters, responseBody);
    }
}

