/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.helper;

import com.infinite.focus.server.dashboard.model.LabelAndData;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.LabelsAndDatasets;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LabelAndDataHelper {
    private static final String LABELS = "labels";
    private static final String DATASET = "dataset";
    private static final String LABEL = "label";
    private static final String DATA = "data";

    public static LabelsAndDatasets getLabelsAndDatasets(LinkedHashMap<String, List<LabelAndValue>> graphData) {
        LabelsAndDatasets labelsAndDatasets = new LabelsAndDatasets();
        LinkedList<LabelAndData> dataset = new LinkedList<LabelAndData>();
        for (String key : graphData.keySet()) {
            List<LabelAndValue> values = graphData.get(key);
            LinkedList<Double> data = new LinkedList<Double>();
            if (AppUtils.isNotNullOrEmpty(values)) {
                for (int i = 0; i < values.size(); ++i) {
                    labelsAndDatasets.getLabels().add(values.get(i).getxLabel());
                    data.add(DigitUtils.formatDoubleInTwoDigit((Double)values.get(i).getValue()));
                }
            }
            LabelAndData labelAndData = new LabelAndData(key, data);
            dataset.add(labelAndData);
        }
        labelsAndDatasets.setDataset(dataset);
        return labelsAndDatasets;
    }

    public static LabelsAndDatasets getLabelsAndDatasets2(LinkedHashMap<String, List<LabelAndValue>> graphData) {
        LabelsAndDatasets result = new LabelsAndDatasets();
        LinkedHashSet<String> globalLabels = new LinkedHashSet<String>();
        for (List<LabelAndValue> values : graphData.values()) {
            if (!AppUtils.isNotNullOrEmpty(values)) continue;
            for (LabelAndValue lv : values) {
                globalLabels.add(lv.getxLabel());
            }
        }
        result.setLabels(globalLabels);
        LinkedList<LabelAndData> datasets = new LinkedList<LabelAndData>();
        for (Map.Entry<String, List<LabelAndValue>> entry : graphData.entrySet()) {
            String datasetName = entry.getKey();
            List<LabelAndValue> values = entry.getValue();
            HashMap<String, Double> valueMap = new HashMap<String, Double>();
            if (AppUtils.isNotNullOrEmpty(values)) {
                for (LabelAndValue lv : values) {
                    valueMap.put(lv.getxLabel(), DigitUtils.formatDoubleInTwoDigit((Double)lv.getValue()));
                }
            }
            LinkedList<Double> alignedData = new LinkedList<Double>();
            for (String label : globalLabels) {
                alignedData.add(valueMap.getOrDefault(label, 0.0));
            }
            datasets.add(new LabelAndData(datasetName, alignedData));
        }
        result.setDataset(datasets);
        return result;
    }

    public static Object getLabelsAndMultiDatasets(LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData) {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        LinkedList dataset = new LinkedList();
        for (String demographic : graphData.keySet()) {
            LinkedList data = new LinkedList();
            for (String mood : graphData.get(demographic).keySet()) {
                labels.add(mood);
                LinkedList<Double> countAndScores = new LinkedList<Double>();
                countAndScores.add(graphData.get(demographic).get(mood).get(0));
                countAndScores.add(graphData.get(demographic).get(mood).get(1));
                data.add(countAndScores);
            }
            LinkedHashMap<String, Object> datasetItem = new LinkedHashMap<String, Object>();
            datasetItem.put(LABEL, demographic);
            datasetItem.put(DATA, data);
            dataset.add(datasetItem);
        }
        LinkedHashMap<String, AbstractCollection> labelsAndDatasets = new LinkedHashMap<String, AbstractCollection>();
        labelsAndDatasets.put(LABELS, labels);
        labelsAndDatasets.put(DATASET, dataset);
        return labelsAndDatasets;
    }
}

