/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructorsurveychoice.service;

import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.repository.InstructorRepository;
import com.infinite.focus.server.instructorsurveychoice.entity.InstructorSurveyChoice;
import com.infinite.focus.server.instructorsurveychoice.repository.InstructorSurveyChoiceRepository;
import com.infinite.focus.server.instructorsurveychoice.service.InstructorSurveyChoiceService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.survey.entity.Survey;
import com.infinite.focus.server.survey.model.LabelAndCountAndAverage;
import com.infinite.focus.server.survey.model.QuestionAndData;
import com.infinite.focus.server.survey.repository.SurveyRepository;
import com.infinite.focus.server.survey.wrapper.SurveyWrapper;
import com.infinite.focus.server.surveychoice.entity.SurveyChoice;
import com.infinite.focus.server.surveychoice.repository.SurveyChoiceRepository;
import com.infinite.focus.server.surveyquestion.entity.SurveyQuestion;
import com.infinite.focus.server.surveyquestion.model.SurveyChoiceType;
import com.infinite.focus.server.surveyquestion.model.SurveyType;
import com.infinite.focus.server.surveyquestion.repository.SurveyQuestionRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class InstructorSurveyChoiceServiceImpl
implements InstructorSurveyChoiceService {
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    SurveyRepository surveyRepository;
    @Autowired
    SurveyQuestionRepository surveyQuestionRepository;
    @Autowired
    SurveyChoiceRepository surveyChoiceRepository;
    @Autowired
    InstructorSurveyChoiceRepository instructorSurveyChoiceRepository;
    @Autowired
    MessageService messageService;

    @Async
    public void assignSurveyToInstructor(Date date) {
        Survey survey = this.surveyRepository.findSurveyByDate(date);
        if (survey == null) {
            System.out.println(this.messageService.getMessage("survey.is.not.found.for.the.date"));
            return;
        }
        System.out.println("GetSurveyByDate: " + survey.getSurvey_id());
        long days = DateUtils.getDayCountByFromDateAndToDate((Date)date, (Date)survey.getEnd_time(), (TimeZone)TimeZone.getTimeZone(ZoneId.systemDefault()));
        System.out.println("countDaysBetweenFromDateAndToDate: " + days);
        Set instructorIds = this.instructorRepository.getAllInstructors().stream().map(Instructor::getInstructor_id).collect(Collectors.toSet());
        System.out.println("All Instructors: " + instructorIds.size());
        Set instructorIdsFromInstructorSurveyChoice = this.getAllBySurveyId(survey.getSurvey_id()).stream().map(InstructorSurveyChoice::getInstructor_id).collect(Collectors.toSet());
        System.out.println("AllBySurveyId: " + instructorIdsFromInstructorSurveyChoice.size());
        instructorIds.removeAll(instructorIdsFromInstructorSurveyChoice);
        System.out.println("All Instructors - AllBySurveyId = " + instructorIds.size());
        if (!instructorIds.isEmpty() && days > 0L) {
            int countToAssign = 0;
            try {
                countToAssign = (int)((long)instructorIds.size() / days);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (countToAssign == 0) {
                countToAssign = 1;
            }
            System.out.println("countToAssign: " + countToAssign);
            instructorIds = AppUtils.getRandomStreamSubset(instructorIds.stream(), (int)countToAssign).collect(Collectors.toSet());
            System.out.println("InstructorIds to assign: " + instructorIds.size());
            SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.INSTRUCTOR.toString());
            List surveyChoices = this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id()));
            System.out.println("SurveyChoices: " + surveyChoices.size());
            this.create(survey.getSurvey_id(), surveyQuestion.getChoice_type() == SurveyChoiceType.SINGLE ? 1L : (long)surveyChoices.size(), new ArrayList(instructorIds));
        }
    }

    @Async
    public void create(long survey_id, long surveyChoicesSize, List<Long> instructorIds) {
        if (!instructorIds.isEmpty()) {
            for (long instructor_id : instructorIds) {
                int i = 0;
                while ((long)i < surveyChoicesSize) {
                    InstructorSurveyChoice instructorSurveyChoice = new InstructorSurveyChoice();
                    instructorSurveyChoice.setInstructor_id(instructor_id);
                    instructorSurveyChoice.setSurvey_id(survey_id);
                    this.instructorSurveyChoiceRepository.save((Object)instructorSurveyChoice);
                    ++i;
                }
            }
        }
    }

    public List<InstructorSurveyChoice> getAllBySurveyId(long surveyId) {
        return this.instructorSurveyChoiceRepository.findBySurveyId(Long.valueOf(surveyId));
    }

    public LinkedHashSet<SurveyWrapper> getSurveyWrappersForInstructor(long instructor_id) {
        LinkedHashSet<SurveyWrapper> surveyWrappers = new LinkedHashSet<SurveyWrapper>();
        List instructorSurveyChoices = this.instructorSurveyChoiceRepository.findByInstructorId(instructor_id);
        if (!instructorSurveyChoices.isEmpty()) {
            Map<Long, LinkedHashSet> instructorSurveyChoiceBySurveyId = instructorSurveyChoices.stream().collect(Collectors.groupingBy(InstructorSurveyChoice::getSurvey_id, Collectors.toCollection(LinkedHashSet::new)));
            Set<Long> surveyIds = instructorSurveyChoiceBySurveyId.keySet();
            for (long surveyId : surveyIds) {
                LinkedHashSet instructorSurveyChoicesFilled = instructorSurveyChoiceBySurveyId.get(surveyId).stream().filter(instructorSurveyChoice -> instructorSurveyChoice.getSurvey_choice_id() > 0L).collect(Collectors.toCollection(LinkedHashSet::new));
                if (!instructorSurveyChoicesFilled.isEmpty()) continue;
                Survey survey = this.surveyRepository.findBySurveyId(Long.valueOf(surveyId));
                SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.INSTRUCTOR.toString());
                surveyWrappers.add(new SurveyWrapper(surveyQuestion, new LinkedHashSet(this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id())))));
            }
        }
        return surveyWrappers;
    }

    public void updateInstructorSurveyChoice(long instructor_id, long survey_id, Set<Long> survey_choices) {
        List instructorSurveyChoices = this.instructorSurveyChoiceRepository.findBySurveyIdAndInstructorIdOrderByInstructorSurveyChoiceASC(survey_id, instructor_id);
        ArrayList<Long> surveyChoices = new ArrayList<Long>(survey_choices);
        if (!AppUtils.isNullOrEmpty(survey_choices)) {
            for (int i = 0; i < surveyChoices.size(); ++i) {
                InstructorSurveyChoice instructorSurveyChoice = (InstructorSurveyChoice)instructorSurveyChoices.get(i);
                instructorSurveyChoice.setSurvey_choice_id(((Long)surveyChoices.get(i)).longValue());
                this.instructorSurveyChoiceRepository.save((Object)instructorSurveyChoice);
            }
        }
    }

    public QuestionAndData getDataAnalytics(String fromDate, String toDate, String fromTimeZone, String toTimeZone) {
        Survey survey = this.surveyRepository.findSurveyByDate(fromDate, fromTimeZone, toTimeZone);
        if (survey == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("survey.is.not.found.for.the.date"));
        }
        SurveyQuestion surveyQuestion = this.surveyQuestionRepository.findBySurveyQuestionIndexAndType(survey.getQuestion_index(), SurveyType.INSTRUCTOR.toString());
        List surveyChoices = this.surveyChoiceRepository.findBySurveyQuestionIdOrderBySortIndexASC(Long.valueOf(surveyQuestion.getSurvey_question_id()));
        LinkedHashSet<LabelAndCountAndAverage> labelAndCountAndAverages = new LinkedHashSet<LabelAndCountAndAverage>();
        for (SurveyChoice surveyChoice : surveyChoices) {
            LabelAndCountAndAverage labelAndValueAndAverage = new LabelAndCountAndAverage(surveyChoice.getChoice(), surveyChoice.getChoice_es(), 0L);
            labelAndCountAndAverages.add(labelAndValueAndAverage);
        }
        List instructorSurveyChoices = this.instructorSurveyChoiceRepository.findByCreatedAtBetweenFromDateAndEndDateOrderByDESC(fromDate, toDate);
        Map<Long, LinkedHashSet> instructorSurveyChoiceBySurveyChoiceId = instructorSurveyChoices.stream().filter(instructorSurveyChoice -> instructorSurveyChoice.getSurvey_choice_id() > 0L).collect(Collectors.groupingBy(InstructorSurveyChoice::getSurvey_choice_id, Collectors.toCollection(LinkedHashSet::new)));
        Set<Long> surveyChoiceIds = instructorSurveyChoiceBySurveyChoiceId.keySet();
        long totalCount = 0L;
        for (long survey_choice_id : surveyChoiceIds) {
            SurveyChoice surveyChoice = this.surveyChoiceRepository.findSurveyChoiceById(survey_choice_id);
            LinkedHashSet instructorSurveyChoiceList = instructorSurveyChoiceBySurveyChoiceId.get(survey_choice_id);
            totalCount += (long)instructorSurveyChoiceList.size();
            for (LabelAndCountAndAverage labelAndValueAndAverage : labelAndCountAndAverages) {
                if (!labelAndValueAndAverage.getLabel().equals(surveyChoice.getChoice())) continue;
                labelAndValueAndAverage.setCount((long)instructorSurveyChoiceList.size());
            }
        }
        for (LabelAndCountAndAverage labelAndCountAndAverage : labelAndCountAndAverages) {
            labelAndCountAndAverage.setAverage(DigitUtils.getPercentageInTwoDigit((Long)labelAndCountAndAverage.getCount(), (Long)totalCount).doubleValue());
        }
        QuestionAndData questionAndData = new QuestionAndData();
        questionAndData.setSurveyQuestion(surveyQuestion);
        questionAndData.setLabelAndCountAndAverages(labelAndCountAndAverages);
        questionAndData.setTotal_survey_sent(this.instructorSurveyChoiceRepository.countByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        questionAndData.setActive_users_who_received_survey((Object)this.instructorSurveyChoiceRepository.loginCountOfInstructorForWhoLoggedAfterReceivingSurveyByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        questionAndData.setFilled_survey(this.instructorSurveyChoiceRepository.countFilledByCreatedAtBetweenFromDateAndEndDate(fromDate, toDate));
        return questionAndData;
    }

    public void syncInstructorSurvey() {
        List instructorSurveyChoices = this.instructorSurveyChoiceRepository.findAll();
        for (InstructorSurveyChoice instructorSurveyChoice : instructorSurveyChoices) {
            List items = this.instructorSurveyChoiceRepository.findBySurveyIdAndInstructorIdOrderByInstructorSurveyChoiceASC(instructorSurveyChoice.getSurvey_id(), instructorSurveyChoice.getInstructor_id());
            if (!AppUtils.isNullOrEmpty((List)items)) {
                InstructorSurveyChoice firstItem = (InstructorSurveyChoice)items.get(0);
                for (InstructorSurveyChoice item : items) {
                    item.setCreatedAt(firstItem.getCreatedAt());
                }
            }
            this.instructorSurveyChoiceRepository.saveAll((Iterable)items);
        }
    }
}

