/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpostrestriction.service;

import com.infinite.focus.server.client.StudentPushNotificationClient;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.message.repository.MessageRepository;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.studentpushnotification.request.WOWPostUnacceptableContentNotification;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.wallpostreaction.response.IsBlockedResponse;
import com.infinite.focus.server.wallpostrestriction.dto.WallPostRestrictionDTO;
import com.infinite.focus.server.wallpostrestriction.repository.WallPostRestrictionRepository;
import com.infinite.focus.server.wallpostrestriction.service.WallPostRestrictionService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WallPostRestrictionServiceImpl
implements WallPostRestrictionService {
    private final WallPostRestrictionRepository wallPostRestrictionRepository;
    private final ConfigurationRepository configurationRepository;
    private final MessageRepository messageRepository;
    private final StudentPushNotificationClient studentPushNotificationClient;
    private final StudentRepository studentRepository;

    public WallPostRestrictionServiceImpl(WallPostRestrictionRepository wallPostRestrictionRepository, ConfigurationRepository configurationRepository, MessageRepository messageRepository, StudentRepository studentRepository, StudentPushNotificationClient studentPushNotificationClient) {
        this.wallPostRestrictionRepository = wallPostRestrictionRepository;
        this.configurationRepository = configurationRepository;
        this.messageRepository = messageRepository;
        this.studentPushNotificationClient = studentPushNotificationClient;
        this.studentRepository = studentRepository;
    }

    public WallPostRestrictionDTO findById(long student_id) {
        return this.wallPostRestrictionRepository.findById(student_id);
    }

    public List<WallPostRestrictionDTO> findAll() {
        return this.wallPostRestrictionRepository.findAll();
    }

    public WallPostRestrictionDTO save(WallPostRestrictionDTO wallPostRestriction) {
        return this.wallPostRestrictionRepository.save(wallPostRestriction);
    }

    public void update(WallPostRestrictionDTO wallPostRestriction) {
        this.wallPostRestrictionRepository.update(wallPostRestriction);
    }

    public void deleteById(long student_id) {
        this.wallPostRestrictionRepository.deleteById(student_id);
    }

    public void incrementCount(long student_id, boolean demo) {
        WallPostRestrictionDTO restriction = this.wallPostRestrictionRepository.findById(student_id);
        Date getBlockedDate = null;
        if (restriction == null) {
            restriction = new WallPostRestrictionDTO();
            restriction.setStudent_id(student_id);
            restriction.setCount(1);
            restriction.setBlocked_until(new Date());
            this.wallPostRestrictionRepository.save(restriction);
        } else {
            getBlockedDate = restriction.getBlocked_until();
            if (new Date().before(getBlockedDate)) {
                return;
            }
            restriction.setCount(restriction.getCount() + 1);
            if (restriction.getCount() >= 3) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(13, (int)this.configurationRepository.getConfiguration().getTime_to_block_wow_post_in_seconds());
                restriction.setBlocked_until(calendar.getTime());
            }
            this.wallPostRestrictionRepository.update(restriction);
        }
        String message = "";
        String message_es = "";
        if (restriction.getCount() == 1 || restriction.getCount() == 2) {
            message = this.messageRepository.getMessage().getWow_post_delete_message();
            message_es = this.messageRepository.getMessage().getWow_post_delete_message_es();
        } else if (restriction.getCount() == 3) {
            message = this.messageRepository.getMessage().getWow_post_suspension_message().replace("<DATE>", DateUtils.dailyDateFormat.format(restriction.getBlocked_until()));
            message_es = this.messageRepository.getMessage().getWow_post_suspension_message_es().replace("<DATE>", DateUtils.dailyDateFormat_es.format(restriction.getBlocked_until()));
        }
        Student studentView = this.studentRepository.findByStudentId(Long.valueOf(student_id));
        WOWPostUnacceptableContentNotification wowPostUnacceptableContentNotification = WOWPostUnacceptableContentNotification.builder().student_id(student_id).account_id(studentView.getAccount_id()).demo(demo).message(message).message_es(message_es).build();
        this.studentPushNotificationClient.wowPostWorn(wowPostUnacceptableContentNotification);
    }

    public IsBlockedResponse isBlocked(long student_id) {
        WallPostRestrictionDTO restriction = this.wallPostRestrictionRepository.findById(student_id);
        if (restriction == null) {
            return IsBlockedResponse.builder().wallPostRestrictionDTO(null).blocked(false).build();
        }
        if (new Date().after(restriction.getBlocked_until()) && restriction.getCount() >= 3) {
            restriction.setCount(0);
            this.wallPostRestrictionRepository.update(restriction);
        }
        return IsBlockedResponse.builder().wallPostRestrictionDTO(restriction).blocked(restriction.getCount() >= 3 || new Date().before(restriction.getBlocked_until())).build();
    }
}

