/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.setting;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.journal.component.JournalBadWordFilterComponent;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.relationshipskills.entity.RelationshipSkillsUpdate;
import com.infinite.focus.server.relationshipskills.service.RelationshipSkillsUpdateService;
import com.infinite.focus.server.responsibledecisionmaking.entity.ResponsibleDecisionMakingUpdate;
import com.infinite.focus.server.responsibledecisionmaking.repository.ResponsibleDecisionMakingUpdateRepository;
import com.infinite.focus.server.selfmanagement.entity.SelfManagementUpdate;
import com.infinite.focus.server.selfmanagement.repository.SelfManagementUpdateRepository;
import com.infinite.focus.server.socialawareness.entity.SocialAwarenessUpdate;
import com.infinite.focus.server.socialawareness.repository.SocialAwarenessUpdateRepository;
import com.infinite.focus.server.wallpost.component.WallPostBadWordFilterComponent;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/setting"})
public class SettingController {
    @Autowired
    WallPostBadWordFilterComponent badWordFilterComponent;
    @Autowired
    JournalBadWordFilterComponent journalBadWordFilterComponent;
    @Autowired
    RelationshipSkillsUpdateService relationshipSkillsUpdateService;
    @Autowired
    DataSetService dataSetService;
    @Autowired
    MessageService messageService;
    @Autowired
    ResponsibleDecisionMakingUpdateRepository responsibleDecisionMakingUpdateRepository;
    @Autowired
    SelfManagementUpdateRepository selfManagementUpdateRepository;
    @Autowired
    SocialAwarenessUpdateRepository socialAwarenessUpdateRepository;

    @GetMapping(value={"/update/badWords"})
    public ResponseEntity<Message> updateBadWords() {
        this.badWordFilterComponent.loadConfigs();
        this.journalBadWordFilterComponent.loadConfigs();
        return new ResponseEntity((Object)new Message("Done."), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/sync/relationship-skills-update"})
    public ResponseEntity<Message> syncRelationshipSkills() {
        List relationshipSkillsUpdateList = this.relationshipSkillsUpdateService.getAllOrderByRelationshipSkillsUpdateId();
        for (RelationshipSkillsUpdate relationshipSkillsUpdate : relationshipSkillsUpdateList) {
            List<String> data_set_ids = Arrays.asList(relationshipSkillsUpdate.getData_set_ids().split("\\s*,\\s*"));
            DataSet dataSetCommunication = null;
            DataSet dataSetWorkingTogether = null;
            DataSet dataSetAskingForHelp = null;
            DataSet dataSetPeerPressure = null;
            for (String dataSetId : data_set_ids) {
                DataSet dataSet = this.dataSetService.getDataSetById(Long.parseLong(dataSetId));
                if (dataSet == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
                }
                AssessmentChildCategory assessmentChildCategory = dataSet.getAssessment_child_category();
                if (assessmentChildCategory.equals((Object)AssessmentChildCategory.COMMUNICATION)) {
                    dataSetCommunication = dataSet;
                    continue;
                }
                if (assessmentChildCategory.equals((Object)AssessmentChildCategory.WORKING_TOGETHER)) {
                    dataSetWorkingTogether = dataSet;
                    continue;
                }
                if (assessmentChildCategory.equals((Object)AssessmentChildCategory.ASK_FOR_HELP)) {
                    dataSetAskingForHelp = dataSet;
                    continue;
                }
                if (!assessmentChildCategory.equals((Object)AssessmentChildCategory.PEER_PRESSURE)) continue;
                dataSetPeerPressure = dataSet;
            }
            if (dataSetCommunication == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.communication.is.not.found"));
            }
            if (dataSetWorkingTogether == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.working.together.is.not.found"));
            }
            if (dataSetAskingForHelp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.asking.for.help.is.not.found"));
            }
            if (dataSetPeerPressure == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
            }
            relationshipSkillsUpdate.setText(dataSetCommunication.getText_to_display() + "," + dataSetWorkingTogether.getText_to_display() + "," + dataSetAskingForHelp.getText_to_display() + "," + dataSetPeerPressure.getText_to_display());
            relationshipSkillsUpdate.setText_es(dataSetCommunication.getText_to_display_es() + "," + dataSetWorkingTogether.getText_to_display_es() + "," + dataSetAskingForHelp.getText_to_display_es() + "," + dataSetPeerPressure.getText_to_display_es());
            this.relationshipSkillsUpdateService.save(relationshipSkillsUpdate);
        }
        return new ResponseEntity((Object)new Message("Done."), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/sync/responsible-decision-making-update"})
    public ResponseEntity<Message> syncResponsibleDecisionMakingUpdate() {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)new Message("Done."), (HttpStatusCode)HttpStatus.OK);
    }

    private void updateResponsibleDecisionMakingUpdateForTextES() {
        for (ResponsibleDecisionMakingUpdate responsibleDecisionMakingUpdate : this.responsibleDecisionMakingUpdateRepository.findAll()) {
            try {
                DataSet dataSet = this.dataSetService.getDataSetById(responsibleDecisionMakingUpdate.getData_set_id());
                responsibleDecisionMakingUpdate.setText(dataSet.getText_to_display());
                responsibleDecisionMakingUpdate.setText_es(dataSet.getText_to_display_es());
                this.responsibleDecisionMakingUpdateRepository.save((Object)responsibleDecisionMakingUpdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @GetMapping(value={"/sync/self-management-update"})
    public ResponseEntity<Message> syncSelfManagementUpdate() {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)new Message("Done."), (HttpStatusCode)HttpStatus.OK);
    }

    private void updateSelfManagementUpdateForTextES() {
        for (SelfManagementUpdate selfManagementUpdate : this.selfManagementUpdateRepository.findAll()) {
            try {
                DataSet dataSet = this.dataSetService.getDataSetById(selfManagementUpdate.getData_set_id());
                selfManagementUpdate.setText(dataSet.getText_to_display());
                selfManagementUpdate.setText_es(dataSet.getText_to_display_es());
                this.selfManagementUpdateRepository.save((Object)selfManagementUpdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @GetMapping(value={"/sync/social-awareness-update"})
    public ResponseEntity<Message> syncSocialAwarenessUpdate() {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)new Message("Done."), (HttpStatusCode)HttpStatus.OK);
    }

    private void updateSocialAwarenessUpdateForTextES() {
        for (SocialAwarenessUpdate socialAwarenessUpdate : this.socialAwarenessUpdateRepository.findAll()) {
            try {
                DataSet dataSet = this.dataSetService.getDataSetById(socialAwarenessUpdate.getData_set_id());
                socialAwarenessUpdate.setText(dataSet.getText_to_display());
                socialAwarenessUpdate.setText_es(dataSet.getText_to_display_es());
                this.socialAwarenessUpdateRepository.save((Object)socialAwarenessUpdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

