/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.socioemotionaltestresult.service;

import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultService;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultServiceImpl;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioEmotionalTestResultServiceImpl
implements SocioEmotionalTestResultService {
    @Autowired
    EntityManager entityManager;

    public List<SocioEmotionalTestResult> getSocioEmotionalTestResultByStudentIds(List<Long> student_ids, TimeLine timeLine) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocioEmotionalTestResult.class);
        Root root = query.from(SocioEmotionalTestResult.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<SocioEmotionalTestResult>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
        System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new Date()));
        predicates.add(criteriaBuilder.greaterThan((Expression)root.get("createdAt"), (Comparable)toDate));
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socioEmotionalTestResultList = typedQuery.getResultList();
        System.out.println("SocioEmotionalTestResult Count = " + socioEmotionalTestResultList.size());
        return socioEmotionalTestResultList;
    }

    public LinkedHashMap<String[], List<SocioEmotionalTestResult>> getSocioEmotionalTestResultMapByTimeLine(TimeLine timeLine, List<SocioEmotionalTestResult> socioEmotionalTestResultList, String language) {
        LinkedHashMap testResultMap = null;
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$TimeLine[timeLine.ordinal()]) {
            case 1: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getDailyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.dailyDateFormat.format(testResult.getCreatedAt());
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.dailyDateFormat_es.format(testResult.getCreatedAt());
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
            case 2: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getWeeklyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.getWeekendByDate((Date)testResult.getCreatedAt(), (String)"en");
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.getWeekendByDate((Date)testResult.getCreatedAt(), (String)"es");
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
            case 3: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getMonthlyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.monthlyDateFormat.format(testResult.getCreatedAt());
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.monthlyDateFormat_es.format(testResult.getCreatedAt());
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
            case 4: {
                testResultMap = this.fillSocioEmotionalTestResultMap(DateUtils.getYearlyLabels((String)language));
                for (SocioEmotionalTestResult testResult : socioEmotionalTestResultList) {
                    String[] keys = new String[2];
                    keys[0] = DateUtils.yearlyDateFormat.format(testResult.getCreatedAt());
                    if (Language.isSpanish((String)language)) {
                        keys[1] = DateUtils.yearlyDateFormat_es.format(testResult.getCreatedAt());
                    }
                    AppUtils.addValueTotMap((LinkedHashMap)testResultMap, (String[])keys, (Object)testResult);
                }
                break;
            }
        }
        return testResultMap;
    }

    /*
     * Exception decompiling
     */
    public LinkedHashMap<String[], List<SocioEmotionalTestResult>> getSocioEmotionalTestResultMapByTimeLine2(TimeLine timeLine, List<SocioEmotionalTestResult> socioEmotionalTestResultList, String language) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LinkedHashMap<String[], List<SocioEmotionalTestResult>> fillSocioEmotionalTestResultMap(List<String[]> keys) {
        LinkedHashMap<String[], List<SocioEmotionalTestResult>> map = new LinkedHashMap<String[], List<SocioEmotionalTestResult>>();
        for (String[] key : keys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    public List<SocioEmotionalTestResult> getSocioEmotionalTestResultByStudentIds(LinkedHashSet<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(SocioEmotionalTestResult.class);
        Root root = query.from(SocioEmotionalTestResult.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
            predicates.add(genderPredicate);
        }
        if (fromDate != null && toDate != null) {
            System.out.println("getSocioEmotionalTestResultByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List socioEmotionalTestResultList = typedQuery.getResultList();
        System.out.println("SocioEmotionalTestResult Count = " + socioEmotionalTestResultList.size());
        return socioEmotionalTestResultList;
    }

    private static /* synthetic */ String[] lambda$getSocioEmotionalTestResultMapByTimeLine2$3(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }

    private static /* synthetic */ String[] lambda$getSocioEmotionalTestResultMapByTimeLine2$2(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }

    private static /* synthetic */ String[] lambda$getSocioEmotionalTestResultMapByTimeLine2$1(Map.Entry entry) {
        return new String[]{(String)entry.getKey(), (String)entry.getValue()};
    }
}

