/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpvstate.service;

import com.infinite.focus.server.assessment.dto.AssessmentDTO;
import com.infinite.focus.server.assessment.request.GetByStudentIdAndBetweenFromDateAndToDateRequest;
import com.infinite.focus.server.client.AssessmentClient;
import com.infinite.focus.server.client.PVStateClient;
import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.pvstate.dto.PVStateDTO;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.pvstate.request.GetAvgPVStateByPVStatesRequest;
import com.infinite.focus.server.studentpvstate.model.LabelAndStrValue;
import com.infinite.focus.server.studentpvstate.service.StudentPVStateService;
import com.infinite.focus.server.studentpvstate.service.StudentPVStateServiceImpl;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.FromDateToDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StudentPVStateServiceImpl
implements StudentPVStateService {
    private final AssessmentClient assessmentClient;
    private final PVStateClient pvStateClient;

    public StudentPVStateServiceImpl(AssessmentClient assessmentClient, PVStateClient pvStateClient) {
        this.assessmentClient = assessmentClient;
        this.pvStateClient = pvStateClient;
    }

    public List<LabelAndStrValue> getByTimeLine(long student_id, TimeLine timeLine, TimeZone timeZone) {
        ArrayList<LabelAndStrValue> labelAndStrValues = new ArrayList<LabelAndStrValue>();
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$model$TimeLine[timeLine.ordinal()]) {
            case 1: {
                List datesForDailyTimeLine = DateUtils.getDatesForDailyTimeLine((TimeZone)timeZone);
                List assessmentDTOS = this.getAssessmentByStudentIdAndFromDateToDate(student_id, datesForDailyTimeLine);
                for (FromDateToDate fromDateToDate : datesForDailyTimeLine) {
                    System.out.println("Daily: FromDate: " + DateUtils.getDateInString((Date)fromDateToDate.getFromDate()) + " toDate: " + DateUtils.getDateInString((Date)fromDateToDate.getToDate()));
                    labelAndStrValues.add(LabelAndStrValue.builder().label(DateUtils.getDateByLanguage((Date)fromDateToDate.getToDate(), (TimeZone)timeZone, (String)Language.getLanguage())).value(this.getAvgPVState(assessmentDTOS, fromDateToDate.getFromDate(), fromDateToDate.getToDate())).build());
                }
                break;
            }
            case 2: {
                List datesForWeeklyTimeLine = DateUtils.getDatesForWeeklyTimeLine((TimeZone)timeZone);
                List assessmentDTOS = this.getAssessmentByStudentIdAndFromDateToDate(student_id, datesForWeeklyTimeLine);
                for (FromDateToDate fromDateToDate : datesForWeeklyTimeLine) {
                    System.out.println("Weekly: FromDate: " + DateUtils.getDateInString((Date)fromDateToDate.getFromDate(), (TimeZone)TimeZone.getDefault()) + " toDate: " + DateUtils.getDateInString((Date)fromDateToDate.getToDate(), (TimeZone)TimeZone.getDefault()));
                    labelAndStrValues.add(LabelAndStrValue.builder().label(DateUtils.getWeeklyLabelByFromDateToDateAndLanguage((Date)fromDateToDate.getFromDate(), (Date)fromDateToDate.getToDate(), (TimeZone)timeZone, (String)Language.getLanguage())).value(this.getAvgPVState(assessmentDTOS, fromDateToDate.getFromDate(), fromDateToDate.getToDate())).build());
                }
                break;
            }
            case 3: {
                List datesForMonthlyTimeLine = DateUtils.getDatesForMonthlyTimeLine((TimeZone)timeZone);
                List assessmentDTOS = this.getAssessmentByStudentIdAndFromDateToDate(student_id, datesForMonthlyTimeLine);
                for (FromDateToDate fromDateToDate : datesForMonthlyTimeLine) {
                    System.out.println("Monthly: FromDate: " + DateUtils.getDateInString((Date)fromDateToDate.getFromDate(), (TimeZone)TimeZone.getDefault()) + " toDate: " + DateUtils.getDateInString((Date)fromDateToDate.getToDate(), (TimeZone)TimeZone.getDefault()));
                    labelAndStrValues.add(LabelAndStrValue.builder().label(DateUtils.getMonthlyLabelByDateAndLanguage((Date)fromDateToDate.getFromDate(), (TimeZone)timeZone, (String)Language.getLanguage())).value(PVState.VENTRAL.toString()).value(this.getAvgPVState(assessmentDTOS, fromDateToDate.getFromDate(), fromDateToDate.getToDate())).build());
                }
                break;
            }
            case 4: {
                List datesForYearlyTimeLine = DateUtils.getDatesForYearlyTimeLine((TimeZone)timeZone);
                List assessmentDTOS = this.getAssessmentByStudentIdAndFromDateToDate(student_id, datesForYearlyTimeLine);
                for (FromDateToDate fromDateToDate : datesForYearlyTimeLine) {
                    System.out.println("Yearly: FromDate: " + DateUtils.getDateInString((Date)fromDateToDate.getFromDate(), (TimeZone)TimeZone.getDefault()) + " toDate: " + DateUtils.getDateInString((Date)fromDateToDate.getToDate(), (TimeZone)TimeZone.getDefault()));
                    labelAndStrValues.add(LabelAndStrValue.builder().label(DateUtils.getYearlyLabelByDateAndLanguage((Date)fromDateToDate.getFromDate(), (TimeZone)timeZone, (String)Language.getLanguage())).value(this.getAvgPVState(assessmentDTOS, fromDateToDate.getFromDate(), fromDateToDate.getToDate())).build());
                }
                break;
            }
        }
        return labelAndStrValues;
    }

    private List<AssessmentDTO> getAssessmentByStudentIdAndFromDateToDate(long student_id, List<FromDateToDate> datesForDailyTimeLine) {
        return this.assessmentClient.getAssessmentPVStateByStudentId(GetByStudentIdAndBetweenFromDateAndToDateRequest.builder().student_id(student_id).from_date(datesForDailyTimeLine.get(datesForDailyTimeLine.size() - 1).getFromDate()).to_date(datesForDailyTimeLine.get(0).getToDate()).build());
    }

    private String getAvgPVState(List<AssessmentDTO> assessmentDTOS, Date fromDate, Date toDate) {
        List pvStates = assessmentDTOS.stream().filter(a -> DateUtils.isDateInBetweenFromDateAndToDate((Date)fromDate, (Date)toDate, (Date)a.getCreatedAt())).map(AssessmentDTO::getPv_state).filter(Objects::nonNull).collect(Collectors.toList());
        PVStateDTO pvState = null;
        if (!AppUtils.isNullOrEmpty(pvStates)) {
            pvState = this.pvStateClient.getAvgPVStateByPVStates(GetAvgPVStateByPVStatesRequest.builder().pv_states(pvStates).build());
        }
        return pvState != null ? pvState.getPv_state().toString() : null;
    }
}

