/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.school.repository;

import com.infinite.focus.server.school.entity.School;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface SchoolRepository
extends JpaRepository<School, Long> {
    @Query(value="SELECT * FROM school WHERE account_id = ?1 ", nativeQuery=true)
    public List<School> findByAccountId(Long var1);

    @Query(value="SELECT * FROM school WHERE school_id = ?1 ", nativeQuery=true)
    public School findBySchoolId(Long var1);

    @Query(value="SELECT * FROM school", nativeQuery=true)
    public Page<School> findAllSchools(Pageable var1);

    @Query(value="SELECT * FROM school WHERE school_name LIKE ?1", nativeQuery=true)
    public Page<School> findBySchoolName(String var1, Pageable var2);

    @Query(value="SELECT * FROM school WHERE clever_id = ?1 ", nativeQuery=true)
    public School findByCleverSchoolId(String var1);

    @Query(value="SELECT * FROM school WHERE district_id = ?1 ORDER BY school_name", nativeQuery=true)
    public List<School> findByDistrictId(Long var1);

    @Query(value="SELECT * FROM school WHERE registration_code = ?1", nativeQuery=true)
    public School findByRegistrationCode(String var1);

    @Query(value="SELECT * FROM school WHERE license_key = ?1", nativeQuery=true)
    public List<School> findByLicenseKey(String var1);

    @Query(value="SELECT * FROM school ORDER BY school_id ASC", nativeQuery=true)
    public List<School> findAllSchoolsOrderBySchoolIdASC();

    @Query(value="SELECT sch.*,acc.username FROM school sch JOIN account acc ON sch.account_id = acc.account_id WHERE acc.username IS NOT NULL AND acc.username != ''", nativeQuery=true)
    public List<School> getAllSchools();
}

