/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.submood.service;

import com.infinite.focus.server.client.FeelsLikeClient;
import com.infinite.focus.server.client.LooksLikeClient;
import com.infinite.focus.server.client.MoodAndColorClient;
import com.infinite.focus.server.client.SubMoodAndFeelsLikeClient;
import com.infinite.focus.server.client.SubMoodAndLooksLikeClient;
import com.infinite.focus.server.client.SubMoodAndStandardClient;
import com.infinite.focus.server.feelslike.dto.FeelsLikeDTO;
import com.infinite.focus.server.feelslike.request.GetFeelsLikesByFeelsLikeIds;
import com.infinite.focus.server.lookslike.dto.LooksLikeDTO;
import com.infinite.focus.server.lookslike.request.GetLooksLikesByLooksLikeIds;
import com.infinite.focus.server.moodandcolor.dto.MoodAndColorDTO;
import com.infinite.focus.server.moodandcolor.request.GetMoodAndColorByMoodIdRequest;
import com.infinite.focus.server.submood.dto.SubMoodDTO;
import com.infinite.focus.server.submood.repository.SubMoodRepository;
import com.infinite.focus.server.submood.request.GetSubMoodsByMoodIdAndStandardIdRequest;
import com.infinite.focus.server.submood.service.SubMoodService;
import com.infinite.focus.server.submood.wrapper.SubMoodWrapper;
import com.infinite.focus.server.submood.wrapper.SubMoodsAndColorWrapper;
import com.infinite.focus.server.submoodandfeelslike.dto.SubMoodAndFeelsLikeDTO;
import com.infinite.focus.server.submoodandfeelslike.request.GetSubMoodAndFeelsLikesByMoodIdAndStandardIdAndSubMoodId;
import com.infinite.focus.server.submoodandlookslike.dto.SubMoodAndLooksLikeDTO;
import com.infinite.focus.server.submoodandlookslike.request.GetSubMoodAndLooksLikesByMoodIdAndStandardIdAndSubMoodId;
import com.infinite.focus.server.submoodandstandard.dto.SubMoodAndStandardDTO;
import com.infinite.focus.server.utils.AppUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SubMoodServiceImpl
implements SubMoodService {
    private final SubMoodRepository subMoodRepository;
    private final SubMoodAndLooksLikeClient subMoodAndLooksLikeClient;
    private final LooksLikeClient looksLikeClient;
    private final SubMoodAndFeelsLikeClient subMoodAndFeelsLikeClient;
    private final FeelsLikeClient feelsLikeClient;
    private final MoodAndColorClient moodAndColorClient;
    private final SubMoodAndStandardClient subMoodAndStandardClient;

    public SubMoodServiceImpl(SubMoodRepository subMoodRepository, SubMoodAndLooksLikeClient subMoodAndLooksLikeClient, LooksLikeClient looksLikeClient, SubMoodAndFeelsLikeClient subMoodAndFeelsLikeClient, FeelsLikeClient feelsLikeClient, MoodAndColorClient moodAndColorClient, SubMoodAndStandardClient subMoodAndStandardClient) {
        this.subMoodRepository = subMoodRepository;
        this.subMoodAndLooksLikeClient = subMoodAndLooksLikeClient;
        this.looksLikeClient = looksLikeClient;
        this.subMoodAndFeelsLikeClient = subMoodAndFeelsLikeClient;
        this.feelsLikeClient = feelsLikeClient;
        this.moodAndColorClient = moodAndColorClient;
        this.subMoodAndStandardClient = subMoodAndStandardClient;
    }

    public SubMoodsAndColorWrapper getSubMoodsByMoodIdAndStandardId(Long mood_id, Long standard_id) {
        List subMoodAndStandardDTOList = this.subMoodAndStandardClient.getByMoodIdAndStandardId(GetSubMoodsByMoodIdAndStandardIdRequest.builder().mood_id(mood_id).standard_id(standard_id).build());
        List subMoodDTOList = this.subMoodRepository.findByIds(subMoodAndStandardDTOList.stream().map(SubMoodAndStandardDTO::getSub_mood_id).collect(Collectors.toSet()));
        ArrayList<SubMoodWrapper> subMoodWrappers = new ArrayList<SubMoodWrapper>();
        List topSubMoods = subMoodAndStandardDTOList.stream().filter(subMoodAndStandardDTO -> subMoodAndStandardDTO.getTop_sub_mood_id() == 0L).sorted(Comparator.comparingInt(SubMoodAndStandardDTO::getSort_index)).collect(Collectors.toList());
        for (SubMoodAndStandardDTO subMoodAndStandardDTO2 : topSubMoods) {
            Optional<SubMoodDTO> optionalSubMoodDTO = subMoodDTOList.stream().filter(item -> item.getSub_mood_id() == subMoodAndStandardDTO2.getSub_mood_id()).findAny();
            if (!optionalSubMoodDTO.isPresent()) continue;
            SubMoodDTO subMoodDTO = optionalSubMoodDTO.get();
            SubMoodWrapper wrapper = new SubMoodWrapper();
            wrapper.setSub_mood_id(subMoodDTO.getSub_mood_id());
            wrapper.setText(subMoodDTO.getSub_mood());
            wrapper.setText_es(subMoodDTO.getSub_mood_es());
            wrapper.setImage(subMoodAndStandardDTO2.getImage());
            wrapper.setColor(subMoodAndStandardDTO2.getColor());
            wrapper.setPv_state(subMoodAndStandardDTO2.getPv_state());
            wrapper.setLooks_likes(this.getLooksLikesByMoodIdAndStandardIdAndSubMoodId(Long.valueOf(subMoodAndStandardDTO2.getMood_id()), Long.valueOf(subMoodAndStandardDTO2.getStandard_id()), Long.valueOf(subMoodAndStandardDTO2.getSub_mood_id())));
            wrapper.setFeels_likes(this.getFeelsLikesByMoodIdAndStandardIdAndSubMoodId(Long.valueOf(subMoodAndStandardDTO2.getMood_id()), Long.valueOf(subMoodAndStandardDTO2.getStandard_id()), Long.valueOf(subMoodAndStandardDTO2.getSub_mood_id())));
            subMoodWrappers.add(wrapper);
        }
        for (SubMoodWrapper subMoodWrapper : subMoodWrappers) {
            subMoodWrapper.setSub_moods(this.buildSubMoodWrapper(subMoodWrapper, subMoodAndStandardDTOList, subMoodDTOList));
        }
        MoodAndColorDTO moodAndColorDTO = this.moodAndColorClient.getMoodAndColorByMoodId(GetMoodAndColorByMoodIdRequest.builder().mood_id(mood_id).build());
        return SubMoodsAndColorWrapper.builder().sub_moods(subMoodWrappers).mood_color(moodAndColorDTO).build();
    }

    public List<SubMoodDTO> getAllSubMoods() {
        return this.subMoodRepository.findAllSubMoods();
    }

    private List<SubMoodWrapper> buildSubMoodWrapper(SubMoodWrapper subMoodWrapper, List<SubMoodAndStandardDTO> subMoodAndStandardDTOList, List<SubMoodDTO> subMoodDTOList) {
        ArrayList<SubMoodWrapper> subMoodWrappers = new ArrayList<SubMoodWrapper>();
        List topSubMoods = subMoodAndStandardDTOList.stream().filter(subMoodAndStandardDTO -> subMoodAndStandardDTO.getTop_sub_mood_id() == subMoodWrapper.getSub_mood_id()).sorted(Comparator.comparingInt(SubMoodAndStandardDTO::getSort_index)).collect(Collectors.toList());
        for (SubMoodAndStandardDTO subMoodAndStandardDTO2 : topSubMoods) {
            Optional<SubMoodDTO> optionalSubMoodDTO = subMoodDTOList.stream().filter(item -> item.getSub_mood_id() == subMoodAndStandardDTO2.getSub_mood_id()).findAny();
            if (!optionalSubMoodDTO.isPresent()) continue;
            SubMoodDTO subMoodDTO = optionalSubMoodDTO.get();
            SubMoodWrapper wrapper = new SubMoodWrapper();
            wrapper.setSub_mood_id(subMoodDTO.getSub_mood_id());
            wrapper.setText(subMoodDTO.getSub_mood());
            wrapper.setText_es(subMoodDTO.getSub_mood_es());
            wrapper.setImage(subMoodAndStandardDTO2.getImage());
            wrapper.setSub_moods(this.buildSubMoodWrapper(wrapper, subMoodAndStandardDTOList, subMoodDTOList));
            wrapper.setImage(subMoodAndStandardDTO2.getImage());
            wrapper.setColor(subMoodAndStandardDTO2.getColor());
            wrapper.setPv_state(subMoodAndStandardDTO2.getPv_state());
            wrapper.setLooks_likes(this.getLooksLikesByMoodIdAndStandardIdAndSubMoodId(Long.valueOf(subMoodAndStandardDTO2.getMood_id()), Long.valueOf(subMoodAndStandardDTO2.getStandard_id()), Long.valueOf(subMoodAndStandardDTO2.getSub_mood_id())));
            wrapper.setFeels_likes(this.getFeelsLikesByMoodIdAndStandardIdAndSubMoodId(Long.valueOf(subMoodAndStandardDTO2.getMood_id()), Long.valueOf(subMoodAndStandardDTO2.getStandard_id()), Long.valueOf(subMoodAndStandardDTO2.getSub_mood_id())));
            subMoodWrappers.add(wrapper);
        }
        return subMoodWrappers;
    }

    private List<LooksLikeDTO> getLooksLikesByMoodIdAndStandardIdAndSubMoodId(Long mood_id, Long standard_id, Long sub_mood_id) {
        List subMoodAndLooksLikeDTOList = this.subMoodAndLooksLikeClient.getSubMoodAndLooksLikesByMoodIdAndStandardIdAndSubMoodId(GetSubMoodAndLooksLikesByMoodIdAndStandardIdAndSubMoodId.builder().mood_id(mood_id).standard_id(standard_id).sub_mood_id(sub_mood_id).build());
        if (!AppUtils.isNullOrEmpty((List)subMoodAndLooksLikeDTOList)) {
            List looksLikeIds = subMoodAndLooksLikeDTOList.stream().map(SubMoodAndLooksLikeDTO::getLooks_like_id).distinct().collect(Collectors.toList());
            List looksLikeDTOList = this.looksLikeClient.getLooksLikesByLooksLikeIds(GetLooksLikesByLooksLikeIds.builder().looks_like_ids(looksLikeIds).build());
            if (!AppUtils.isNullOrEmpty((List)looksLikeDTOList)) {
                return subMoodAndLooksLikeDTOList.stream().map(subMoodAndLooksLikeDTO -> looksLikeDTOList.stream().filter(looksLikeDTO -> looksLikeDTO.getLooks_like_id() == subMoodAndLooksLikeDTO.getLooks_like_id()).findAny().get()).collect(Collectors.toList());
            }
        }
        return new ArrayList<LooksLikeDTO>();
    }

    private List<FeelsLikeDTO> getFeelsLikesByMoodIdAndStandardIdAndSubMoodId(Long mood_id, Long standard_id, Long sub_mood_id) {
        List subMoodAndFeelsLikeDTOList = this.subMoodAndFeelsLikeClient.getSubMoodAndFeelsLikesByMoodIdAndStandardIdAndSubMoodId(GetSubMoodAndFeelsLikesByMoodIdAndStandardIdAndSubMoodId.builder().mood_id(mood_id).standard_id(standard_id).sub_mood_id(sub_mood_id).build());
        if (!AppUtils.isNullOrEmpty((List)subMoodAndFeelsLikeDTOList)) {
            List feelsLikeIds = subMoodAndFeelsLikeDTOList.stream().map(SubMoodAndFeelsLikeDTO::getFeels_like_id).distinct().collect(Collectors.toList());
            List feelsLikeDTOList = this.feelsLikeClient.getFeelsLikesByFeelsLikeIds(GetFeelsLikesByFeelsLikeIds.builder().feels_like_ids(feelsLikeIds).build());
            if (!AppUtils.isNullOrEmpty((List)feelsLikeDTOList)) {
                return subMoodAndFeelsLikeDTOList.stream().map(subMoodAndFeelsLikeDTO -> feelsLikeDTOList.stream().filter(feelsLikeDTO -> feelsLikeDTO.getFeels_like_id() == subMoodAndFeelsLikeDTO.getFeels_like_id()).findAny().get()).collect(Collectors.toList());
            }
        }
        return new ArrayList<FeelsLikeDTO>();
    }
}

