/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.accesscode.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.student.entity.Student;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.Random;

@Entity
public class AccessCode {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long access_code_id;
    @Transient
    private long student_id;
    @Transient
    private long instructor_id;
    @Column(name="access_code")
    private String accessCode;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", columnDefinition="enum('PENDING','ACCEPTED','REJECTED')")
    private Status status;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @OneToOne(targetEntity=Student.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="student_id", unique=true, foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"parent", "classes", "standard", "instructor"})
    private Student student;
    @OneToOne(targetEntity=Instructor.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=true, name="instructor_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"standards"})
    private Instructor instructor;
    @ManyToOne(targetEntity=Parent.class, fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="parent_id", foreignKey=@ForeignKey(name="none"))
    @JsonIgnoreProperties(value={"students"})
    private Parent parent;

    public AccessCode() {
    }

    public AccessCode(Student student, Instructor instructor, Parent parent) {
        this.student = student;
        this.instructor = instructor;
        this.parent = parent;
        this.accessCode = this.getRandomNumberString();
        this.status = Status.PENDING;
        this.createdDate = new Date();
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public long getStudent_id() {
        return this.student.getStudent_id();
    }

    public void setStudent_id(long student_id) {
        this.student_id = student_id;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setStudent(Student student) {
        this.student = student;
    }

    public Student getStudent() {
        return this.student;
    }

    public void setInstructor(Instructor instructor) {
        this.instructor = instructor;
    }

    public Instructor getInstructor() {
        return this.instructor;
    }

    public long getInstructor_id() {
        return this.instructor.getInstructor_id();
    }

    public void setInstructor_id(long instructor_id) {
        this.instructor_id = instructor_id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getAccess_code_id() {
        return this.access_code_id;
    }

    public void setAccess_code_id(long access_code_id) {
        this.access_code_id = access_code_id;
    }

    @JsonIgnore
    public String getRandomNumberString() {
        Random rnd = new Random();
        int number = rnd.nextInt(999999);
        return String.format("%06d", number);
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }
}

