/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity.repository;

import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.entity.Activity;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityCriteriaRepositoryImpl
implements ActivityCriteriaRepository {
    @Autowired
    EntityManager entityManager;

    public List<ActivityDTO> getAllStudentActivitiesByActivityType(GetDataDashBoardRequest request, Long activity_type_id) {
        TimeLine timeLine = request.getTimeLine();
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student").get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression birthYear = qb.function("YEAR", Integer.class, new Expression[]{root.get("student").get("date_of_birth")});
            Expression currentYear = qb.function("YEAR", Integer.class, new Expression[]{qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            Expression ageDifference = qb.diff(currentYear, birthYear);
            CriteriaBuilder.In inClause = qb.in(ageDifference);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)root.get("student").get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = root.get("student").get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        predicates.add(qb.isNotNull((Expression)root.get("student").get("account").get("username")));
        predicates.add(qb.notEqual((Expression)root.get("student").get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)root.get("student").get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        if (timeLine != null) {
            java.util.Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
            predicates.add(qb.greaterThan((Expression)root.get("start_date_time"), (Comparable)toDate));
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getAllStudentActivitiesByActivityType2(GetDataDashBoardRequest request, Long activity_type_id) {
        TimeLine timeLine = request.getTimeLine();
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student").get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression birthYear = qb.function("YEAR", Integer.class, new Expression[]{root.get("student").get("date_of_birth")});
            Expression currentYear = qb.function("YEAR", Integer.class, new Expression[]{qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            Expression ageDifference = qb.diff(currentYear, birthYear);
            CriteriaBuilder.In inClause = qb.in(ageDifference);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)root.get("student").get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = root.get("student").get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        predicates.add(qb.isNotNull((Expression)root.get("student").get("account").get("username")));
        predicates.add(qb.notEqual((Expression)root.get("student").get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)root.get("student").get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        if (request.getFromDate() != null && request.getToDate() != null) {
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getAllInstructorActivitiesByActivityType(GetDataDashBoardRequest request, Long activity_type_id) {
        TimeLine timeLine = request.getTimeLine();
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Tuple.class);
        Root root = query.from(Activity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Root activityRoot = sq.correlate(root);
            Join sqRoot = activityRoot.join("instructor");
            Join sqJoin = sqRoot.join("standards");
            sq.where((Expression)sqJoin.get("grade").get("grade_id").in((Collection)request.getGradeIds()));
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        predicates.add(qb.notEqual((Expression)root.get("instructor").get("instructor_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        if (timeLine != null) {
            java.util.Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
            System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new java.util.Date()));
            predicates.add(qb.greaterThan((Expression)root.get("start_date_time"), (Comparable)toDate));
        } else if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getAllInstructorActivitiesByActivityType FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.multiselect(this.getActivityDTOSelectionForInstructor(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForInstructor(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getAllInstructorActivitiesByActivityType2(GetDataDashBoardRequest request, Long activity_type_id) {
        TimeLine timeLine = request.getTimeLine();
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Tuple.class);
        Root root = query.from(Activity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Root activityRoot = sq.correlate(root);
            Join sqRoot = activityRoot.join("instructor");
            Join sqJoin = sqRoot.join("standards");
            sq.where((Expression)sqJoin.get("grade").get("grade_id").in((Collection)request.getGradeIds()));
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        predicates.add(qb.notEqual((Expression)root.get("instructor").get("instructor_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getAllInstructorActivitiesByActivityType FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.multiselect(this.getActivityDTOSelectionForInstructor(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForInstructor(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getTimeSpentByStudentIds(List<Long> student_ids, TimeLine timeLine, java.util.Date fromDate, java.util.Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(criteriaBuilder.equal((Expression)root.get("activity_type_id"), (Object)1));
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student").get("student_id")).value(student_ids);
            predicates.add(genderPredicate);
        }
        if (fromDate != null && toDate != null) {
            System.out.println("Using custom date range: " + DateUtils.dailyDateFormat.format(fromDate) + " to " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("start_date_time"), (Comparable)fromDate, (Comparable)toDate));
        } else {
            java.util.Date toDateByTimeline = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
            System.out.println("Using timeline: " + timeLine + " | ToDate: " + DateUtils.dailyDateFormat.format(toDateByTimeline));
            predicates.add(criteriaBuilder.greaterThan((Expression)root.get("start_date_time"), (Comparable)toDateByTimeline));
        }
        Path usernamePath = root.get("student").get("account").get("username");
        predicates.add(criteriaBuilder.isNotNull((Expression)usernamePath));
        predicates.add(criteriaBuilder.notEqual((Expression)usernamePath, (Object)""));
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        System.out.println("Activity Count = " + activityList.size());
        return activityList;
    }

    public List<ActivityDTO> getTimeSpentByStudentIds(List<Long> student_ids, TimeLine timeLine) {
        return this.getTimeSpentByStudentIds(student_ids, timeLine, null, null);
    }

    public List<ActivityDTO> getActivitiesByStudentIdsAndBetweenFromDateAndToDate(List<Long> student_ids, java.util.Date fromDate, java.util.Date toDate) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)1));
        CriteriaBuilder.In studentIdsPredicate = qb.in((Expression)root.get("student").get("student_id")).value(student_ids);
        predicates.add(studentIdsPredicate);
        System.out.println("getActivitiesByStudentIdsAndBetweenFromDateAndToDate FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
        predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)fromDate, (Comparable)toDate));
        predicates.add(qb.isNotNull((Expression)root.get("student").get("account").get("username")));
        predicates.add(qb.notEqual((Expression)root.get("student").get("account").get("username"), (Object)""));
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getStudentActivitiesByActivityTypeIdAndEntityIdsAndStartDateTimeBetweenFormDateTimeAndToDateTime(Long activity_type_id, List<Long> post_ids, java.util.Date fromDate, java.util.Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(criteriaBuilder.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        predicates.add(criteriaBuilder.in((Expression)root.get("entity_id")).value(post_ids));
        predicates.add(criteriaBuilder.notEqual((Expression)root.get("student").get("student_id"), (Object)0L));
        predicates.add(criteriaBuilder.isNotNull((Expression)root.get("student").get("account").get("username")));
        predicates.add(criteriaBuilder.notEqual((Expression)root.get("student").get("account").get("username"), (Object)""));
        predicates.add(criteriaBuilder.between((Expression)root.get("start_date_time"), (Comparable)fromDate, (Comparable)toDate));
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getAllStudentActivitiesByActivityTypeIdAndEntityId(GetDataDashBoardRequest request, Long activity_type_id, Long entity_id) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)root.get("student").get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression year = qb.literal((Object)"YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, root.get("student").get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)root.get("student").get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = root.get("student").get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.isNotNull((Expression)root.get("student").get("account").get("username")));
        predicates.add(qb.notEqual((Expression)root.get("student").get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)root.get("student").get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        predicates.add(qb.equal((Expression)root.get("entity_id"), (Object)entity_id));
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getMoodInsightPost(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            Expression year = qb.literal((Object)"YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            Predicate gradePredicate = s.get("standard").get("grade").get("grade_id").in((Collection)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_before())) {
            CriteriaBuilder.In moodUpdateBeforePredicate = qb.in((Expression)root.get("mood_update_before")).value((Object)request.getMood_update_before());
            predicates.add(moodUpdateBeforePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_after())) {
            CriteriaBuilder.In moodUpdateAfterPredicate = qb.in((Expression)root.get("mood_update_after")).value((Object)request.getMood_update_after());
            predicates.add(moodUpdateAfterPredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getMoodInsightPost FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.isNotNull((Expression)s.get("account").get("username")));
        predicates.add(qb.notEqual((Expression)s.get("account").get("username"), (Object)""));
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)4));
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    public List<ActivityDTO> getMoodInsightPostByStudentIds(List<Long> student_ids, java.util.Date fromDate, java.util.Date toDate) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Object[].class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        System.out.println("getMoodInsightPostByStudentIds FromDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(fromDate) + " - ToDate " + DateUtils.yearMonthDateHoursMinutesSeconds.format(toDate));
        predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)fromDate, (Comparable)toDate));
        predicates.add(qb.in((Expression)s.get("student_id")).value(student_ids));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)4));
        query.multiselect(this.getActivityDTOSelectionForStudent(root)).where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = this.mapActivityObjectsToActivityDTOsForStudent(typedQuery);
        return activityList;
    }

    private List<Selection<?>> getActivityDTOSelectionForStudent(Root<Activity> root) {
        ArrayList selectionList = new ArrayList();
        selectionList.add((Selection<?>)root.get("activity_id"));
        selectionList.add((Selection<?>)root.get("student").get("gender"));
        selectionList.add((Selection<?>)root.get("student").get("date_of_birth"));
        selectionList.add((Selection<?>)root.get("student").get("ethnicity"));
        selectionList.add((Selection<?>)root.get("student").get("standard").get("grade").get("grade_id"));
        selectionList.add((Selection<?>)root.get("student").get("student_id"));
        selectionList.add((Selection<?>)root.get("instructor").get("instructor_id"));
        selectionList.add((Selection<?>)root.get("start_date_time"));
        selectionList.add((Selection<?>)root.get("end_date_time"));
        selectionList.add((Selection<?>)root.get("entity_id"));
        selectionList.add((Selection<?>)root.get("watch_duration"));
        selectionList.add((Selection<?>)root.get("mood_update_before"));
        selectionList.add((Selection<?>)root.get("level_of_focus_before"));
        selectionList.add((Selection<?>)root.get("mood_update_after"));
        selectionList.add((Selection<?>)root.get("level_of_focus_after"));
        selectionList.add((Selection<?>)root.get("mood_update_id_before"));
        selectionList.add((Selection<?>)root.get("mood_update_id_after"));
        return selectionList;
    }

    private List<ActivityDTO> mapActivityObjectsToActivityDTOsForStudent(TypedQuery<Object[]> typedQuery) {
        List<ActivityDTO> activityDTOList = typedQuery.getResultList().stream().map(item -> ActivityDTO.builder().activity_id(((Long)item[0]).longValue()).gender((String)item[1]).date_of_birth((Date)item[2]).ethnicity((String)item[3]).grade_id((Long)item[4]).student_id((Long)item[5]).instructor_id((Long)item[6]).start_date_time((java.util.Date)item[7]).end_date_time((java.util.Date)item[8]).entity_id(((Long)item[9]).longValue()).watch_duration(((Long)item[10]).longValue()).mood_update_before((String)item[11]).level_of_focus_before(((Float)item[12]).floatValue()).mood_update_after((String)item[13]).level_of_focus_after(((Float)item[14]).floatValue()).mood_update_id_before(((Long)item[15]).longValue()).mood_update_id_after(((Long)item[16]).longValue()).build()).collect(Collectors.toList());
        return activityDTOList;
    }

    private List<Selection<?>> getActivityDTOSelectionForInstructor(Root<Activity> root) {
        ArrayList selectionList = new ArrayList();
        selectionList.add(root.get("activity_id").alias("activity_id"));
        selectionList.add(root.get("instructor").get("instructor_id").alias("instructor_id"));
        selectionList.add(root.get("start_date_time").alias("start_date_time"));
        selectionList.add(root.get("end_date_time").alias("end_date_time"));
        selectionList.add(root.get("entity_id").alias("entity_id"));
        selectionList.add(root.get("watch_duration").alias("watch_duration"));
        return selectionList;
    }

    private List<ActivityDTO> mapActivityObjectsToActivityDTOsForInstructor(TypedQuery<Tuple> typedQuery) {
        List<ActivityDTO> activityDTOList = typedQuery.getResultList().stream().map(item -> ActivityDTO.builder().activity_id(((Long)item.get("activity_id")).longValue()).instructor_id((Long)item.get("instructor_id")).start_date_time((java.util.Date)item.get("start_date_time")).end_date_time((java.util.Date)item.get("end_date_time")).entity_id(((Long)item.get("entity_id")).longValue()).watch_duration(((Long)item.get("watch_duration")).longValue()).level_of_focus_before(0.0f).level_of_focus_after(0.0f).mood_update_id_before(0L).mood_update_id_after(0L).build()).collect(Collectors.toList());
        return activityDTOList;
    }
}

