/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.wrapper.AccountDataWrapper;
import com.infinite.focus.server.admin.entity.Admin;
import com.infinite.focus.server.admin.repository.AdminRepository;
import com.infinite.focus.server.admin.service.AdminService;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByStudentIdRequest;
import com.infinite.focus.server.assessment.service.AssessmentService;
import com.infinite.focus.server.auth.response.ValidationResponse;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.auth.service.ValidationService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.client.AskForHelpClient;
import com.infinite.focus.server.client.SOSQuestionClient;
import com.infinite.focus.server.client.SOSTimeClient;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.instructorsurveychoice.service.InstructorSurveyChoiceService;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.largeorganizationsurveychoice.service.LargeOrganizationSurveyChoiceService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationsurveychoice.service.OrganizationSurveyChoiceService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestService;
import com.infinite.focus.server.sosquestion.request.GetActiveQuestionsCount;
import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import com.infinite.focus.server.sostime.request.GetSOSTimeForSchoolRequest;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.studentpushnotification.service.StudentPushNotificationService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.youthsurveychoice.service.YouthSurveyChoiceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AuthServiceImpl
implements AuthService {
    private final MessageService messageService;
    private final AdminService adminService;
    private final ValidationService validationService;
    private final JwtHelper jwtHelper;
    private final SocioEmotionalTestService socioEmotionalTestService;
    private final AssessmentService assessmentService;
    private final AccountRepository accountRepository;
    private final AdminRepository adminRepository;
    private final InstructorService instructorService;
    private final StudentRepository studentRepository;
    private final DistrictService districtService;
    private final SchoolService schoolService;
    private final CorporateService corporateService;
    private final ParentService parentService;
    private final CleverDataService cleverDataService;
    private final YouthSurveyChoiceService youthSurveyChoiceService;
    private final InstructorSurveyChoiceService instructorSurveyChoiceService;
    private final OrganizationSurveyChoiceService organizationSurveyChoiceService;
    private final LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService;
    private final StudentPushNotificationService studentPushNotificationService;
    private final SOSQuestionClient sosQuestionClient;
    private final SOSTimeClient sosTimeClient;
    private final AskForHelpClient askForHelpClient;
    private final int INSTRUCTOR = 2;
    private final int STUDENT = 1;
    private final int ADMIN = 3;
    private final int SCHOOL = 4;
    private final int DISTRICT = 5;
    private final int CORPORATE = 6;
    private final int PARENT = 7;

    public AuthServiceImpl(MessageService messageService, AdminService adminService, ValidationService validationService, JwtHelper jwtHelper, SocioEmotionalTestService socioEmotionalTestService, AssessmentService assessmentService, AccountRepository accountRepository, AdminRepository adminRepository, InstructorService instructorService, StudentRepository studentRepository, DistrictService districtService, SchoolService schoolService, CorporateService corporateService, ParentService parentService, CleverDataService cleverDataService, YouthSurveyChoiceService youthSurveyChoiceService, InstructorSurveyChoiceService instructorSurveyChoiceService, OrganizationSurveyChoiceService organizationSurveyChoiceService, LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService, StudentPushNotificationService studentPushNotificationService, SOSQuestionClient sosQuestionClient, SOSTimeClient sosTimeClient, AskForHelpClient askForHelpClient) {
        this.messageService = messageService;
        this.adminService = adminService;
        this.validationService = validationService;
        this.jwtHelper = jwtHelper;
        this.socioEmotionalTestService = socioEmotionalTestService;
        this.assessmentService = assessmentService;
        this.accountRepository = accountRepository;
        this.adminRepository = adminRepository;
        this.instructorService = instructorService;
        this.studentRepository = studentRepository;
        this.districtService = districtService;
        this.schoolService = schoolService;
        this.corporateService = corporateService;
        this.parentService = parentService;
        this.cleverDataService = cleverDataService;
        this.youthSurveyChoiceService = youthSurveyChoiceService;
        this.instructorSurveyChoiceService = instructorSurveyChoiceService;
        this.organizationSurveyChoiceService = organizationSurveyChoiceService;
        this.largeOrganizationSurveyChoiceService = largeOrganizationSurveyChoiceService;
        this.studentPushNotificationService = studentPushNotificationService;
        this.sosQuestionClient = sosQuestionClient;
        this.sosTimeClient = sosTimeClient;
        this.askForHelpClient = askForHelpClient;
    }

    public Account getAccountByToken(String token) {
        if (token != null && !token.contains("undefined")) {
            String user = this.jwtHelper.extractUsername(token);
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.not.found"));
                }
                return a;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.not.found"));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    public boolean isAuthenticated(String token) {
        Account a = this.getAccountByToken(token);
        if (a != null) {
            return true;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.not.found"));
    }

    public boolean isAdmin(String token) {
        Admin ad;
        Account a = this.getAccountByToken(token);
        if (a != null && (ad = this.adminRepository.findByUserName(a.getUsername())) != null) {
            return true;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.is.not.admin"));
    }

    public Corporate isCorporate(String token) {
        Corporate c;
        Account a = this.getAccountByToken(token);
        if (a != null && (c = this.corporateService.getCorporateByAccountId(a.getAccount_id())) != null) {
            return c;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.is.not.corporate"));
    }

    public District isDistrict(String token) {
        District d;
        Account a = this.getAccountByToken(token);
        if (a != null && (d = this.districtService.getDistrictByAccountId(a.getAccount_id())) != null) {
            return d;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.is.not.district"));
    }

    public List<School> isSchool(String token) {
        List s;
        Account a = this.getAccountByToken(token);
        if (a != null && !AppUtils.isNullOrEmpty((List)(s = this.schoolService.getSchoolByAccountId(a.getAccount_id())))) {
            return s;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.is.not.school"));
    }

    public Instructor isInstructor(String token) {
        Instructor i;
        Account a = this.getAccountByToken(token);
        if (a != null && (i = this.instructorService.getInstructorByAccountId(a.getAccount_id())) != null) {
            return i;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.is.not.instructor"));
    }

    public Student isStudent(String token) {
        Account a = this.getAccountByToken(token);
        Student student = this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
        if (student == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.user.is.not.a.student"));
        }
        return student;
    }

    public Parent isParent(String token) {
        Parent p;
        Account a = this.getAccountByToken(token);
        if (a != null && (p = this.parentService.getParentByAccountId(a.getAccount_id())) != null) {
            return p;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.is.not.parent"));
    }

    public Admin getAdmin(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a != null) {
                return this.adminRepository.findByUserName(a.getUsername());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public AccountDataWrapper getInstructorAccountLoginDataForClever(Instructor instructor) {
        if (instructor != null) {
            instructor.setLanguage(Language.getLanguage());
            this.instructorService.save(instructor);
            ValidationResponse validationResponse = this.validationService.isValidInstructor(instructor.getInstructor_id());
            if (!validationResponse.isValid()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setI(instructor);
            adw.setType(2);
            adw.setSubscriptionActive(true);
            adw.setSurveyWrappers(this.instructorSurveyChoiceService.getSurveyWrappersForInstructor(instructor.getInstructor_id()));
            School school = this.schoolService.getSchoolById(instructor.getSchool_id());
            if (school != null) {
                adw.setEnable_journal(school.isEnable_journal());
                adw.setEnable_wow(school.isEnable_wow());
                adw.setEnable_auto_approve_wall_posts(school.isAuto_approve_wall_posts());
            }
            return adw;
        }
        return null;
    }

    public AccountDataWrapper getStudentAccountLoginDataForClever(Student student) {
        if (student != null) {
            if (AppUtils.isNullOrEmpty((String)student.getAccount().getUsername()) && AppUtils.isNullOrEmpty((String)student.getClever_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("please.complete.your.profile.using.first.login.option"));
            }
            ValidationResponse validationResponse = this.validationService.isValidStudent(student.getStudent_id());
            if (!validationResponse.isValid() && AppUtils.isNullOrEmpty((String)student.getClever_id())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            try {
                this.studentPushNotificationService.wowPostNotification(student.getStudent_id(), student.getAccount_id(), student.getLanguage());
                student.setNew_notificaitons(this.studentPushNotificationService.isThereNewNotificationAvailable(student.getStudent_id()));
                this.studentRepository.save((Object)student);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.socioEmotionalTestService.is30DaysPassedToLastSocioEmotionalTest(student);
            student.setIsVerified(true);
            if (student.isDemo()) {
                student.setShould_force_socio_emotional_assessment(true);
                student.setShould_auto_show_assessment(false);
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setStd(student.getStandard());
            adw.setS(student);
            adw.setType(1);
            adw.setSubscriptionActive(true);
            this.assessmentService.setAssessmentForToday(adw);
            adw.setSurveyWrappers(this.youthSurveyChoiceService.getSurveyWrappersForStudent(student.getStudent_id()));
            adw.setAsk_for_help(this.askForHelpClient.getPendingAskForHelpByStudentId(GetAskForHelpByStudentIdRequest.builder().student_id(student.getStudent_id()).build()));
            if (student.getSchool() != null) {
                GetActiveQuestionsCount activeQuestionsCount = this.sosQuestionClient.getActiveQuestionsCount();
                SOSTimeDTO sosTimeDTO = this.sosTimeClient.getForSchool(GetSOSTimeForSchoolRequest.builder().school_id(Long.valueOf(student.getSchool().getSchool_id())).build());
                adw.setShow_ask_for_help(activeQuestionsCount != null && activeQuestionsCount.getActive_questions_count() > 0L && sosTimeDTO != null && sosTimeDTO.getFrom_time().before(new Date()) && sosTimeDTO.getTo_time().after(new Date()));
                adw.setEnable_journal(student.getSchool().isEnable_journal());
                adw.setEnable_wow(student.getSchool().isEnable_wow());
            } else {
                adw.setShow_ask_for_help(false);
                adw.setEnable_journal(true);
                adw.setEnable_wow(true);
            }
            return adw;
        }
        return null;
    }

    public Corporate getCorporateByToken(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a != null) {
                return this.corporateService.getCorporateByAccountId(a.getAccount_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public District getDistrictByToken(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a != null) {
                return this.districtService.getDistrictByAccountId(a.getAccount_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<School> getSchoolByToken(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a != null) {
                return this.schoolService.getSchoolByAccountId(a.getAccount_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Instructor getInstructorByToken(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a != null) {
                return this.instructorService.getInstructorByAccountId(a.getAccount_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Student getStudentByToken(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a == null) {
                return null;
            }
            return this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Parent getParentByToken(String token) {
        try {
            Account a = this.getAccountByToken(token);
            if (a != null) {
                return this.parentService.getParentByAccountId(a.getAccount_id());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public AccountDataWrapper getAdminAccountLoginData(String token) {
        Account account = this.getAccountByToken(token);
        Admin ad = this.adminService.getAdminByUsername(account.getUsername());
        if (ad != null) {
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setType(3);
            Instructor i = this.instructorService.getInstructorByAccountId(account.getAccount_id());
            if (i != null) {
                i.setLanguage(Language.getLanguage());
                this.instructorService.save(i);
                adw.setI(i);
            }
            return adw;
        }
        return null;
    }

    public AccountDataWrapper getInstructorAccountLoginData(String token) {
        Instructor i = this.getInstructorByToken(token);
        if (i != null) {
            ValidationResponse validationResponse;
            i.setLanguage(Language.getLanguage());
            this.instructorService.save(i);
            if (!AppUtils.isNullOrEmpty((String)i.getClever_id())) {
                i = this.cleverDataService.syncInstructor(i);
            }
            if (!(validationResponse = this.validationService.isValidInstructor(i.getInstructor_id())).isValid()) {
                if (i.isArchived()) {
                    return null;
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setI(i);
            adw.setType(2);
            adw.setSubscriptionActive(true);
            School school = this.schoolService.getSchoolById(i.getSchool_id());
            if (school != null) {
                adw.setEnable_journal(school.isEnable_journal());
                adw.setEnable_wow(school.isEnable_wow());
                adw.setShould_update_clever_id(!AppUtils.isNullOrEmpty((String)school.getClever_id()));
                adw.setEnable_auto_approve_wall_posts(school.isAuto_approve_wall_posts());
            }
            adw.setSurveyWrappers(this.instructorSurveyChoiceService.getSurveyWrappersForInstructor(i.getInstructor_id()));
            return adw;
        }
        return null;
    }

    public AccountDataWrapper getStudentAccountLoginData(String token) {
        Student student = this.getStudentByToken(token);
        if (student != null) {
            try {
                this.studentPushNotificationService.wowPostNotification(student.getStudent_id(), student.getAccount_id(), student.getLanguage());
                student.setNew_notificaitons(this.studentPushNotificationService.isThereNewNotificationAvailable(student.getStudent_id()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            student.setLanguage(Language.getLanguage());
            this.studentRepository.save((Object)student);
            if (!(AppUtils.isNullOrEmpty((String)student.getClever_id()) || (student = this.cleverDataService.syncStudent(student)) != null && student.getSchool() != null)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("unable.to.access.clymb.right.now.please.try.after.some.time"));
            }
            if (AppUtils.isNullOrEmpty((String)student.getAccount().getUsername())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("please.complete.your.profile.using.first.login.option"));
            }
            ValidationResponse validationResponse = this.validationService.isValidStudent(student.getStudent_id());
            if (validationResponse.isValid()) {
                ValidationResponse validationResponse1 = this.validationService.isOverToNoOfYouthLimit(student);
                if (!validationResponse1.isValid()) {
                    validationResponse.setValid(validationResponse1.isValid());
                    validationResponse.setMessage(validationResponse1.getMessage());
                } else {
                    validationResponse.setFromCorporate(validationResponse1.isFromCorporate());
                    validationResponse.setFromDistrict(validationResponse1.isFromDistrict());
                    validationResponse.setFromSchool(validationResponse1.isFromSchool());
                }
            }
            if (!validationResponse.isValid() && (AppUtils.isNullOrEmpty((String)student.getClever_id()) || student.getInstructor() != null)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            this.socioEmotionalTestService.is30DaysPassedToLastSocioEmotionalTest(student);
            student.setIsVerified(true);
            if (student.isDemo()) {
                student.setShould_force_socio_emotional_assessment(true);
                student.setShould_auto_show_assessment(false);
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setStd(student.getStandard());
            adw.setS(student);
            adw.setType(1);
            adw.setSubscriptionActive(true);
            this.assessmentService.setAssessmentForToday(adw);
            if (student.getSchool() != null) {
                adw.setEnable_journal(student.getSchool().isEnable_journal());
                adw.setEnable_wow(student.getSchool().isEnable_wow());
                adw.setShould_update_clever_id(!AppUtils.isNullOrEmpty((String)student.getSchool().getClever_id()));
            } else {
                adw.setEnable_journal(true);
                adw.setEnable_wow(true);
            }
            adw.setSurveyWrappers(this.youthSurveyChoiceService.getSurveyWrappersForStudent(student.getStudent_id()));
            adw.setAsk_for_help(this.askForHelpClient.getPendingAskForHelpByStudentId(GetAskForHelpByStudentIdRequest.builder().student_id(student.getStudent_id()).build()));
            if (student.getSchool() != null) {
                GetActiveQuestionsCount activeQuestionsCount = this.sosQuestionClient.getActiveQuestionsCount();
                SOSTimeDTO sosTimeDTO = this.sosTimeClient.getForSchool(GetSOSTimeForSchoolRequest.builder().school_id(Long.valueOf(student.getSchool().getSchool_id())).build());
                adw.setShow_ask_for_help(activeQuestionsCount != null && activeQuestionsCount.getActive_questions_count() > 0L && sosTimeDTO != null && sosTimeDTO.getFrom_time().before(new Date()) && sosTimeDTO.getTo_time().after(new Date()));
            } else {
                adw.setShow_ask_for_help(false);
            }
            return adw;
        }
        return null;
    }

    public List<AccountDataWrapper> getSchoolAccountLoginData(String token) {
        ArrayList<AccountDataWrapper> accountDataWrappers = new ArrayList<AccountDataWrapper>();
        List schools = this.getSchoolByToken(token);
        ArrayList<String> errors = new ArrayList<String>();
        for (School school : schools) {
            school.setLanguage(Language.getLanguage());
            this.schoolService.save(school);
            ValidationResponse validationResponse = this.validationService.isValidSchool(school.getSchool_id());
            if (!validationResponse.isFromSchool() && (!validationResponse.isValid() || validationResponse.isDeleted() || !validationResponse.isActive()) || !validationResponse.isValid() && validationResponse.isDeleted()) {
                errors.add(validationResponse.getMessage());
                continue;
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setSubscriptionActive(validationResponse.isSubscriptionActive());
            Account account = this.accountRepository.findByAccountId(school.getAccount_id());
            if (account != null) {
                school.setUsername(account.getUsername());
            }
            adw.setSchool(school);
            adw.setType(4);
            District district = this.districtService.getDistrictById(school.getDistrict_id());
            adw.setShould_update_clever_id(district != null && !AppUtils.isNullOrEmpty((String)district.getClever_id()));
            adw.setSurveyWrappers(this.organizationSurveyChoiceService.getSurveyWrappersForOrganization(school.getSchool_id()));
            accountDataWrappers.add(adw);
        }
        if (accountDataWrappers.isEmpty() && !errors.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, String.join((CharSequence)",", errors));
        }
        return accountDataWrappers;
    }

    public AccountDataWrapper getDistrictAccountLoginData(String token) {
        District district = this.getDistrictByToken(token);
        if (district != null) {
            district.setLanguage(Language.getLanguage());
            this.districtService.save(district);
            ValidationResponse validationResponse = this.validationService.isValidDistrict(district.getDistrict_id());
            if (validationResponse.isDeleted()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setSubscriptionActive(validationResponse.isSubscriptionActive());
            Account account = this.accountRepository.findByAccountId(district.getAccount_id());
            if (account != null) {
                district.setUsername(account.getUsername());
            }
            adw.setDistrict(district);
            adw.setType(5);
            adw.setSurveyWrappers(this.largeOrganizationSurveyChoiceService.getSurveyWrappersForLargeOrganization(district.getDistrict_id()));
            return adw;
        }
        return null;
    }

    public AccountDataWrapper getParentAccountLoginData(String token) {
        Parent parent = this.getParentByToken(token);
        if (parent != null) {
            parent.setLanguage(Language.getLanguage());
            this.parentService.save(parent);
            ValidationResponse validationResponse = this.validationService.isValidParent(parent.getParent_id());
            if (!validationResponse.isValid()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            Corporate corporate = this.corporateService.getCorporateById(parent.getCorporate_id());
            if (corporate != null) {
                parent.setCorporate_image(corporate.getCorporate_image());
                parent.setCorporate_image_2(corporate.getCorporate_image_2());
                parent.setCorporate_name(corporate.getCorporate_name());
            }
            adw.setParent(parent);
            adw.setType(7);
            adw.setSubscriptionActive(true);
            School school = this.schoolService.getSchoolById(parent.getSchool_id());
            if (school != null) {
                adw.setEnable_journal(school.isEnable_journal());
                adw.setEnable_wow(school.isEnable_wow());
                adw.setShould_update_clever_id(!AppUtils.isNullOrEmpty((String)school.getClever_id()));
                adw.setEnable_auto_approve_wall_posts(school.isAuto_approve_wall_posts());
            }
            return adw;
        }
        return null;
    }

    public AccountDataWrapper getCorporateAccountLoginData(String token) {
        Corporate corporate = this.getCorporateByToken(token);
        if (corporate != null) {
            corporate.setLanguage(Language.getLanguage());
            this.corporateService.save(corporate);
            ValidationResponse validationResponse = this.validationService.isValidCorporate(corporate.getCorporate_id());
            if (validationResponse.isDeleted()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, validationResponse.getMessage());
            }
            AccountDataWrapper adw = new AccountDataWrapper();
            adw.setSubscriptionActive(validationResponse.isSubscriptionActive());
            adw.setCorporate(corporate);
            adw.setType(6);
            return adw;
        }
        return null;
    }
}

