/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.auth.service.CorporateAuthService;
import com.infinite.focus.server.auth.util.KeyGenerator;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.request.FreeTrialAccountRequest;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.utils.AppUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CorporateAuthServiceImpl
implements CorporateAuthService {
    @Autowired
    MessageService messageService;
    @Autowired
    CorporateService corporateService;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    ConfigurationService configurationService;

    public Corporate createCorporateTrialAccount(FreeTrialAccountRequest corporate, FocusOn focus_on) {
        if (AppUtils.isNullOrEmpty((String)corporate.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)corporate.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(corporate.getEmail());
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)corporate.getPassword()));
        account.setUsername(corporate.getEmail());
        account.setRole_in_organization(corporate.getRole_in_organization());
        a = (Account)this.accountRepository.save((Object)account);
        Corporate c = new Corporate();
        c.setCorporate_name(corporate.getName());
        c.setAddress(corporate.getAddress());
        c.setAccount(a);
        c.setActive(true);
        c.setNumber_of_youth((long)this.configurationService.getConfiguration().getFree_trial_number_of_youth());
        c.setFocus_on(focus_on);
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Corporate x = this.corporateService.getByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                c.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        c.setLanguage(Language.getLanguage());
        return this.corporateService.save(c);
    }
}

