/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.avatar.service;

import com.infinite.focus.server.avatar.dto.AvatarDTO;
import com.infinite.focus.server.avatar.entity.Avatar;
import com.infinite.focus.server.avatar.repository.AvatarCoreRepository;
import com.infinite.focus.server.avatar.repository.AvatarRepository;
import com.infinite.focus.server.avatar.service.AvatarService;
import com.infinite.focus.server.message.service.MessageService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AvatarServiceImpl
implements AvatarService {
    private final MessageService messageService;
    private final AvatarRepository avatarRepository;
    private final AvatarCoreRepository avatarCoreRepository;

    public AvatarServiceImpl(MessageService messageService, AvatarRepository avatarRepository, AvatarCoreRepository avatarCoreRepository) {
        this.messageService = messageService;
        this.avatarRepository = avatarRepository;
        this.avatarCoreRepository = avatarCoreRepository;
    }

    public Avatar getAvatarById(long avatar_id) {
        return this.avatarRepository.findByAvatarId(Long.valueOf(avatar_id));
    }

    public Avatar isValidAvatar(long avatar_id) {
        Avatar avatar = this.getAvatarById(avatar_id);
        if (avatar == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("avatar.is.not.found"));
        }
        return avatar;
    }

    public List<AvatarDTO> getAll() {
        return this.avatarCoreRepository.findAll();
    }

    public AvatarDTO getById(long avatar_id) {
        return this.avatarCoreRepository.findById(avatar_id);
    }
}

