/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.clever.service.instructor;

import com.infinite.focus.server.clever.model.CleverInstructor;
import com.infinite.focus.server.clever.model.CleverInstructorWrapper;
import com.infinite.focus.server.clever.model.CleverSection;
import com.infinite.focus.server.clever.model.CleverSectionWrapper;
import com.infinite.focus.server.clever.response.GetCleverInstructorsResponse;
import com.infinite.focus.server.clever.response.GetCleverSectionsResponse;
import com.infinite.focus.server.clever.response.GetInstructorByIdResponse;
import com.infinite.focus.server.clever.service.instructor.CleverInstructorApiService;
import com.infinite.focus.server.clever.service.instructor.CleverInstructorService;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class CleverInstructorServiceImpl
implements CleverInstructorService {
    private CleverInstructorApiService service;

    public CleverInstructorServiceImpl() {
        OkHttpClient OClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.clever.com/v3.0/").client(OClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (CleverInstructorApiService)retrofit.create(CleverInstructorApiService.class);
    }

    public CleverInstructor getCleverInstructorByCleverId(String access_token, String instructor_clever_id) {
        try {
            Call getInstructorByIdResponseCall = this.service.getCleverInstructorById("Bearer " + access_token, instructor_clever_id);
            Response response = getInstructorByIdResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetInstructorByIdResponse)response.body()).getData() != null) {
                return ((GetInstructorByIdResponse)response.body()).getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Set<CleverInstructor> getCleverInstructors(String access_token) {
        try {
            Call getCleverInstructorsResponseCall = this.service.getCleverInstructors("Bearer " + access_token, "teacher");
            Response response = getCleverInstructorsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverInstructorsResponse)response.body()).getData() != null) {
                return ((GetCleverInstructorsResponse)response.body()).getData().stream().map(CleverInstructorWrapper::getData).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedHashSet<CleverSection> getCleverSectionsByCleverInstructor(String access_token, String instructor_clever_id) {
        try {
            Call getCleverSectionsResponseCall = this.service.getCleverSectionsForCleverInstructor("Bearer " + access_token, instructor_clever_id);
            Response response = getCleverSectionsResponseCall.execute();
            if (response.isSuccessful() && response.body() != null && ((GetCleverSectionsResponse)response.body()).getData() != null) {
                return ((GetCleverSectionsResponse)response.body()).getData().stream().map(CleverSectionWrapper::getData).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

