/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.content.repository;

import com.infinite.focus.server.content.dto.ContentDTO;
import com.infinite.focus.server.content.repository.ContentRepository;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.streak.model.StreakType;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class ContentRepositoryImpl
implements ContentRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static ContentDTO mapRow(ResultSet rs, int i) throws SQLException {
        StreakType streakType = null;
        String streak_type = rs.getString("streak_type");
        if (!AppUtils.isNullOrEmpty((String)streak_type)) {
            streakType = StreakType.valueOf((String)streak_type);
        }
        return ContentDTO.builder().content_id(rs.getLong("content_id")).content_name(rs.getString("content_name")).content_name_es(rs.getString("content_name_es")).status(rs.getInt("status")).streak_type(streakType).createdAt((Date)rs.getTimestamp("created_at")).updatedAt((Date)rs.getTimestamp("updated_at")).build();
    }

    public ContentDTO create(String content_name, String content_name_es, int status) {
        String INSERT_SQL = "INSERT INTO content (content_name, content_name_es, status, created_at, updated_at) VALUES (?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO content (content_name, content_name_es, status, created_at, updated_at) VALUES (?,?,?,?,?)", 1);
            ps.setString(1, content_name);
            ps.setString(2, content_name_es);
            ps.setInt(3, status);
            ps.setTimestamp(4, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int content_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.findById((long)content_id);
    }

    public ContentDTO findById(long id) {
        String SQL = "SELECT * FROM content WHERE content_id = ?";
        try {
            return (ContentDTO)this.jdbcTemplate.queryForObject(SQL, ContentRepositoryImpl::mapRow, new Object[]{id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ContentDTO update(long content_id, String content_name, String content_name_es, int status) {
        String SQL = "UPDATE content SET content_name = ?, content_name_es = ?, status = ?, updated_at = ? WHERE content_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE content SET content_name = ?, content_name_es = ?, status = ?, updated_at = ? WHERE content_id = ? ", new Object[]{content_name, content_name_es, status, Timestamp.valueOf(LocalDateTime.now()), content_id});
        if (updateCount == 1) {
            return this.findById(content_id);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Not updated!!!");
    }

    public List<ContentDTO> findAll() {
        String SQL = "SELECT * FROM content ORDER BY content_id ASC";
        try {
            return this.jdbcTemplate.query(SQL, ContentRepositoryImpl::mapRow);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<ContentDTO>();
        }
    }

    public Page<ContentDTO> findPageByContentName(String content_name, Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM content WHERE CASE WHEN ? IS NOT NULL " + (Language.isSpanish() ? "THEN content_name_es LIKE '%" : "THEN content_name LIKE '%") + content_name + "%' ELSE true END ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, new Object[]{content_name}, (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM content WHERE CASE WHEN ? IS NOT NULL " + (Language.isSpanish() ? "THEN content_name_es LIKE '%" : "THEN content_name LIKE '%") + content_name + "%' ELSE true END ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), new Object[]{content_name}, ContentRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public void deleteById(long id) {
        String SQL = "DELETE FROM content WHERE content_id = ?";
        this.jdbcTemplate.update("DELETE FROM content WHERE content_id = ?", new Object[]{id});
    }

    public List<ContentDTO> findByIds(Set<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<ContentDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM content WHERE content_id IN(%s) ORDER BY content_id ASC";
        List contentDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), ContentRepositoryImpl::mapRow);
        return contentDTOS;
    }
}

