/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporate.repository;

import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.repository.CorporateCoreRepository;
import com.infinite.focus.server.corporate.request.GetCorporateRequest;
import com.infinite.focus.server.corporate.wrapper.ParentWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class CorporateCoreRepositoryImpl
implements CorporateCoreRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CorporateCoreRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<ParentWrapper> findParentsByCorporateId(long corporate_id, int pageNo, int pageSize, String sortBy, String orderBy) {
        String sql = "SELECT p.parent_id, p.first_name, p.last_name, a.username, COUNT(s.student_id) AS number_of_youth FROM parent p LEFT JOIN student s ON p.parent_id = s.parent_id LEFT JOIN account a ON p.account_id = a.account_id WHERE p.corporate_id = :corporate_id AND p.deleted = false GROUP BY p.parent_id, p.first_name, p.last_name, a.username ORDER BY " + sortBy + " " + orderBy + " LIMIT :limit OFFSET :offset";
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("corporate_id", corporate_id);
        params.put("limit", pageSize);
        params.put("offset", pageNo * pageSize);
        List resultSet = this.namedParameterJdbcTemplate.query(sql, params, (rs, rowNum) -> {
            ParentWrapper wrapper = new ParentWrapper();
            wrapper.setParent_id(rs.getLong("parent_id"));
            wrapper.setFirst_name(rs.getString("first_name"));
            wrapper.setLast_name(rs.getString("last_name"));
            wrapper.setNumber_of_youth(rs.getLong("number_of_youth"));
            wrapper.setEmail(rs.getString("username"));
            return wrapper;
        });
        String countSql = "SELECT COUNT(*) FROM parent p WHERE p.corporate_id = :corporate_id AND p.deleted = false";
        Long count = Optional.ofNullable((Long)this.namedParameterJdbcTemplate.queryForObject(countSql, params, Long.class)).orElse(0L);
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        return new PageImpl(resultSet, (Pageable)pageable, count.longValue());
    }

    public Page<Corporate> getActiveCorporates(GetCorporateRequest request) {
        StringBuilder sql = new StringBuilder("SELECT c.*, a.username FROM corporate c ");
        sql.append("LEFT JOIN account a ON c.account_id = a.account_id WHERE ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM corporate c ");
        countSql.append("LEFT JOIN account a ON c.account_id = a.account_id WHERE ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> conditions = new ArrayList<String>();
        if (AppUtils.isNotNullOrEmpty((String)request.getCorporate_name())) {
            conditions.add("LOWER(c.corporate_name) LIKE :corporate_name");
            params.put("corporate_name", "%" + request.getCorporate_name().toLowerCase() + "%");
        }
        conditions.add("c.license_key IS NOT NULL");
        conditions.add("c.license_key <> ''");
        conditions.add("c.licence_key_expiry_date >= :current_date");
        params.put("current_date", new Date());
        conditions.add("c.active = :active");
        params.put("active", true);
        conditions.add("c.deleted = :deleted");
        params.put("deleted", false);
        if (request.getFromDate() != null && request.getToDate() != null) {
            conditions.add("c.licence_key_added_date BETWEEN :from_date AND :to_date");
            params.put("from_date", request.getFromDate());
            params.put("to_date", request.getToDate());
        }
        String whereClause = String.join((CharSequence)" AND ", conditions);
        sql.append(whereClause);
        countSql.append(whereClause);
        if ("desc".equals(request.getOrderBy())) {
            sql.append(" ORDER BY c.").append(request.getSortBy()).append(" DESC");
        } else {
            sql.append(" ORDER BY c.").append(request.getSortBy()).append(" ASC");
        }
        sql.append(" LIMIT :limit OFFSET :offset");
        params.put("limit", request.getPageSize());
        params.put("offset", request.getPageNo() * request.getPageSize());
        List result = this.namedParameterJdbcTemplate.query(sql.toString(), params, (RowMapper)new BeanPropertyRowMapper(Corporate.class));
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), params, Long.class);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)("desc".equals(request.getOrderBy()) ? Sort.by((String[])new String[]{request.getSortBy()}).descending() : Sort.by((String[])new String[]{request.getSortBy()}).ascending()));
        return new PageImpl(result, (Pageable)pageable, count.longValue());
    }

    public Page<Corporate> getInactiveCorporates(GetCorporateRequest request) {
        if (request.isMoreThan30Days()) {
            request.setFromDate(DateUtils.subtractDaysInDate((Date)request.getFromDate(), (int)30));
            request.setToDate(DateUtils.subtractDaysInDate((Date)request.getToDate(), (int)30));
        }
        StringBuilder sql = new StringBuilder("SELECT c.*, a.username FROM corporate c ");
        sql.append("LEFT JOIN account a ON c.account_id = a.account_id WHERE ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM corporate c ");
        countSql.append("LEFT JOIN account a ON c.account_id = a.account_id WHERE ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> predicate = new ArrayList<String>();
        ArrayList<String> predicate2 = new ArrayList<String>();
        ArrayList<String> predicate3 = new ArrayList<String>();
        if (AppUtils.isNotNullOrEmpty((String)request.getCorporate_name())) {
            String condition = "LOWER(c.corporate_name) LIKE :corporate_name";
            predicate.add(condition);
            predicate2.add(condition);
            predicate3.add(condition);
            params.put("corporate_name", "%" + request.getCorporate_name().toLowerCase() + "%");
        }
        predicate.add("c.license_key IS NOT NULL");
        predicate.add("c.license_key <> ''");
        predicate.add("c.licence_key_expiry_date <= :current_date");
        predicate.add("c.active = true");
        predicate.add("c.deleted = false");
        predicate2.add("c.license_key IS NOT NULL");
        predicate2.add("c.license_key <> ''");
        predicate2.add("c.licence_key_expiry_date <= :current_date");
        predicate2.add("c.active = false");
        predicate2.add("c.deleted = false");
        predicate3.add("c.license_key IS NOT NULL");
        predicate3.add("c.license_key <> ''");
        predicate3.add("c.licence_key_expiry_date >= :current_date");
        predicate3.add("c.active = false");
        predicate3.add("c.deleted = false");
        params.put("current_date", new Date());
        if (request.getFromDate() != null && request.getToDate() != null) {
            String dateCondition = "c.licence_key_expiry_date BETWEEN :from_date AND :to_date";
            predicate.add(dateCondition);
            predicate2.add(dateCondition);
            predicate3.add(dateCondition);
            params.put("from_date", request.getFromDate());
            params.put("to_date", request.getToDate());
        }
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        conditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", predicate) + ")")));
        conditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", predicate2) + ")")));
        conditions.add((CallSite)((Object)("(" + String.join((CharSequence)" AND ", predicate3) + ")")));
        sql.append(String.join((CharSequence)" OR ", conditions));
        countSql.append(String.join((CharSequence)" OR ", conditions));
        String sortBy = request.getSortBy();
        String orderBy = request.getOrderBy().equals("desc") ? "DESC" : "ASC";
        sql.append(" ORDER BY ").append(sortBy).append(" ").append(orderBy);
        PageRequest pageable = PageRequest.of((int)request.getPageNo(), (int)request.getPageSize(), (Sort)(request.getOrderBy().equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        sql.append(" LIMIT :limit OFFSET :offset");
        params.put("limit", pageable.getPageSize());
        params.put("offset", pageable.getOffset());
        List result = this.namedParameterJdbcTemplate.query(sql.toString(), params, (RowMapper)new BeanPropertyRowMapper(Corporate.class));
        Long count = (Long)this.namedParameterJdbcTemplate.queryForObject(countSql.toString(), params, Long.class);
        return new PageImpl(result, (Pageable)pageable, count.longValue());
    }
}

