/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporate.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.client.MoodUpdateClient;
import com.infinite.focus.server.client.NotificationClient;
import com.infinite.focus.server.client.OrganizationAdminClient;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.repository.CorporateCoreRepository;
import com.infinite.focus.server.corporate.repository.CorporateRepository;
import com.infinite.focus.server.corporate.request.CorporateDataApiRequest;
import com.infinite.focus.server.corporate.request.GetCorporateRequest;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.corporate.wrapper.LeaderboardWrapper;
import com.infinite.focus.server.corporate.wrapper.ParentWrapper;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.data.model.SubMoodByStandardOccurrence;
import com.infinite.focus.server.data.service.DataServiceImpl;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.moodupdate.request.GetSelfAwarenessByStudentIdsRequest;
import com.infinite.focus.server.notification.model.AccountIdAndLanguage;
import com.infinite.focus.server.notification.request.CorporateNotification;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.request.GetByOrganizationTypeAndAccountIdRequest;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.parent.repository.ParentCoreRepository;
import com.infinite.focus.server.parent.request.TheDailyClymbRequest;
import com.infinite.focus.server.parent.response.TheDailyClymbResponse;
import com.infinite.focus.server.parent.service.ParentService;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.repository.StudentRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CorporateServiceImpl
implements CorporateService {
    private final CorporateRepository corporateRepository;
    private final StudentRepository studentRepository;
    private final CorporateCoreRepository corporateCoreRepository;
    private final FreeTrialService freeTrialService;
    private final ParentService parentService;
    private final ParentCoreRepository parentCoreRepository;
    private final AccountService accountService;
    private final MessageService messageService;
    private final OrganizationAdminClient organizationAdminClient;
    private final MoodUpdateClient moodUpdateClient;
    private final NotificationClient notificationClient;

    public CorporateServiceImpl(CorporateRepository corporateRepository, StudentRepository studentRepository, CorporateCoreRepository corporateCoreRepository, FreeTrialService freeTrialService, ParentService parentService, ParentCoreRepository parentCoreRepository, AccountService accountService, MessageService messageService, OrganizationAdminClient organizationAdminClient, MoodUpdateClient moodUpdateClient, NotificationClient notificationClient) {
        this.corporateRepository = corporateRepository;
        this.studentRepository = studentRepository;
        this.corporateCoreRepository = corporateCoreRepository;
        this.freeTrialService = freeTrialService;
        this.parentService = parentService;
        this.parentCoreRepository = parentCoreRepository;
        this.accountService = accountService;
        this.messageService = messageService;
        this.organizationAdminClient = organizationAdminClient;
        this.moodUpdateClient = moodUpdateClient;
        this.notificationClient = notificationClient;
    }

    public Corporate getByRegistrationCode(String registration_code) {
        return this.corporateRepository.findByRegistrationCode(registration_code);
    }

    public Corporate save(Corporate corporate) {
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate findByAccountId(long account_id) {
        List organizationAdmins;
        Corporate corporate = this.corporateRepository.findByAccountId(account_id);
        if (corporate == null && !AppUtils.isNullOrEmpty((List)(organizationAdmins = this.organizationAdminClient.getByOrganizationTypeAndAccountId(GetByOrganizationTypeAndAccountIdRequest.builder().organization_type(OrganizationType.CORPORATE.toString()).account_id(account_id).build())))) {
            OrganizationAdmin organizationAdmin = (OrganizationAdmin)organizationAdmins.get(0);
            corporate = this.corporateRepository.findByCorporateId(organizationAdmin.getOrganization_id());
            corporate.setOrganizationAdmin(organizationAdmin);
        }
        return corporate;
    }

    public boolean isDeletedCorporate(long corporate_id) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        return corporate.isDeleted();
    }

    public Corporate getCorporateById(long corporate_id) {
        return this.corporateRepository.findByCorporateId(corporate_id);
    }

    public boolean isActiveCorporate(long corporate_id) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (corporate.getLicence_key_expiry_date() != null && DateUtils.checkDateTimeIsPassed((Date)corporate.getLicence_key_expiry_date())) {
            corporate = this.activeDeactiveCorporate(corporate.getCorporate_id(), false);
        }
        return corporate.isActive();
    }

    public Corporate activeDeactiveCorporate(long corporate_id, boolean active) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setActive(active);
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate getCorporateByAccountId(long account_id) {
        return this.findByAccountId(account_id);
    }

    public Date getRenewalDate(long corporate_id) {
        Corporate corporate = this.getCorporateById(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (AppUtils.isNotNullOrEmpty((String)corporate.getLicense_key())) {
            return corporate.getLicence_key_expiry_date();
        }
        return this.freeTrialService.getFreeTrialByCorporateId(corporate.getCorporate_id()).getTrial_end_date();
    }

    public Corporate updateNumberOfYouthByCorporateId(long corporate_id, long number_of_youth) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setNumber_of_youth(number_of_youth);
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate renewSubscriptionByCorporateId(long corporate_id) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        corporate.setActive(true);
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public void addLicenseKey(Invoice invoice) {
        Corporate corporate = this.getCorporateById(invoice.getOrganization_id());
        corporate.setLicense_key(invoice.getLicense_key());
        corporate.setLicence_key_added_date(new Date());
        corporate.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        corporate.setActive(true);
        if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            corporate.setNumber_of_youth(invoice.getNumber_of_youth());
        }
        this.corporateRepository.save((Object)corporate);
        FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.CORPORATE.toString(), corporate.getCorporate_id());
        if (freeTrial != null) {
            this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
        }
    }

    public void updateSubscription(Invoice invoice) {
        if (!AppUtils.isNullOrEmpty((String)invoice.getLicense_key())) {
            this.addLicenseKey(invoice);
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            this.updateNumberOfYouthByCorporateId(invoice.getOrganization_id(), invoice.getNumber_of_youth());
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.RENEW_SUBSCRIPTION)) {
            this.renewSubscriptionByCorporateId(invoice.getOrganization_id());
        }
    }

    public Object happinessAltitude(Corporate corporate, CorporateDataApiRequest request) {
        request.setStudentIds(this.corporateRepository.findStudentIdsByCorporateId(corporate.getCorporate_id()));
        if (request.isFrom_mobile()) {
            return this.parentService.filterHappinessAltitudeMoods(this.parentService.getMoodCountAndPercentage(request.getStudentIds(), request.getFromDate(), request.getToDate(), false, false, corporate.getLanguage()), corporate.getLanguage());
        }
        SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
        EmotionsByStandards emotionCountAndAverages = this.moodUpdateClient.getSelfAwarenessByStudentIds2(GetSelfAwarenessByStudentIdsRequest.builder().student_ids(new HashSet(request.getStudentIds())).fromDate(request.getFromDate()).toDate(request.getToDate()).build());
        subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_k_2()));
        subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_3_5()));
        subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_6_12()));
        return this.parentService.filterHappinessAltitudeMoods(subMoodByStandardOccurrence);
    }

    public List<Student> getStudentsByCorporateId(long corporate_id) {
        ArrayList<Student> students = new ArrayList<Student>();
        List studentIds = this.corporateRepository.findStudentIdsByCorporateId(corporate_id);
        if (!AppUtils.isNullOrEmpty((List)studentIds)) {
            List byStudentIds = this.studentRepository.findByStudentIdIn(studentIds);
            students.addAll(byStudentIds);
        }
        return students;
    }

    public TheDailyClymbResponse theDailyClymb(Corporate corporate, TheDailyClymbRequest request) {
        List studentIds = this.corporateRepository.findStudentIdsByCorporateId(corporate.getCorporate_id());
        TheDailyClymbResponse response = new TheDailyClymbResponse();
        response.setTodaysClymbers(this.parentService.todaysClymbers(studentIds, request.getToday()));
        response.setTotalClymbers((long)studentIds.size());
        response.setAverageClymbDuration(DateUtils.getMinutesAndSecondInString((long)this.parentService.averageClymbDuration(studentIds, request.getToday())));
        response.setTotalHappinessAltitude(this.parentService.totalHappinessAltitude(studentIds, request.getToday(), corporate.getLanguage()));
        response.setHalfOfTheClymbersHaveReachedHappinessAltitude(this.parentService.halfOfTheClymbersHaveReachedHappinessAltitude(studentIds, request.getToday(), corporate.getLanguage()));
        return response;
    }

    public Object comprehensiveReport(Corporate corporate, CorporateDataApiRequest request) {
        request.setStudentIds(this.corporateRepository.findStudentIdsByCorporateId(corporate.getCorporate_id()));
        SubMoodByStandardOccurrence subMoodByStandardOccurrence = new SubMoodByStandardOccurrence();
        EmotionsByStandards emotionCountAndAverages = this.moodUpdateClient.getSelfAwarenessByStudentIds2(GetSelfAwarenessByStudentIdsRequest.builder().student_ids(new HashSet(request.getStudentIds())).fromDate(request.getFromDate()).toDate(request.getToDate()).build());
        subMoodByStandardOccurrence.set_k_2(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_k_2()));
        subMoodByStandardOccurrence.set_3_5(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_3_5()));
        subMoodByStandardOccurrence.set_6_12(DataServiceImpl.setSubMoodOccurrence((long)request.getStudentIds().size(), (List)emotionCountAndAverages.get_6_12()));
        return subMoodByStandardOccurrence;
    }

    public Page<ParentWrapper> getParentsByCorporateId(long corporate_id, int pageNo, int pageSize, String sortBy, String orderBy) {
        return this.corporateCoreRepository.findParentsByCorporateId(corporate_id, pageNo, pageSize, sortBy, orderBy);
    }

    public LinkedList<LeaderboardWrapper> leaderboard(long corporate_id, Date fromDate, Date toDate) {
        LinkedList leaderboardWrappers = new LinkedList();
        List parentCoreDTOS = this.parentCoreRepository.findByCorporateId(corporate_id);
        parentCoreDTOS.forEach(parent -> {
            LeaderboardWrapper wrapper = new LeaderboardWrapper();
            wrapper.setParent_id(parent.getParent_id());
            wrapper.setFull_name(parent.getFirst_name() + " " + parent.getLast_name());
            List studentIds = this.parentCoreRepository.findStudentIdsByParentId(parent.getParent_id());
            if (!AppUtils.isNullOrEmpty((List)studentIds)) {
                long time = this.parentService.averageClymbDuration(studentIds, fromDate, toDate);
                wrapper.setHousehold_average_in_mins(DateUtils.getMinutesAndSecondInString((long)time));
                wrapper.setHousehold_average(time);
            } else {
                wrapper.setHousehold_average_in_mins(DateUtils.getMinutesAndSecondInString((long)0L));
                wrapper.setHousehold_average(0L);
            }
            leaderboardWrappers.add(wrapper);
        });
        return leaderboardWrappers.stream().sorted((c1, c2) -> Long.compare(c2.getHousehold_average(), c1.getHousehold_average())).limit(25L).collect(Collectors.toCollection(LinkedList::new));
    }

    public void setCorporateNewNotifications(long corporate_id, boolean new_available) {
        try {
            Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
            corporate.setNew_notifications(new_available);
            this.corporateRepository.save((Object)corporate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Page<Corporate> getActiveCorporates(GetCorporateRequest request) {
        return this.corporateCoreRepository.getActiveCorporates(request);
    }

    public Page<Corporate> getInactiveCorporates(GetCorporateRequest request) {
        return this.corporateCoreRepository.getInactiveCorporates(request);
    }

    public List<Corporate> getCorporates() {
        return this.corporateRepository.getCorporates();
    }

    public long getStudentsCountByCorporateId(long corporate_id) {
        return this.corporateRepository.findCountOfStudentByCorporateId(corporate_id);
    }

    public Corporate deleteCorporate(long corporate_id, boolean deleted, boolean isFromFreeTrial) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        corporate.setDeleted(deleted);
        if (!isFromFreeTrial && AppUtils.isNullOrEmpty((String)corporate.getLicense_key())) {
            FreeTrial freeTrial = this.freeTrialService.deleteFreeTrial(corporate.getCorporate_id(), OrganizationType.CORPORATE, deleted);
        }
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public Corporate editCorporate(long corporate_id, String corporate_name, FocusOn focus_on, String email, String address, long number_of_youth, Date licence_key_expiry_date) {
        Corporate corporate = this.corporateRepository.findByCorporateId(corporate_id);
        if (corporate == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.corporate.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)corporate_name)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("corporate.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)address)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("address.is.null.or.empty"));
        }
        Account account = this.accountService.changeEmail(corporate.getAccount_id(), email);
        corporate.setCorporate_name(corporate_name);
        corporate.setFocus_on(focus_on);
        corporate.setAddress(address);
        corporate.setNumber_of_youth(number_of_youth);
        if (AppUtils.isNullOrEmpty((String)corporate.getLicense_key())) {
            this.freeTrialService.editFreeTrial(corporate.getCorporate_id(), OrganizationType.CORPORATE, corporate_name, focus_on, licence_key_expiry_date);
        } else {
            corporate.setLicence_key_expiry_date(licence_key_expiry_date);
        }
        return (Corporate)this.corporateRepository.save((Object)corporate);
    }

    public void sendNotificationToAllParents(String token, long corporate_id, String text, String text_es) {
        HashMap<Long, AccountIdAndLanguage> parent_ids_and_account_ids = new HashMap<Long, AccountIdAndLanguage>();
        for (Parent parent : this.parentService.getParentsCorporateId(corporate_id)) {
            parent_ids_and_account_ids.put(parent.getParent_id(), AccountIdAndLanguage.builder().account_id(parent.getAccount_id()).language(parent.getLanguage()).demo(false).build());
        }
        CorporateNotification corporateNotification = CorporateNotification.builder().parent_ids_and_account_ids(parent_ids_and_account_ids).text(text).text_es(text_es).build();
        this.notificationClient.corporateNotification(token, corporateNotification);
    }
}

