/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.corporatenotification.repository;

import com.infinite.focus.server.corporatenotification.entity.CorporateNotification;
import com.infinite.focus.server.corporatenotification.repository.CorporateNotificationCoreRepository;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CorporateNotificationCoreRepositoryImpl
implements CorporateNotificationCoreRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CorporateNotificationCoreRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<CorporateNotification> getCorporateNotificationsByCorporateId(Long corporate_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy, Date fromDate, Date toDate) {
        Object sql = "SELECT * FROM corporate_notification WHERE corporate_id = :corporate_id";
        Object countSql = "SELECT COUNT(*) FROM corporate_notification WHERE corporate_id = :corporate_id";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("corporate_id", (Object)corporate_id);
        if (fromDate != null && toDate != null) {
            sql = (String)sql + " AND created_at BETWEEN :fromDate AND :toDate";
            countSql = (String)countSql + " AND created_at BETWEEN :fromDate AND :toDate";
            parameters.addValue("fromDate", (Object)fromDate);
            parameters.addValue("toDate", (Object)toDate);
        }
        sql = (String)sql + " ORDER BY " + sortBy + " " + orderBy;
        sql = (String)sql + " LIMIT :limit OFFSET :offset";
        parameters.addValue("limit", (Object)pageSize);
        parameters.addValue("offset", (Object)(pageNo * pageSize));
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(CorporateNotification.class);
        List result = this.namedParameterJdbcTemplate.query((String)sql, (SqlParameterSource)parameters, (RowMapper)rowMapper);
        int count = (Integer)this.namedParameterJdbcTemplate.queryForObject((String)countSql, (SqlParameterSource)parameters, Integer.class);
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, (long)count);
        return pagedResult;
    }
}

