/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.cronjob;

import com.infinite.focus.server.instructorsurveychoice.service.InstructorSurveyChoiceService;
import com.infinite.focus.server.largeorganizationsurveychoice.service.LargeOrganizationSurveyChoiceService;
import com.infinite.focus.server.organizationsurveychoice.service.OrganizationSurveyChoiceService;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.repository.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.student.repository.StudentCoreRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.youthsurveychoice.service.YouthSurveyChoiceService;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cron-monitor"})
public class CronController {
    private final YouthSurveyChoiceService youthSurveyChoiceService;
    private final InstructorSurveyChoiceService instructorSurveyChoiceService;
    private final OrganizationSurveyChoiceService organizationSurveyChoiceService;
    private final LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService;
    private final StudentCoreRepository studentCoreRepository;
    private final SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;

    public CronController(YouthSurveyChoiceService youthSurveyChoiceService, InstructorSurveyChoiceService instructorSurveyChoiceService, OrganizationSurveyChoiceService organizationSurveyChoiceService, StudentCoreRepository studentCoreRepository, SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, LargeOrganizationSurveyChoiceService largeOrganizationSurveyChoiceService) {
        this.youthSurveyChoiceService = youthSurveyChoiceService;
        this.instructorSurveyChoiceService = instructorSurveyChoiceService;
        this.organizationSurveyChoiceService = organizationSurveyChoiceService;
        this.largeOrganizationSurveyChoiceService = largeOrganizationSurveyChoiceService;
        this.studentCoreRepository = studentCoreRepository;
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
    }

    @PostMapping(value={"/assign-survey-all"})
    public ResponseEntity<String> runAllServices() {
        StringBuilder result = new StringBuilder("Execution results:\n");
        try {
            this.youthSurveyChoiceService.assignSurveyToYouth(new Date());
            result.append("Youth survey assigned successfully.\n");
        }
        catch (Exception e) {
            result.append("Error assigning youth survey: ").append(e.getMessage()).append("\n");
        }
        try {
            this.instructorSurveyChoiceService.assignSurveyToInstructor(new Date());
            result.append("Instructor survey assigned successfully.\n");
        }
        catch (Exception e) {
            result.append("Error assigning instructor survey: ").append(e.getMessage()).append("\n");
        }
        try {
            this.organizationSurveyChoiceService.assignSurveyToOrganization(new Date());
            result.append("Organization survey assigned successfully.\n");
        }
        catch (Exception e) {
            result.append("Error assigning organization survey: ").append(e.getMessage()).append("\n");
        }
        try {
            this.largeOrganizationSurveyChoiceService.assignSurveyToLargeOrganization(new Date());
            result.append("Large organization survey assigned successfully.\n");
        }
        catch (Exception e) {
            result.append("Error assigning large organization survey: ").append(e.getMessage()).append("\n");
        }
        return ResponseEntity.ok((Object)result.toString());
    }

    @GetMapping(value={"/is-30-days-passed-social-emotion-test"})
    public ResponseEntity<?> is30DaysPassedToLastSocioEmotionalTest() {
        Date today = new Date();
        List student_ids = this.studentCoreRepository.findAllWhoCanGiveSocioEmotionalTest();
        if (!AppUtils.isNullOrEmpty((List)student_ids)) {
            List ids = student_ids.stream().map(arg_0 -> ((SocioEmotionalTestResultRepository)this.socioEmotionalTestResultRepository).getLastSubmitedSocioEmotionalTestByStudentId(arg_0)).filter(Objects::nonNull).filter(s -> DateUtils.countDaysBetweenFromDateAndToDate((Date)s.getCreatedAt(), (Date)today) >= 30L).map(SocioEmotionalTestResult::getStudent_id).collect(Collectors.toList());
            if (!AppUtils.isNullOrEmpty(ids)) {
                this.studentCoreRepository.setShouldAutoShowAssessmentAndShouldForceSocioEmotionalAssessment(ids, true, true);
            }
        }
        return ResponseEntity.ok().build();
    }
}

