/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dataset.dataservice;

import com.infinite.focus.server.dataset.dataservice.DataSetDataService;
import com.infinite.focus.server.dataset.dataservice.DataSetRepository;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.model.AssessmentCategory;
import com.infinite.focus.server.dataset.model.AssessmentCategoryAndName;
import com.infinite.focus.server.dataset.model.AssessmentChildCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetDataServiceImpl
implements DataSetDataService {
    @Autowired
    DataSetRepository dataSetRepository;

    public List<DataSet> getDataSets() {
        return this.dataSetRepository.findAll();
    }

    public DataSet getDataSetById(long data_set_id) {
        return this.dataSetRepository.findByDataSetId(data_set_id);
    }

    public List<DataSet> getDataSetsByAssessmentCategory(AssessmentCategory assessmentCategory) {
        return this.getDataSets().stream().filter(dataSet -> dataSet.getAssessment_category().equals((Object)assessmentCategory)).collect(Collectors.toList());
    }

    public DataSet createDataSet(DataSet dataSet) {
        return (DataSet)this.dataSetRepository.save((Object)dataSet);
    }

    public DataSet updateDataSet(DataSet dataSet) {
        return (DataSet)this.dataSetRepository.save((Object)dataSet);
    }

    public void deleteDataSet(DataSet dataSet) {
        this.dataSetRepository.delete((Object)dataSet);
    }

    public List<AssessmentCategoryAndName> getAssessmentChildCategoriesAndNamesByAssessmentCategory(AssessmentCategory assessmentCategory) {
        ArrayList<AssessmentCategoryAndName> assessmentCategoriesAndNames = new ArrayList<AssessmentCategoryAndName>();
        if (assessmentCategory.equals((Object)AssessmentCategory.RELATIONSHIP_SKILLS)) {
            DataSet COMMUNICATION = (DataSet)this.getDataSetsByAssessmentCategory(AssessmentCategory.RELATIONSHIP_SKILLS).stream().filter(dataSet -> dataSet.getAssessment_child_category().equals((Object)AssessmentChildCategory.COMMUNICATION)).limit(1L).collect(Collectors.toList()).get(0);
            assessmentCategoriesAndNames.add(new AssessmentCategoryAndName(COMMUNICATION.getAssessment_child_category().toString(), COMMUNICATION.getAssessment_child_category_name(), COMMUNICATION.getAssessment_category_name_es()));
            DataSet WORKING_TOGETHER = (DataSet)this.getDataSetsByAssessmentCategory(AssessmentCategory.RELATIONSHIP_SKILLS).stream().filter(dataSet -> dataSet.getAssessment_child_category().equals((Object)AssessmentChildCategory.WORKING_TOGETHER)).limit(1L).collect(Collectors.toList()).get(0);
            assessmentCategoriesAndNames.add(new AssessmentCategoryAndName(WORKING_TOGETHER.getAssessment_child_category().toString(), WORKING_TOGETHER.getAssessment_child_category_name(), WORKING_TOGETHER.getAssessment_child_category_name_es()));
            DataSet ASK_FOR_HELP = (DataSet)this.getDataSetsByAssessmentCategory(AssessmentCategory.RELATIONSHIP_SKILLS).stream().filter(dataSet -> dataSet.getAssessment_child_category().equals((Object)AssessmentChildCategory.ASK_FOR_HELP)).limit(1L).collect(Collectors.toList()).get(0);
            assessmentCategoriesAndNames.add(new AssessmentCategoryAndName(ASK_FOR_HELP.getAssessment_child_category().toString(), ASK_FOR_HELP.getAssessment_child_category_name(), ASK_FOR_HELP.getAssessment_child_category_name_es()));
            DataSet PEER_PRESSURE = (DataSet)this.getDataSetsByAssessmentCategory(AssessmentCategory.RELATIONSHIP_SKILLS).stream().filter(dataSet -> dataSet.getAssessment_child_category().equals((Object)AssessmentChildCategory.PEER_PRESSURE)).limit(1L).collect(Collectors.toList()).get(0);
            assessmentCategoriesAndNames.add(new AssessmentCategoryAndName(PEER_PRESSURE.getAssessment_child_category().toString(), PEER_PRESSURE.getAssessment_child_category_name(), PEER_PRESSURE.getAssessment_child_category_name_es()));
        }
        return assessmentCategoriesAndNames;
    }
}

