/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.group.service;

import com.infinite.focus.server.accesscode.repository.AccessCodeRepository;
import com.infinite.focus.server.accesscode.view.AccessCodeView;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.repository.ClassRepository;
import com.infinite.focus.server.group.service.ClassService;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.instructor.entity.Instructor;
import com.infinite.focus.server.instructor.service.InstructorService;
import com.infinite.focus.server.message.repository.MessageRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.repository.SchoolRepository;
import com.infinite.focus.server.standard.repository.StandardJPARepository;
import com.infinite.focus.server.standard.view.StandardView;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.student.view.StudentView;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ClassServiceImpl
implements ClassService {
    private final ClassRepository classRepository;
    private final InstructorService instructorService;
    private final StudentService studentService;
    private final MessageRepository messageRepository;
    private final ActivityService activityService;
    private final SchoolRepository schoolRepository;
    private final MessageService messageService;
    private final AccountRepository accountRepository;
    private final AccessCodeRepository accessCodeRepository;
    private final StandardJPARepository standardRepository;

    public ClassServiceImpl(ClassRepository classRepository, InstructorService instructorService, StudentService studentService, MessageRepository messageRepository, ActivityService activityService, SchoolRepository schoolRepository, MessageService messageService, AccountRepository accountRepository, AccessCodeRepository accessCodeRepository, StandardJPARepository standardRepository) {
        this.classRepository = classRepository;
        this.instructorService = instructorService;
        this.studentService = studentService;
        this.messageRepository = messageRepository;
        this.activityService = activityService;
        this.schoolRepository = schoolRepository;
        this.messageService = messageService;
        this.accountRepository = accountRepository;
        this.accessCodeRepository = accessCodeRepository;
        this.standardRepository = standardRepository;
    }

    public Class createClass(long instructor_id, String class_name) {
        if (instructor_id > 0L) {
            if (AppUtils.isNullOrEmpty((String)class_name)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.group.name.is.required"));
            }
            Class exist_class = this.classRepository.findByClassNameAndInstructorId(class_name, Long.valueOf(instructor_id));
            if (exist_class != null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.group.is.already.exist"));
            }
            Class _class = new Class();
            _class.setClass_name(class_name);
            Instructor instructor = this.instructorService.getInstructorById(instructor_id);
            _class.setInstructor(instructor);
            _class.getInstructors().add(instructor);
            School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
            _class.setSchool(school);
            return (Class)this.classRepository.save((Object)_class);
        }
        return null;
    }

    public List<BigInteger> findClassIdsWhereClassNameLike(String class_name) {
        return this.classRepository.findClassIdsWhereClassNameLike(class_name);
    }

    public ClassView findByClassId(long class_id) {
        return this.classRepository.findClassViewByClassId(class_id);
    }

    public void assignClassToStudent(long instructor_id, long class_id, long student_id) {
        ClassView class_ = this.findByClassId(class_id);
        if (class_ == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.group.is.not.found"));
        }
        if (class_.getInstructor_id() != instructor_id) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.group.is.not.belong.to.this.instructor"));
        }
        Student student = this.studentService.getStudentById(student_id);
        if (student == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.student.is.not.found"));
        }
        if (student.getInstructor_id() != instructor_id) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.student.is.not.belong.to.this.instructor"));
        }
        this.studentService.updateClassIdByStudentId(class_.getClass_id().longValue(), student.getStudent_id());
    }

    public void assignClassToStudents(long instructor_id, long class_id, List<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(student_ids)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.student.s.id.list.should.not.be.empty.or.null"));
        }
        for (long student_id : student_ids) {
            this.assignClassToStudent(instructor_id, class_id, student_id);
        }
    }

    public List<Class> findByInstructorId(long instructor_id) {
        return this.classRepository.findByInstructorId(Long.valueOf(instructor_id));
    }

    public List<StudentView> findStudentsByClassId(long class_id) {
        return this.classRepository.findStudentViewsByClassId(class_id).stream().filter(student -> {
            AccountView account = this.accountRepository.findAccountViewByAccountId(student.getAccount_id());
            AccessCodeView accessCode = this.accessCodeRepository.findAccessCodeViewByStudentId(student.getStudent_id());
            return !AppUtils.isNullOrEmpty((String)account.getUsername()) && accessCode != null && accessCode.getStatus() == Status.ACCEPTED;
        }).sorted(Comparator.comparing(StudentView::getFirst_name)).collect(Collectors.toList());
    }

    public List<StudentView> findStudentsByClassIdForSELAnalytics(long class_id) {
        return this.classRepository.findStudentViewsByClassId(class_id).stream().filter(student -> {
            AccountView account = this.accountRepository.findAccountViewByAccountId(student.getAccount_id());
            AccessCodeView accessCode = this.accessCodeRepository.findAccessCodeViewByStudentId(student.getStudent_id());
            StandardView standard = this.standardRepository.findStandardViewByStandardId(student.getStandard_id());
            return !AppUtils.isNullOrEmpty((String)account.getUsername()) && accessCode != null && accessCode.getStatus() == Status.ACCEPTED && standard != null && standard.getGrade_id() > 1L;
        }).sorted(Comparator.comparing(StudentView::getFirst_name)).collect(Collectors.toList());
    }

    public List<Class> getClassesByInstructorId(long instructor_id) {
        return this.classRepository.findByInstructorId(Long.valueOf(instructor_id));
    }

    public List<ClassView> getClassViewsByInstructorId(long instructor_id) {
        return this.classRepository.findClassViewsByInstructorId(Long.valueOf(instructor_id));
    }

    public Class save(Class class_) {
        return (Class)this.classRepository.save((Object)class_);
    }

    public List<Class> saveAll(List<Class> class_) {
        return this.classRepository.saveAll(class_);
    }

    public List<Class> getClassesBySchoolId(long school_id) {
        return this.classRepository.findBySchoolId(school_id);
    }

    public List<ClassView> getClassViewsBySchoolId(long school_id) {
        return this.classRepository.findClassViewsBySchoolId(school_id);
    }

    public void assignClassesToStudents(long instructor_id, List<Long> class_ids, List<Long> student_ids) {
        if (AppUtils.isNullOrEmpty(class_ids)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("please.select.at.least.one.group.and.save"));
        }
        if (AppUtils.isNullOrEmpty(student_ids)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.student.s.id.list.should.not.be.empty.or.null"));
        }
        for (long student_id : student_ids) {
            Student student = this.studentService.getStudentById(student_id);
            student.getClasses().clear();
            this.studentService.save(student);
        }
        for (long class_id : class_ids) {
            this.assignClassToStudents(instructor_id, class_id, student_ids);
        }
    }

    public String outOfStudentWhoLoggedBetween(long class_id, Date fromDate, Date toDate, TimeZone timeZone) {
        List studentIds = this.classRepository.findStudentViewsByClassId(class_id).stream().filter(student -> {
            AccountView account = this.accountRepository.findAccountViewByAccountId(student.getAccount_id());
            return account != null && !AppUtils.isNullOrEmpty((String)account.getUsername());
        }).map(StudentView::getStudent_id).collect(Collectors.toList());
        if (AppUtils.isNullOrEmpty(studentIds)) {
            return this.messageRepository.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "0").replace("<total>", "0");
        }
        List activities = this.activityService.getLoggedInStudentsByStudentIdsBetweenFromDateAndToDateAndBetweenFromTimeAndToTime(studentIds, DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(fromDate), DateUtils.yearMonthDateHoursMinutesSecondsUTC.format(toDate), timeZone);
        return this.messageRepository.getMessage().getNumber_of_students_who_did_clymb().replace("<out_of>", "" + activities.size()).replace("<total>", "" + studentIds.size());
    }

    @Async
    public void syncAllClasses() {
        List classes = this.classRepository.findAll();
        for (Class _class : classes) {
            try {
                Instructor instructor = this.instructorService.getInstructorById(_class.getInstructor_id());
                School school = this.schoolRepository.findBySchoolId(Long.valueOf(instructor.getSchool_id()));
                _class.setSchool(school);
                this.classRepository.save((Object)_class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Class getClassByCleverId(String clever_section_id) {
        return this.classRepository.findByCleverId(clever_section_id);
    }

    public void removeByIds(List<Long> class_ids) {
        this.classRepository.deleteByClassIds(class_ids);
    }
}

