/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.mood.controller;

import com.infinite.focus.server.data.model.EmotionCountAndAverage;
import com.infinite.focus.server.data.model.EmotionsByStandards;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.request.GetMoodsByIdsRequest;
import com.infinite.focus.server.mood.service.MoodService;
import com.infinite.focus.server.mood.wrapper.MoodWrapper;
import com.infinite.focus.server.standard.request.GetByStandardIdRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mood"})
public class MoodController {
    private final MoodService moodService;

    public MoodController(MoodService moodService) {
        this.moodService = moodService;
    }

    @GetMapping(value={"/get-ask-for-help-moods"})
    public ResponseEntity<List<MoodDTO>> getAskForHelpMoods() {
        return new ResponseEntity((Object)this.moodService.getAskForHelpMoods(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-moods-by-ids"})
    public ResponseEntity<List<MoodDTO>> getMoodsByIds(@RequestBody GetMoodsByIdsRequest request) {
        return new ResponseEntity((Object)this.moodService.getMoodsByIds(request.getIds()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-moods"})
    public ResponseEntity<List<MoodDTO>> getAllMoods() {
        return new ResponseEntity((Object)this.moodService.getAllMoods(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-standard-id"})
    public ResponseEntity<List<MoodWrapper>> getByStandardId(@RequestHeader(value="Authorization") String token, @RequestBody GetByStandardIdRequest request) {
        return new ResponseEntity(this.moodService.getByStandardId(request.getStandard_id()).stream().map(m -> MoodWrapper.builder().mood_id(m.getMood_id()).mood(m.getMood()).mood_es(m.getMood_es()).images_elementary(m.getImages_elementary()).images_others(m.getImages_others()).for_elementary_grade_only(m.isFor_elementary_grade_only()).build()).collect(Collectors.toList()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-emotions-and-sub-emotions"})
    public ResponseEntity<List<EmotionCountAndAverage>> getAllEmotionsAndSubEmotions(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity((Object)this.moodService.getAllEmotionsAndSubEmotions(token), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-all-emotions"})
    public ResponseEntity<EmotionsByStandards> getAllEmotions(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity((Object)this.moodService.getAllEmotions(token), (HttpStatusCode)HttpStatus.OK);
    }
}

