/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodandstandard.repository;

import com.infinite.focus.server.moodandstandard.dto.MoodAndStandardDTO;
import com.infinite.focus.server.moodandstandard.repository.MoodAndStandardRepository;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class MoodAndStandardRepositoryImpl
implements MoodAndStandardRepository {
    private final JdbcTemplate jdbcTemplate;

    public MoodAndStandardRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private static MoodAndStandardDTO mapRow(ResultSet rs, int i) throws SQLException {
        return MoodAndStandardDTO.builder().mood_and_standard_id(rs.getLong("mood_and_standard_id")).mood_id(rs.getLong("mood_id")).standard_id(rs.getLong("standard_id")).sort_index(rs.getInt("sort_index")).build();
    }

    public List<MoodAndStandardDTO> findByStandardId(long standard_id) {
        String SQL = "SELECT * FROM mood_and_standard m_a_s WHERE m_a_s.standard_id = ? ORDER BY m_a_s.sort_index ASC ";
        try {
            return this.jdbcTemplate.query(SQL, MoodAndStandardRepositoryImpl::mapRow, new Object[]{standard_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<MoodAndStandardDTO>();
        }
    }

    public List<Long> findMoodIdsByStandardId(long standard_id) {
        String SQL = "SELECT m_a_s.mood_id, m_a_s.sort_index FROM mood_and_standard m_a_s WHERE m_a_s.standard_id = ? ORDER BY m_a_s.sort_index ASC ";
        try {
            return this.jdbcTemplate.query(SQL, (rs, i) -> rs.getLong(1), new Object[]{standard_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Long>();
        }
    }
}

