/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.responsibledecisionmaking.service;

import com.infinite.focus.server.assessment.model.AssessmentOccurrence;
import com.infinite.focus.server.assessment.model.CategoryAndScore;
import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.client.StandardClient;
import com.infinite.focus.server.data.model.OccurrenceAndOccurrenceAverage;
import com.infinite.focus.server.dataset.dto.DataSetDTO;
import com.infinite.focus.server.dataset.entity.DataSet;
import com.infinite.focus.server.dataset.service.DataSetService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.responsibledecisionmaking.dto.ResponsibleDecisionMakingUpdateDTO;
import com.infinite.focus.server.responsibledecisionmaking.entity.ResponsibleDecisionMakingUpdate;
import com.infinite.focus.server.responsibledecisionmaking.model.AssessmentOccurrenceByStandards;
import com.infinite.focus.server.responsibledecisionmaking.repository.ResponsibleDecisionMakingUpdateCriteriaRepository;
import com.infinite.focus.server.responsibledecisionmaking.repository.ResponsibleDecisionMakingUpdateRepository;
import com.infinite.focus.server.responsibledecisionmaking.service.ResponsibleDecisionMakingUpdateService;
import com.infinite.focus.server.responsibledecisionmaking.wrapper.ResponsibleDecisionMakingUpdateWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ResponsibleDecisionMakingUpdateServiceImpl
implements ResponsibleDecisionMakingUpdateService {
    private final ResponsibleDecisionMakingUpdateCriteriaRepository responsibleDecisionMakingUpdateCriteriaRepository;
    private final EntityManager entityManager;
    private final ResponsibleDecisionMakingUpdateRepository responsibleDecisionMakingUpdateRepository;
    private final DataSetService dataService;
    private final MessageService messageService;
    private final StandardClient standardClient;

    public ResponsibleDecisionMakingUpdateServiceImpl(ResponsibleDecisionMakingUpdateCriteriaRepository responsibleDecisionMakingUpdateCriteriaRepository, EntityManager entityManager, ResponsibleDecisionMakingUpdateRepository responsibleDecisionMakingUpdateRepository, DataSetService dataService, MessageService messageService, StandardClient standardClient) {
        this.responsibleDecisionMakingUpdateCriteriaRepository = responsibleDecisionMakingUpdateCriteriaRepository;
        this.entityManager = entityManager;
        this.responsibleDecisionMakingUpdateRepository = responsibleDecisionMakingUpdateRepository;
        this.dataService = dataService;
        this.messageService = messageService;
        this.standardClient = standardClient;
    }

    public ResponsibleDecisionMakingUpdate createResponsibleDecisionMakingUpdate(ResponsibleDecisionMakingUpdate responsibleDecisionMakingUpdate) {
        DataSet dataSet = this.dataService.getDataSetById(responsibleDecisionMakingUpdate.getData_set_id());
        if (dataSet == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.data.set.is.not.found"));
        }
        responsibleDecisionMakingUpdate.setScore(dataSet.getScore());
        return (ResponsibleDecisionMakingUpdate)this.responsibleDecisionMakingUpdateRepository.save((Object)responsibleDecisionMakingUpdate);
    }

    public Page<ResponsibleDecisionMakingUpdateWrapper> getResponsibleDecisionMakingUpdateLogByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.responsibleDecisionMakingUpdateRepository.findByStudentId(Long.valueOf(student_id), (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(log -> {
            ResponsibleDecisionMakingUpdateWrapper wrapper = new ResponsibleDecisionMakingUpdateWrapper();
            DataSet dataSet = this.dataService.getDataSetById(log.getData_set_id());
            this.dataService.addDataSetImages(dataSet);
            wrapper.setResponsible_decision_making_update_id(log.getResponsible_decision_making_update_id());
            wrapper.setStudent_id(log.getStudent_id());
            wrapper.setData_set_id(log.getData_set_id());
            wrapper.setText(log.getText());
            wrapper.setText_es(log.getText_es());
            wrapper.setImage(dataSet.getImage());
            wrapper.setColor(dataSet.getColor());
            wrapper.setCreatedAt(log.getCreatedAt());
            return wrapper;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public Page<ResponsibleDecisionMakingUpdateWrapper> getByStudentId(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)("desc".equalsIgnoreCase(orderBy) ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.responsibleDecisionMakingUpdateRepository.findByStudentId(Long.valueOf(student_id), (Pageable)paging);
        List data_set_ids = pagedResult.stream().map(ResponsibleDecisionMakingUpdate::getData_set_id).distinct().collect(Collectors.toList());
        HashMap dataSetMap = new HashMap();
        if (!AppUtils.isNullOrEmpty(data_set_ids)) {
            this.dataService.getDataSetByIds(data_set_ids).forEach(dataSet -> dataSetMap.put(dataSet.getData_set_id(), dataSet));
        }
        List wrappers = pagedResult.stream().map(log -> {
            ResponsibleDecisionMakingUpdateWrapper wrapper = new ResponsibleDecisionMakingUpdateWrapper();
            DataSetDTO dataSet = (DataSetDTO)dataSetMap.get(log.getData_set_id());
            wrapper.setResponsible_decision_making_update_id(log.getResponsible_decision_making_update_id());
            wrapper.setStudent_id(log.getStudent_id());
            wrapper.setData_set_id(log.getData_set_id());
            wrapper.setText(log.getText());
            wrapper.setText_es(log.getText_es());
            if (dataSet != null) {
                wrapper.setImage(dataSet.getImage());
                wrapper.setColor(dataSet.getColor());
            }
            wrapper.setCreatedAt(log.getCreatedAt());
            return wrapper;
        }).collect(Collectors.toList());
        return new PageImpl(wrappers, pagedResult.getPageable(), pagedResult.getTotalElements());
    }

    public ResponsibleDecisionMakingUpdate getResponsibleDecisionMakingUpdateById(long responsible_decision_making_update_id) {
        return this.responsibleDecisionMakingUpdateRepository.findByResponsibleDecisionMakingUpdateId(responsible_decision_making_update_id);
    }

    public CategoryAndScore getCategoryAndScoreByResponsibleDecisionMakingUpdateIdAndScore(long responsible_decision_making_update_id, double score) {
        ResponsibleDecisionMakingUpdate responsibleDecisionMakingUpdate = this.getResponsibleDecisionMakingUpdateById(responsible_decision_making_update_id);
        CategoryDTO category = this.dataService.getCategoryByDataSetId(responsibleDecisionMakingUpdate.getData_set_id());
        CategoryAndScore categoryAndScore = new CategoryAndScore();
        categoryAndScore.setCategory(category);
        categoryAndScore.setScore(score);
        return categoryAndScore;
    }

    public List<String[]> getTextList() {
        List list = this.responsibleDecisionMakingUpdateRepository.getTextListOrderByDataSetId();
        ArrayList<String[]> texts = new ArrayList<String[]>();
        for (Object[] item : list) {
            texts.add(new String[]{(String)item[0], (String)item[1]});
        }
        return texts;
    }

    public List<ResponsibleDecisionMakingUpdate> findByStudentIdAndBetweenFromDateAndEndDate(Long student_id, String fromDate, String toDate) {
        return this.responsibleDecisionMakingUpdateRepository.findByStudentIdAndBetweenFromDateAndEndDate(student_id, fromDate, toDate);
    }

    public List<ResponsibleDecisionMakingUpdate> getResponsibleDecisionMakingUpdateByStudentIds(List<Long> student_ids, Date fromDate, Date toDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(ResponsibleDecisionMakingUpdate.class);
        Root root = query.from(ResponsibleDecisionMakingUpdate.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (!AppUtils.isNotNullOrEmpty(student_ids)) {
            return new ArrayList<ResponsibleDecisionMakingUpdate>();
        }
        CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)root.get("student_id")).value(student_ids);
        predicates.add(genderPredicate);
        if (fromDate != null && toDate != null) {
            System.out.println("getResponsibleDecisionMakingUpdateByStudentIds FromDate " + DateUtils.dailyDateFormat.format(fromDate) + " - ToDate " + DateUtils.dailyDateFormat.format(toDate));
            predicates.add(criteriaBuilder.between((Expression)root.get("createdAt"), (Comparable)fromDate, (Comparable)toDate));
        }
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("createdAt"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List responsibleDecisionMakingUpdateList = typedQuery.getResultList();
        System.out.println("ResponsibleDecisionMakingUpdate Count = " + responsibleDecisionMakingUpdateList.size());
        return responsibleDecisionMakingUpdateList;
    }

    public AssessmentOccurrenceByStandards getByStudentIdsAndFromDateAndToDate(Set<Long> student_ids, Date from_date, Date to_date) {
        List responsibleDecisionMakingUpdateDTOS = this.responsibleDecisionMakingUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, from_date, to_date);
        AssessmentOccurrenceByStandards byStandards = AssessmentOccurrenceByStandards.builder()._3_5(new ArrayList(this.responsibleDecisionMakingUpdateCriteriaRepository.getTextToDisplay2()))._6_12(new ArrayList(this.responsibleDecisionMakingUpdateCriteriaRepository.getTextToDisplay2())).build();
        Set _3_5_standard_ids = this.standardClient.get3_5StandardIds();
        Set _6_12_standard_ids = this.standardClient.get6_12StandardIds();
        this.setResponsibleDecisionMakingByStandard(student_ids, _3_5_standard_ids, byStandards.get_3_5(), responsibleDecisionMakingUpdateDTOS);
        this.setResponsibleDecisionMakingByStandard(student_ids, _6_12_standard_ids, byStandards.get_6_12(), responsibleDecisionMakingUpdateDTOS);
        return byStandards;
    }

    public ResponsibleDecisionMakingUpdateDTO getById(long responsible_decision_making_update_id) {
        return this.responsibleDecisionMakingUpdateCriteriaRepository.findById(responsible_decision_making_update_id);
    }

    public List<OccurrenceAndOccurrenceAverage> getOccurrenceAndOccurrenceAverageByStudentIdsAndFromDateAndToDate(Set<Long> student_ids, Date from_date, Date to_date) {
        List responsibleDecisionMakingUpdateDTOS = this.responsibleDecisionMakingUpdateCriteriaRepository.findByStudentIdsAndBetweenFromDateAndToDate2(student_ids, from_date, to_date);
        List occurrenceAndOccurrenceAverages = this.setResponsibleDecisionMaking(student_ids, this.responsibleDecisionMakingUpdateCriteriaRepository.getTextToDisplay3(), responsibleDecisionMakingUpdateDTOS);
        return occurrenceAndOccurrenceAverages;
    }

    private void setResponsibleDecisionMakingByStandard(Set<Long> student_ids, Set<Long> standardIds, List<AssessmentOccurrence> assessmentOccurrences, List<ResponsibleDecisionMakingUpdateDTO> responsibleDecisionMakingUpdateDTOS) {
        Set byStandards = responsibleDecisionMakingUpdateDTOS.stream().filter(r -> standardIds.contains(r.getStandard_id())).collect(Collectors.toSet());
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            for (ResponsibleDecisionMakingUpdateDTO dto : byStandards) {
                if (!dto.getText().equalsIgnoreCase(assessmentOccurrence.getText_to_display()) || !dto.getText_es().equalsIgnoreCase(assessmentOccurrence.getText_to_display_es())) continue;
                assessmentOccurrence.setOccurrence(assessmentOccurrence.getOccurrence() + 1L);
            }
            try {
                assessmentOccurrence.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)assessmentOccurrence.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (AssessmentOccurrence assessmentOccurrence : assessmentOccurrences) {
            try {
                assessmentOccurrence.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)assessmentOccurrence.getOccurrence(), (Long)Long.valueOf(byStandards.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<OccurrenceAndOccurrenceAverage> setResponsibleDecisionMaking(Set<Long> student_ids, List<OccurrenceAndOccurrenceAverage> occurrenceAndOccurrenceAverages, List<ResponsibleDecisionMakingUpdateDTO> responsibleDecisionMakingUpdateDTOS) {
        for (OccurrenceAndOccurrenceAverage occurrenceAndOccurrenceAverage : occurrenceAndOccurrenceAverages) {
            for (ResponsibleDecisionMakingUpdateDTO dto : responsibleDecisionMakingUpdateDTOS) {
                if (!dto.getText().equalsIgnoreCase(occurrenceAndOccurrenceAverage.getText_to_display()) || !dto.getText_es().equalsIgnoreCase(occurrenceAndOccurrenceAverage.getText_to_display_es())) continue;
                occurrenceAndOccurrenceAverage.setOccurrence(occurrenceAndOccurrenceAverage.getOccurrence() + 1L);
            }
            try {
                occurrenceAndOccurrenceAverage.setCount(DigitUtils.doubleHalfUpWithScaleOf2((Double)((double)occurrenceAndOccurrenceAverage.getOccurrence() / (double)student_ids.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (OccurrenceAndOccurrenceAverage occurrenceAndOccurrenceAverage : occurrenceAndOccurrenceAverages) {
            try {
                occurrenceAndOccurrenceAverage.setOccurrence_average(DigitUtils.getPercentageInTwoDigit((Long)occurrenceAndOccurrenceAverage.getOccurrence(), (Long)Long.valueOf(responsibleDecisionMakingUpdateDTOS.size())).doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return occurrenceAndOccurrenceAverages;
    }
}

