/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.security.helper;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.utils.AppUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JwtHelper {
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String SECRET_KEY = "as67fg6y7hh7shrimp8923fdf34fg45fg45ht4rg4e34ef";
    private static final String REFRESH_SECRET_KEY = "67545y7hh7shr4545df344st445fg467676ht4rg4e34ef";
    @Autowired
    private ConfigurationRepository configurationRepository;

    public String extractUsername(String token) {
        token = token.replace("Bearer ", "");
        return (String)this.extractClaim(token, Claims::getSubject);
    }

    public String extractUsernameForRefreshToken(String token) {
        token = token.replace("Bearer ", "");
        return (String)this.extractClaimForRefreshToken(token, Claims::getSubject);
    }

    public String extractUsernameForExpiredToken(String token) {
        token = token.replace("Bearer ", "");
        return (String)this.extractClaimForExpiredToken(token, Claims::getSubject);
    }

    public Date extractExpiration(String token) {
        token = token.replace("Bearer ", "");
        return (Date)this.extractClaim(token, Claims::getExpiration);
    }

    public Date extractExpirationForExpiredToken(String token) {
        token = token.replace("Bearer ", "");
        return (Date)this.extractClaimForExpiredToken(token, Claims::getExpiration);
    }

    public <T> T extractClaim(String token, Function<Claims, T> claimsResolver) {
        token = token.replace("Bearer ", "");
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    public <T> T extractClaimForRefreshToken(String token, Function<Claims, T> claimsResolver) {
        token = token.replace("Bearer ", "");
        Claims claims = this.extractAllClaimsForRefreshToken(token);
        return claimsResolver.apply(claims);
    }

    public <T> T extractClaimForExpiredToken(String token, Function<Claims, T> claimsResolver) {
        token = token.replace("Bearer ", "");
        Claims claims = this.extractAllClaimsForExpiredToken(token);
        return claimsResolver.apply(claims);
    }

    private Claims extractAllClaims(String token) {
        return (Claims)Jwts.parser().verifyWith(this.getSignKey()).build().parseSignedClaims((CharSequence)token).getPayload();
    }

    private Claims extractAllClaimsForRefreshToken(String token) {
        return (Claims)Jwts.parser().verifyWith(JwtHelper.getRefreshKey()).build().parseSignedClaims((CharSequence)token).getPayload();
    }

    private Claims extractAllClaimsForExpiredToken(String token) {
        return (Claims)Jwts.parser().clockSkewSeconds(System.currentTimeMillis() / 2L).verifyWith(this.getSignKey()).build().parseSignedClaims((CharSequence)token).getPayload();
    }

    public Boolean isTokenExpired(String token) {
        token = token.replace("Bearer ", "");
        return this.extractExpirationForExpiredToken(token).before(new Date());
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        String username = this.extractUsername(token = token.replace("Bearer ", ""));
        return username.equals(userDetails.getUsername()) && this.isTokenExpired(token) == false;
    }

    public String generateToken(String userName) {
        HashMap claims = new HashMap();
        return "Bearer " + this.createToken(claims, userName);
    }

    private String createToken(Map<String, Object> claims, String userName) {
        return Jwts.builder().claims(claims).subject(userName).issuedAt(new Date(System.currentTimeMillis())).expiration(new Date(Instant.now().plus(this.configurationRepository.getConfiguration().getJwt_access_token_expiration(), ChronoUnit.SECONDS).toEpochMilli())).signWith((Key)this.getSignKey()).compact();
    }

    public String generateRefreshToken(String userName) {
        HashMap claims = new HashMap();
        return "Bearer " + this.createRefreshToken(claims, userName);
    }

    private String createRefreshToken(Map<String, Object> claims, String userName) {
        return Jwts.builder().claims(claims).subject(userName).issuedAt(new Date(System.currentTimeMillis())).expiration(new Date(Instant.now().plus(this.configurationRepository.getConfiguration().getJwt_refresh_token_expiration(), ChronoUnit.SECONDS).toEpochMilli())).signWith((Key)JwtHelper.getRefreshKey()).compact();
    }

    private SecretKey getSignKey() {
        return Keys.hmacShaKeyFor((byte[])"as67fg6y7hh7shrimp8923fdf34fg45fg45ht4rg4e34ef".getBytes(StandardCharsets.UTF_8));
    }

    private static SecretKey getRefreshKey() {
        return Keys.hmacShaKeyFor((byte[])"67545y7hh7shr4545df344st445fg467676ht4rg4e34ef".getBytes(StandardCharsets.UTF_8));
    }

    public Boolean isBearerToken(String token) {
        return !AppUtils.isNullOrEmpty((String)token) && token.contains("Bearer ");
    }
}

