/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosanswer.repository;

import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosanswer.repository.SOSAnswerRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SOSAnswerRepositoryImpl
implements SOSAnswerRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static SOSAnswerDTO mapRow(ResultSet rs, int i) throws SQLException {
        return SOSAnswerDTO.builder().sos_answer_id(rs.getLong("sos_answer_id")).sos_request_id(rs.getLong("sos_request_id")).sos_question_id(rs.getLong("sos_question_id")).sos_option_id((long)rs.getInt("sos_option_id")).build();
    }

    @Transactional
    public ArrayList<Long> createAnswers(List<SOSAnswerDTO> answers) {
        String INSERT_SQL = "INSERT INTO sosanswer (sos_request_id, sos_question_id, sos_option_id) VALUES (?,?,?)";
        ArrayList insertedIds = (ArrayList)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO sosanswer (sos_request_id, sos_question_id, sos_option_id) VALUES (?,?,?)", 1), ps -> {
            for (SOSAnswerDTO answer : answers) {
                ps.setLong(1, answer.getSos_request_id());
                ps.setLong(2, answer.getSos_question_id());
                ps.setLong(3, answer.getSos_option_id());
                ps.addBatch();
            }
            ps.executeBatch();
            ResultSet resultSet = ps.getGeneratedKeys();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            return ids;
        });
        return insertedIds;
    }

    public List<SOSAnswerDTO> getByIds(List<Long> ids) {
        if (AppUtils.isNullOrEmpty(ids)) {
            return new ArrayList<SOSAnswerDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String SQL = "SELECT * FROM sosanswer WHERE sos_answer_id IN(%s) ORDER BY sos_question_id ASC";
        List sosOptionDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), ids.toArray(), SOSAnswerRepositoryImpl::mapRow);
        return sosOptionDTOS;
    }

    public List<SOSAnswerDTO> findBySOSRequestId(long sos_request_id) {
        String SQL = "SELECT * FROM sosanswer WHERE sos_request_id = ? ORDER BY sos_question_id ASC";
        return this.jdbcTemplate.query(SQL, SOSAnswerRepositoryImpl::mapRow, new Object[]{sos_request_id});
    }
}

