/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosquestion.controller;

import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.sosoption.dto.SOSOptionDTO;
import com.infinite.focus.server.sosquestion.dto.SOSQuestionDTO;
import com.infinite.focus.server.sosquestion.request.GetActiveQuestionsCount;
import com.infinite.focus.server.sosquestion.request.GetQuestionsRequest;
import com.infinite.focus.server.sosquestion.request.GetSOSQuestionsByIdsRequest;
import com.infinite.focus.server.sosquestion.service.SOSQuestionService;
import com.infinite.focus.server.sosquestion.wrapper.SOSQuestionOptionWrapper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/sos-question"})
public class SOSQuestionController {
    @Autowired
    private SOSQuestionService sosQuestionService;
    @Autowired
    MessageService messageService;
    @Autowired
    private ConfigurationRepository configurationRepository;
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/create"})
    public ResponseEntity<SOSQuestionOptionWrapper> create(@RequestHeader(value="Authorization") String token, @RequestBody SOSQuestionOptionWrapper request) {
        this.authService.isAdmin(token);
        if (request.getQuestion() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("question.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getQuestion().getImage())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.question.image.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getQuestion().getQuestion())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.english.question.should.not.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getQuestion().getQuestion_es())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.spanish.question.should.not.null.or.empty"));
        }
        if (request.getQuestion().getChoice_type() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("question.choice.type.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((List)request.getOptions())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("options.are.not.found"));
        }
        if (request.getOptions().size() < 2) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("at.least.two.options.are.required.for.a.question"));
        }
        if (request.getOptions().size() > 4) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("max.four.options.are.allowed.for.a_question"));
        }
        for (SOSOptionDTO sosOptionDTO : request.getOptions()) {
            if (AppUtils.isNullOrEmpty((String)sosOptionDTO.getSos_option())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.english.option.should.not.null.or.empty"));
            }
            if (!AppUtils.isNullOrEmpty((String)sosOptionDTO.getSos_option_es())) continue;
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.spanish.option.should.not.null.or.empty"));
        }
        return new ResponseEntity((Object)this.sosQuestionService.create(request.getQuestion().getImage(), request.getQuestion().getQuestion(), request.getQuestion().getQuestion_es(), request.getQuestion().isActive(), request.getQuestion().getChoice_type(), request.getOptions()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<SOSQuestionOptionWrapper> update(@RequestHeader(value="Authorization") String token, @RequestBody SOSQuestionOptionWrapper request) {
        this.authService.isAdmin(token);
        if (request.getQuestion() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("question.is.not.found"));
        }
        if (request.getQuestion().getSos_question_id() <= 0L) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.question.image.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getQuestion().getImage())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.question.image.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getQuestion().getQuestion())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.english.question.should.not.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getQuestion().getQuestion_es())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.spanish.question.should.not.null.or.empty"));
        }
        if (request.getQuestion().getChoice_type() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("question.choice.type.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((List)request.getOptions())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("options.are.not.found"));
        }
        if (request.getOptions().size() < 2) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("at.least.two.options.are.required.for.a.question"));
        }
        if (request.getOptions().size() > 4) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("max.four.options.are.allowed.for.a_question"));
        }
        for (SOSOptionDTO sosOptionDTO : request.getOptions()) {
            if (AppUtils.isNullOrEmpty((String)sosOptionDTO.getSos_option())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.english.option.should.not.null.or.empty"));
            }
            if (!AppUtils.isNullOrEmpty((String)sosOptionDTO.getSos_option_es())) continue;
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.spanish.option.should.not.null.or.empty"));
        }
        return new ResponseEntity((Object)this.sosQuestionService.update(request.getQuestion().getSos_question_id(), request.getQuestion().getImage(), request.getQuestion().getQuestion(), request.getQuestion().getQuestion_es(), request.getQuestion().isActive(), request.getQuestion().getChoice_type(), request.getOptions()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/active-inactive-question"})
    public ResponseEntity<SOSQuestionDTO> activeInactiveQuestion(@RequestHeader(value="Authorization") String token, @RequestBody SOSQuestionDTO request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.sosQuestionService.activeInactiveQuestion(request.getSos_question_id(), request.isActive()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-questions"})
    public ResponseEntity<Page<SOSQuestionOptionWrapper>> getQuestions(@RequestHeader(value="Authorization") String token, @RequestBody GetQuestionsRequest request) {
        this.authService.isAdmin(token);
        int image_width = 0;
        image_width = request.getImage_width() != null && request.getImage_width() > 0 ? request.getImage_width().intValue() : this.configurationRepository.getConfiguration().getWow_image_width();
        return new ResponseEntity((Object)this.sosQuestionService.getQuestions(Integer.valueOf(image_width), request.getPageNo(), request.getPageSize(), request.getOrderBy(), request.getSortBy()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-active-questions-count"})
    public ResponseEntity<GetActiveQuestionsCount> getActiveQuestionsCount() {
        return new ResponseEntity((Object)this.sosQuestionService.getActiveQuestionsCount(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-questions/for/student"})
    public ResponseEntity<Page<SOSQuestionOptionWrapper>> getQuestionsForStudent(@RequestHeader(value="Authorization") String token, @RequestBody GetQuestionsRequest request) {
        this.authService.isStudent(token);
        int image_width = 0;
        image_width = request.getImage_width() != null && request.getImage_width() > 0 ? request.getImage_width().intValue() : this.configurationRepository.getConfiguration().getWow_image_width();
        return new ResponseEntity((Object)this.sosQuestionService.getQuestionsForStudent(Integer.valueOf(image_width), request.getPageNo(), request.getPageSize(), request.getOrderBy(), request.getSortBy()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-sos-questions-by-ids"})
    public ResponseEntity<List<SOSQuestionDTO>> getSOSQuestionsByIds(@RequestBody GetSOSQuestionsByIdsRequest request) {
        int image_width = 0;
        image_width = request.getImage_width() != null && request.getImage_width() > 0 ? request.getImage_width().intValue() : this.configurationRepository.getConfiguration().getWow_image_width();
        return new ResponseEntity((Object)this.sosQuestionService.getSOSQuestionsByIds(request.getSos_question_ids(), image_width), (HttpStatusCode)HttpStatus.OK);
    }
}

