/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosrequest.service;

import com.infinite.focus.server.account.request.GetEmailByAccountIdRequest;
import com.infinite.focus.server.account.response.GetEmailByAccountIdResponse;
import com.infinite.focus.server.askforhelp.dto.AskForHelpDTO;
import com.infinite.focus.server.askforhelp.request.CreateAskForHelpRequest;
import com.infinite.focus.server.askforhelp.request.GetAskForHelpByIdRequest;
import com.infinite.focus.server.askforhelp.request.SetSOSRequestIdRequest;
import com.infinite.focus.server.client.AccountClient;
import com.infinite.focus.server.client.AskForHelpClient;
import com.infinite.focus.server.client.EmailClient;
import com.infinite.focus.server.client.NotificationClient;
import com.infinite.focus.server.client.SOSAnswerClient;
import com.infinite.focus.server.client.StandardClient;
import com.infinite.focus.server.client.StudentClient;
import com.infinite.focus.server.email.request.SendSOSAlertEmailRequest;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.notification.request.SOSAlertNotification;
import com.infinite.focus.server.sosanswer.dto.SOSAnswerDTO;
import com.infinite.focus.server.sosrequest.dto.SOSRequestDTO;
import com.infinite.focus.server.sosrequest.repository.SOSRequestRepository;
import com.infinite.focus.server.sosrequest.request.SOSAnswerRequest;
import com.infinite.focus.server.sosrequest.service.SOSRequestService;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestForInstructorWrapper;
import com.infinite.focus.server.sosrequest.wrapper.SOSRequestWrapper;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.student.dto.StudentCoreDTO;
import com.infinite.focus.server.student.dto.StudentDTO;
import com.infinite.focus.server.student.request.GetStudentByInstructorIdAndStudentNameRequest;
import com.infinite.focus.server.student.request.GetStudentByInstructorRequest;
import com.infinite.focus.server.student.request.GetStudentIdsByDemographicsRequest;
import com.infinite.focus.server.student.request.GetStudentsByIdsRequest;
import com.infinite.focus.server.student.request.GetStudentsBySchoolIdRequest;
import com.infinite.focus.server.utils.AppUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SOSRequestServiceImpl
implements SOSRequestService {
    @Autowired
    MessageService messageService;
    @Autowired
    private SOSRequestRepository sosRequestRepository;
    private final AccountClient accountClient;
    private final SOSAnswerClient sosAnswerClient;
    private final AskForHelpClient askForHelpClient;
    private final StudentClient studentClient;
    private final StandardClient standardClient;
    private final NotificationClient notificationClient;
    private final EmailClient emailClient;

    public SOSRequestServiceImpl(AccountClient accountClient, SOSAnswerClient sosAnswerClient, AskForHelpClient askForHelpClient, StudentClient studentClient, StandardClient standardClient, NotificationClient notificationClient, EmailClient emailClient) {
        this.accountClient = accountClient;
        this.sosAnswerClient = sosAnswerClient;
        this.askForHelpClient = askForHelpClient;
        this.studentClient = studentClient;
        this.standardClient = standardClient;
        this.notificationClient = notificationClient;
        this.emailClient = emailClient;
    }

    public SOSRequestWrapper create(long student_id, long mood_update_id, List<SOSAnswerRequest> answers, String token) {
        AskForHelpDTO askForHelpDTO = mood_update_id > 0L ? this.askForHelpClient.create(CreateAskForHelpRequest.builder().student_id(student_id).mood_update_id(mood_update_id).build()) : null;
        SOSRequestDTO sosRequestDTO = this.sosRequestRepository.create(student_id, askForHelpDTO != null ? askForHelpDTO.getAsk_for_help_id() : 0L);
        List sosAnswerDTOS = answers.stream().flatMap(sosAnswerRequest -> sosAnswerRequest.getSos_option_ids().stream().map(sos_option_id -> SOSAnswerDTO.builder().sos_answer_id(0L).sos_request_id(sosRequestDTO.getSos_request_id()).sos_question_id(sosAnswerRequest.getSos_question_id()).sos_option_id(sos_option_id.longValue()).build())).collect(Collectors.toList());
        List answerDTOS = this.sosAnswerClient.createAnswers(sosAnswerDTOS);
        Optional.ofNullable(askForHelpDTO).ifPresent(dto -> this.askForHelpClient.setSOSRequestId(token, SetSOSRequestIdRequest.builder().ask_for_help_id(dto.getAsk_for_help_id()).sos_request_id(sosRequestDTO.getSos_request_id()).build()));
        return SOSRequestWrapper.builder().request(sosRequestDTO).answers(answerDTOS).build();
    }

    public SOSRequestDTO getSOSRequestByAskForHelpId(long ask_for_help_id) {
        AskForHelpDTO askForHelpDTO = this.askForHelpClient.getAskForHelpById(GetAskForHelpByIdRequest.builder().ask_for_help_id(ask_for_help_id).build());
        if (askForHelpDTO != null) {
            return this.sosRequestRepository.findById(askForHelpDTO.getSos_request_id());
        }
        return null;
    }

    @Async
    public void sendSOSNotification(long student_id, String token) {
        this.notificationClient.sosAlertNotification(token, SOSAlertNotification.builder().student_id(student_id).build());
    }

    @Async
    public void setSOSEmailToInstructor(long account_id, String student_name, String grade, long sos_request_id, String language, String token) {
        GetEmailByAccountIdResponse getInstructorEmailResponse = this.accountClient.getEmailByAccountId(token, GetEmailByAccountIdRequest.builder().account_id(account_id).build());
        this.emailClient.sendSOSEmail(token, SendSOSAlertEmailRequest.builder().email(getInstructorEmailResponse.getEmail()).student_name(student_name).grade(grade).sos_request_id(sos_request_id).language(language).parent(false).build());
    }

    @Async
    public void setSOSEmailToParent(long account_id, String email, String student_name, String standard_name, long sos_request_id, String language, String token) {
        if (account_id > 0L) {
            GetEmailByAccountIdResponse getEmailByAccountIdResponse = this.accountClient.getEmailByAccountId(token, GetEmailByAccountIdRequest.builder().account_id(account_id).build());
            email = getEmailByAccountIdResponse.getEmail();
        }
        this.emailClient.sendSOSEmail(token, SendSOSAlertEmailRequest.builder().email(email).student_name(student_name).grade(standard_name).sos_request_id(sos_request_id).language(language).parent(true).build());
    }

    @Async
    public void setSOSEmailToOrganization(long account_id, String student_name, String grade, long sos_request_id, String language, String token) {
        GetEmailByAccountIdResponse getSchoolEmailResponse = this.accountClient.getEmailByAccountId(token, GetEmailByAccountIdRequest.builder().account_id(account_id).build());
        this.emailClient.sendSOSAlertEmail(token, SendSOSAlertEmailRequest.builder().email(getSchoolEmailResponse.getEmail()).student_name(student_name).grade(grade).sos_request_id(sos_request_id).language(language).parent(false).build());
    }

    public int getSOSRequestNotViewedCountByInstructorId(long instructor_id) {
        HashSet student_ids = new HashSet(this.studentClient.getStudentIdsByInstructorId(GetStudentByInstructorRequest.builder().instructor_id(Long.valueOf(instructor_id)).build()));
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0;
        }
        return this.sosRequestRepository.findNotViewedCountByStudentIds(student_ids);
    }

    public Page<SOSRequestForInstructorWrapper> getSOSRequestByInstructorId(long instructor_id, String name, List<Long> students_ids, Integer pageNo, Integer pageSize, String orderBy, String sortBy, Date fromDate, Date toDate) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        HashSet ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)name)) {
            ids.addAll(this.studentClient.getStudentByInstructorIdAndStudentName(GetStudentByInstructorIdAndStudentNameRequest.builder().instructor_id(Long.valueOf(instructor_id)).student_name(name).build()).stream().map(StudentDTO::getStudent_id).collect(Collectors.toList()));
        } else {
            ids.addAll(this.studentClient.getStudentIdsByInstructorId(GetStudentByInstructorRequest.builder().instructor_id(Long.valueOf(instructor_id)).build()));
        }
        if (!AppUtils.isNullOrEmpty(students_ids)) {
            List filtered = ids.stream().filter(students_ids::contains).collect(Collectors.toList());
            ids.clear();
            ids.addAll(filtered);
        }
        Page pagedResult = this.sosRequestRepository.findPageByStudentIds(ids, fromDate, toDate, (Pageable)paging);
        List standardDTOS = this.standardClient.getAllStandards();
        List studentDTOS = this.studentClient.getStudentsByIds(GetStudentsByIdsRequest.builder().ids(pagedResult.getContent().stream().map(SOSRequestDTO::getStudent_id).distinct().collect(Collectors.toList())).build());
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(r -> {
            if (!r.isViewed()) {
                this.sosRequestRepository.updateViewed(r.getSos_request_id(), true);
                r.setViewed(true);
            }
            StudentCoreDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id() == r.getStudent_id()).findAny().get();
            StandardDTO standardDTO = standardDTOS.stream().filter(std -> std.getStandard_id() == studentDTO.getStandard_id()).findAny().get();
            String message = studentDTO.getFirst_name() + " " + studentDTO.getLast_name() + (Language.isSpanish() ? this.messageService.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()) : this.messageService.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
            return SOSRequestForInstructorWrapper.builder().message(message).sos_request(r).build();
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public int getSOSRequestNotViewedCountBySchoolId(long school_id) {
        HashSet student_ids = new HashSet(this.studentClient.getStudentIdsBySchoolId(GetStudentsBySchoolIdRequest.builder().school_id(school_id).build()));
        if (AppUtils.isNullOrEmpty(student_ids)) {
            return 0;
        }
        return this.sosRequestRepository.findNotViewedCountForSchoolByStudentIds(student_ids);
    }

    public Page<SOSRequestForInstructorWrapper> getSOSRequestBySchoolIdAndStudentDemographics(long school_id, String name, List<String> genders, List<Integer> ages, List<String> ethnicity, List<Long> gradeIds, List<Long> classIds, Integer pageNo, Integer pageSize, String orderBy, String sortBy, Date fromDate, Date toDate) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        GetStudentIdsByDemographicsRequest request = new GetStudentIdsByDemographicsRequest();
        request.setSchool_id(school_id);
        request.setName(name);
        request.setGenders(genders);
        request.setAges(ages);
        request.setEthnicity(ethnicity);
        request.setGradeIds(gradeIds);
        request.setClassIds(classIds);
        HashSet student_ids = new HashSet(this.studentClient.getStudentIdsByDemographics(request));
        Page pagedResult = this.sosRequestRepository.findPageByStudentIds(student_ids, fromDate, toDate, (Pageable)paging);
        List studentDTOS = this.studentClient.getStudentsByIds(GetStudentsByIdsRequest.builder().ids(pagedResult.getContent().stream().map(SOSRequestDTO::getStudent_id).distinct().collect(Collectors.toList())).build());
        List standardDTOS = this.standardClient.getAllStandards();
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(r -> {
            if (!r.isViewed_by_school()) {
                this.sosRequestRepository.updateViewedForSchool(r.getSos_request_id(), true);
                r.setViewed(true);
            }
            StudentCoreDTO studentDTO = studentDTOS.stream().filter(s -> s.getStudent_id() == r.getStudent_id()).findAny().get();
            StandardDTO standardDTO = standardDTOS.stream().filter(std -> std.getStandard_id() == studentDTO.getStandard_id()).findAny().get();
            String message = studentDTO.getFirst_name() + " " + studentDTO.getLast_name() + (Language.isSpanish() ? this.messageService.getMessage().getSos_alert_message_es().replace("<grade>", standardDTO.getStandard_name()) : this.messageService.getMessage().getSos_alert_message().replace("<grade>", standardDTO.getStandard_name()));
            return SOSRequestForInstructorWrapper.builder().message(message).sos_request(r).build();
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }
}

