/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.submoodandstandard.repository;

import com.infinite.focus.server.configuration.repository.ConfigurationRepository;
import com.infinite.focus.server.pvstate.model.PVState;
import com.infinite.focus.server.submoodandstandard.dto.SubMoodAndStandardDTO;
import com.infinite.focus.server.submoodandstandard.repository.SubMoodAndStandardRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class SubMoodAndStandardRepositoryImpl
implements SubMoodAndStandardRepository {
    private final JdbcTemplate jdbcTemplate;
    private final ConfigurationRepository configurationRepository;

    public SubMoodAndStandardRepositoryImpl(JdbcTemplate jdbcTemplate, ConfigurationRepository configurationRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.configurationRepository = configurationRepository;
    }

    private SubMoodAndStandardDTO mapRow(ResultSet rs, int i) throws SQLException {
        long standard_id = rs.getLong("standard_id");
        Object image = rs.getString("image");
        if (!(AppUtils.isNullOrEmpty((String)image) || standard_id != 1L && standard_id != 2L && standard_id != 3L)) {
            image = this.configurationRepository.getConfiguration().getImages_elementary_path() + (String)image;
        }
        return SubMoodAndStandardDTO.builder().sub_mood_and_standard_id(rs.getLong("sub_mood_and_standard_id")).mood_id(rs.getLong("mood_id")).standard_id(standard_id).sub_mood_id(rs.getLong("sub_mood_id")).top_sub_mood_id(rs.getLong("top_sub_mood_id")).image((String)image).color(rs.getString("color")).pv_state(PVState.valueOfOrDefault((String)rs.getString("pv_state"))).sort_index(rs.getInt("sort_index")).build();
    }

    public List<SubMoodAndStandardDTO> findByMoodIdAndStandardId(Long mood_id, Long standard_id) {
        String SQL = "SELECT * FROM sub_mood_and_standard WHERE mood_id = ? AND standard_id = ? ORDER BY sort_index";
        try {
            return this.jdbcTemplate.query(SQL, (arg_0, arg_1) -> this.mapRow(arg_0, arg_1), new Object[]{mood_id, standard_id});
        }
        catch (EmptyResultDataAccessException e) {
            e.printStackTrace();
            return new ArrayList<SubMoodAndStandardDTO>();
        }
    }

    public List<SubMoodAndStandardDTO> findAll() {
        String SQL = "SELECT * FROM sub_mood_and_standard ORDER BY sub_mood_and_standard_id ASC";
        return this.jdbcTemplate.query(SQL, (arg_0, arg_1) -> this.mapRow(arg_0, arg_1));
    }

    public SubMoodAndStandardDTO findByMoodIdStandardIdAndSubMoodId(long mood_id, long standard_id, long sub_mood_id) {
        String SQL = "SELECT * FROM sub_mood_and_standard WHERE mood_id = ? AND standard_id = ? AND sub_mood_id = ? ORDER BY sort_index";
        try {
            return (SubMoodAndStandardDTO)this.jdbcTemplate.queryForObject(SQL, (arg_0, arg_1) -> this.mapRow(arg_0, arg_1), new Object[]{mood_id, standard_id, sub_mood_id});
        }
        catch (EmptyResultDataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

