/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.twilio.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.twilio.request.SmsRequest;
import com.infinite.focus.server.twilio.service.SmsService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/twilio"})
public class TwilioController {
    @Autowired
    AuthService authService;
    @Autowired
    SmsService smsService;
    @Autowired
    MessageService messageService;

    @PostMapping(value={"/send/sms"})
    @ResponseBody
    public ResponseEntity<Message> sendSms(@RequestHeader(value="Authorization") String token, @RequestBody @Valid SmsRequest request) {
        this.authService.isAuthenticated(token);
        this.smsService.sendSms(request);
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("message.sent"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }
}

