/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.utils;

import com.cloudinary.Cloudinary;
import com.cloudinary.Transformation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppUtils {
    public static final String candidateCharsLicenceKey = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    public static final int lengthLicenceKey = 16;

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static boolean isNotNullOrEmpty(String text) {
        return text != null && !text.trim().isEmpty();
    }

    public static <E> boolean isNullOrEmpty(List<E> list) {
        return list == null || list.isEmpty();
    }

    public static <E> boolean isNotNullOrEmpty(List<E> list) {
        return list != null && !list.isEmpty();
    }

    public static <E> boolean isNullOrEmpty(LinkedHashSet<E> list) {
        return list == null || list.isEmpty();
    }

    public static <E> boolean isNullOrEmpty(Set<E> list) {
        return list == null || list.isEmpty();
    }

    public static <E> boolean isNotNullOrEmpty(LinkedHashSet<E> list) {
        return list != null && !list.isEmpty();
    }

    public static <E> boolean isNotNullOrEmpty(Set<E> list) {
        return list != null && !list.isEmpty();
    }

    public static <T> void addValueTotMap(LinkedHashMap<String[], List<T>> map, String[] key, T value) {
        for (Object[] objectArray : map.keySet()) {
            if (!Arrays.equals(objectArray, key)) continue;
            map.get(objectArray).add(value);
            break;
        }
    }

    public static String strListToCommaSeparatedString(List<String> strList) {
        return String.join((CharSequence)",", strList.stream().map(str -> "'" + str + "'").collect(Collectors.toSet()));
    }

    public static String integerListToCommaSeparatedString(List<Integer> strList) {
        return String.join((CharSequence)",", strList.stream().map(String::valueOf).collect(Collectors.toSet()));
    }

    public static String longListToCommaSeparatedString(List<Long> strList) {
        return String.join((CharSequence)",", strList.stream().map(String::valueOf).collect(Collectors.toSet()));
    }

    public static String longSetToCommaSeparatedString(Set<Long> strList) {
        return String.join((CharSequence)",", strList.stream().map(String::valueOf).collect(Collectors.toSet()));
    }

    public static List<Long> convertCommaSeparatedStringIdsToLongIds(String commaSepartedStringIds) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (AppUtils.isNotNullOrEmpty((String)commaSepartedStringIds)) {
            for (String id : Arrays.asList(commaSepartedStringIds.split("\\s*,\\s*"))) {
                ids.add(Long.valueOf(id));
            }
        }
        return ids;
    }

    public static boolean isValidateEmail(String email) {
        String emailidPattern = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        return email.matches(emailidPattern);
    }

    public static String generateRandomCharsLicenceKey(String candidateChars, int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(candidateChars.charAt(random.nextInt(candidateChars.length())));
            if (i == length - 1 || (i + 1) % 4 != 0) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static int generateRandomOtp() {
        Random r = new Random(System.currentTimeMillis());
        return (1 + r.nextInt(2)) * 100000 + r.nextInt(100000);
    }

    public static String generatePassword() {
        int length = 8;
        String capitalCaseLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lowerCaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String specialCharacters = "!@#$";
        String numbers = "1234567890";
        String combinedChars = capitalCaseLetters + lowerCaseLetters + specialCharacters + numbers;
        Random random = new Random();
        char[] password = new char[length];
        password[0] = lowerCaseLetters.charAt(random.nextInt(lowerCaseLetters.length()));
        password[1] = capitalCaseLetters.charAt(random.nextInt(capitalCaseLetters.length()));
        password[2] = specialCharacters.charAt(random.nextInt(specialCharacters.length()));
        password[3] = numbers.charAt(random.nextInt(numbers.length()));
        for (int i = 4; i < length; ++i) {
            password[i] = combinedChars.charAt(random.nextInt(combinedChars.length()));
        }
        return new String(password);
    }

    public static <T> T getFirstElement(Iterable<T> elements) {
        return elements.iterator().next();
    }

    public static <T> T getLastElement(Iterable<T> elements) {
        T lastElement = null;
        for (T element : elements) {
            lastElement = element;
        }
        return lastElement;
    }

    public static String getProperEmailFromCleverEmail(String cleverMail) {
        String emailRegex = "[a-zA-Z0-9._%+-\u00f1\u00d1]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}";
        Pattern pattern = Pattern.compile(emailRegex);
        Matcher matcher = pattern.matcher(cleverMail);
        if (matcher.find()) {
            String email = matcher.group(0);
            System.out.println(email);
            return email;
        }
        return null;
    }

    public static <T> Stream<T> getRandomStreamSubset(Stream<T> stream, int subsetSize) {
        int cnt = 0;
        Random r = new Random(System.nanoTime());
        Object[] tArr = new Object[subsetSize];
        Iterator iter = stream.iterator();
        while (iter.hasNext() && cnt < subsetSize) {
            tArr[cnt++] = iter.next();
        }
        while (iter.hasNext()) {
            ++cnt;
            Object t = iter.next();
            if (!(r.nextDouble() <= (double)subsetSize / (double)cnt)) continue;
            tArr[r.nextInt((int)subsetSize)] = t;
        }
        return Arrays.stream(tArr).map(o -> o);
    }

    public static String getUrlFromImgTag(String imgTag) {
        Pattern p = Pattern.compile("src='(.*?)'");
        Matcher m = p.matcher(imgTag);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static String getResizedUrl(Cloudinary cloudinary, int image_width, String originalImage) {
        if (image_width == 0) {
            return originalImage;
        }
        try {
            URL url = new URL(originalImage);
            String fileName = FilenameUtils.getName((String)url.getPath());
            String imgTag = cloudinary.url().transformation(new Transformation().width((Object)image_width).chain()).imageTag(fileName);
            return AppUtils.getUrlFromImgTag((String)imgTag);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return originalImage;
        }
    }
}

