/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.wallpostrestriction.repository;

import com.infinite.focus.server.wallpostrestriction.dto.WallPostRestrictionDTO;
import com.infinite.focus.server.wallpostrestriction.repository.WallPostRestrictionRepository;
import com.infinite.focus.server.wallpostrestriction.repository.mapper.WallPostRestrictionRowMapper;
import java.util.List;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WallPostRestrictionRepositoryImpl
implements WallPostRestrictionRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public WallPostRestrictionRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public WallPostRestrictionDTO findById(long student_id) {
        String sql = "SELECT * FROM wall_post_restriction WHERE student_id = :student_id";
        MapSqlParameterSource params = new MapSqlParameterSource("student_id", (Object)student_id);
        try {
            return (WallPostRestrictionDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)new WallPostRestrictionRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<WallPostRestrictionDTO> findAll() {
        String sql = "SELECT * FROM wall_post_restriction";
        return this.namedParameterJdbcTemplate.query(sql, (RowMapper)new WallPostRestrictionRowMapper());
    }

    public WallPostRestrictionDTO save(WallPostRestrictionDTO wallPostRestriction) {
        String sql = "INSERT INTO wall_post_restriction (student_id, count, blocked_until) VALUES (:student_id, :count, :blocked_until)";
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("student_id", (Object)wallPostRestriction.getStudent_id()).addValue("count", (Object)wallPostRestriction.getCount()).addValue("blocked_until", (Object)wallPostRestriction.getBlocked_until());
        this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)params);
        return this.findById(wallPostRestriction.getStudent_id());
    }

    public void update(WallPostRestrictionDTO wallPostRestriction) {
        String sql = "UPDATE wall_post_restriction SET count = :count, blocked_until = :blocked_until WHERE student_id = :student_id";
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("student_id", (Object)wallPostRestriction.getStudent_id()).addValue("count", (Object)wallPostRestriction.getCount()).addValue("blocked_until", (Object)wallPostRestriction.getBlocked_until());
        this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)params);
    }

    public void deleteById(long student_id) {
        String sql = "DELETE FROM wall_post_restriction WHERE student_id = :student_id";
        MapSqlParameterSource params = new MapSqlParameterSource("student_id", (Object)student_id);
        this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)params);
    }

    public void incrementCount(long student_id) {
        String sql = "UPDATE wall_post_restriction SET count = count + 1 WHERE student_id = :student_id";
        MapSqlParameterSource params = new MapSqlParameterSource("student_id", (Object)student_id);
        this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)params);
    }
}

