/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.account.service;

import com.infinite.focus.server.account.dto.AccountDTO;
import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.repository.AccountCoreRepository;
import com.infinite.focus.server.account.repository.AccountRepository;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.account.view.AccountView;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AccountServiceImpl
implements AccountService {
    @Autowired
    MessageService messageService;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private JwtHelper jwtHelper;
    @Autowired
    private AccountCoreRepository accountCoreRepository;

    public AccountDTO getByToken(String token) {
        if (AppUtils.isNullOrEmpty((String)token)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.not.found"));
        }
        String user = this.jwtHelper.extractUsername(token);
        if (!AppUtils.isNullOrEmpty((String)user)) {
            AccountDTO accountDTO = this.accountCoreRepository.findByUsernameOrUsername2(user);
            if (accountDTO == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.not.found"));
            }
            return accountDTO;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, this.messageService.getMessage("the.user.not.found"));
    }

    public AccountDTO getById(long account_id) {
        return this.accountCoreRepository.findByAccountId(account_id);
    }

    public Account createAccount(String username, String username2, String password) {
        if (AppUtils.isNullOrEmpty((String)username)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)username)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(username);
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        if (AppUtils.isNullOrEmpty((String)username2)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("username.is.null.or.empty"));
        }
        Account a2 = this.accountRepository.findByUsername2(username2);
        if (a2 != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("username.already.exists.please.try.using.some.different.username"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        account.setUsername(username);
        account.setUsername2(username2);
        a = (Account)this.accountRepository.save((Object)account);
        return a;
    }

    public Account createAccountByEmailAndPassword(String email, String password) {
        if (AppUtils.isNullOrEmpty((String)email)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)email)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account a = this.accountRepository.findByUsername(email);
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        account.setUsername(email);
        a = (Account)this.accountRepository.save((Object)account);
        return a;
    }

    public Account createCleverAccountByEmailAndPassword(String email, String password) {
        Account a = this.accountRepository.findByUsername(email);
        if (a != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        account.setUsername(email);
        a = (Account)this.accountRepository.save((Object)account);
        return a;
    }

    public Account createAccountByPassword(String password) {
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        return (Account)this.accountRepository.save((Object)account);
    }

    public Account createAccount() {
        Account account = new Account();
        return (Account)this.accountRepository.save((Object)account);
    }

    public AccountView findAccountById(long account_id) {
        AccountView accountView = this.accountRepository.findAccountViewByAccountId(Long.valueOf(account_id));
        if (accountView == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.account.is.not.found"));
        }
        return accountView;
    }

    public Account changeEmail(long account_id, String email) {
        this.isValidUsername(email, account_id);
        Account account = this.accountRepository.findByAccountId(account_id);
        account.setUsername(email);
        return (Account)this.accountRepository.save((Object)account);
    }

    public Account changeUsername2(long account_id, String username2) {
        if (AppUtils.isNullOrEmpty((String)username2)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("username.is.null.or.empty"));
        }
        Account a = this.accountRepository.findByUsername2(username2);
        if (a != null && a.getAccount_id() != account_id) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("username.already.exists.please.try.using.some.different.username"));
        }
        Account account = this.accountRepository.findByAccountId(account_id);
        account.setUsername2(username2);
        a = (Account)this.accountRepository.save((Object)account);
        return a;
    }

    public Account changePassword(long account_id, String password) {
        if (AppUtils.isNullOrEmpty((String)password)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("password.is.null.or.empty"));
        }
        Account account = this.accountRepository.findByAccountId(account_id);
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        return (Account)this.accountRepository.save((Object)account);
    }

    public Account getAccountById(long account_id) {
        return this.accountRepository.findByAccountId(account_id);
    }

    public Account getAccountByUsername2(String username2) {
        return this.accountRepository.findByUsername2(username2);
    }

    public Account getAccountByUsername(String username) {
        return this.accountRepository.findByUsername(username);
    }

    public Account save(Account account) {
        return (Account)this.accountRepository.save((Object)account);
    }

    public Account createAccountByPassword(String password, String role_in_organization) {
        if (AppUtils.isNullOrEmpty((String)password)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("password.is.required"));
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        account.setRole_in_organization(role_in_organization);
        return (Account)this.accountRepository.save((Object)account);
    }

    public boolean isValidUsername2(String username2) {
        if (AppUtils.isNullOrEmpty((String)username2)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("username.is.null.or.empty"));
        }
        Account account = this.getAccountByUsername2(username2);
        if (account != null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("username.is.already.exists"));
        }
        return true;
    }

    public boolean isValidUsername(String username, long account_id) {
        if (AppUtils.isNullOrEmpty((String)username)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("email.is.null.or.empty"));
        }
        if (!AppUtils.isValidateEmail((String)username)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.is.not.valid"));
        }
        Account account = this.getAccountByUsername(username);
        if (account != null && account_id != account.getAccount_id()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("email.already.exists.please.try.using.some.different.email.address"));
        }
        return true;
    }

    public Account isValidAccount(long account_id) {
        Account account = this.getAccountById(account_id);
        if (account == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("account.not.found"));
        }
        return account;
    }

    public Account updateAccount(long account_id, String password, String username, String username2) {
        this.isValidUsername(username, 0L);
        this.isValidUsername2(username2);
        if (AppUtils.isNullOrEmpty((String)password)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("password.is.required"));
        }
        Account account = this.isValidAccount(account_id);
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)password));
        account.setUsername(username);
        account.setUsername2(username2);
        return (Account)this.accountRepository.save((Object)account);
    }

    public List<Account> getAllAccounts() {
        return this.accountRepository.findByAllAccountsOrderByAccountIdAsc();
    }

    public List<Account> getAllMockAccounts() {
        return this.getAllAccounts().stream().filter(account -> !AppUtils.isNullOrEmpty((String)account.getUsername()) && (account.getUsername().contains("mailinator.com") || account.getUsername().contains("yopmail.com"))).collect(Collectors.toList());
    }

    public void delete(Account account) {
        this.accountRepository.delete((Object)account);
    }

    public Account findByEmail(String email) {
        return this.accountRepository.findByUsername(email);
    }

    public String getEmailByAccountId(long account_id) {
        return this.findAccountById(account_id).getUsername();
    }
}

