/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.group.repository;

import com.infinite.focus.server.group.entity.Class;
import com.infinite.focus.server.group.view.ClassView;
import com.infinite.focus.server.student.view.StudentView;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface ClassRepository
extends JpaRepository<Class, Long> {
    @Query(value="SELECT * FROM class WHERE instructor_id = ?1", nativeQuery=true)
    public List<Class> findByInstructorId(Long var1);

    @Query(value="SELECT * FROM class WHERE instructor_id = ?1", nativeQuery=true)
    public List<ClassView> findClassViewsByInstructorId(Long var1);

    @Query(value="SELECT * FROM class WHERE class_name = ?1 AND instructor_id = ?2", nativeQuery=true)
    public Class findByClassNameAndInstructorId(String var1, Long var2);

    @Query(value="SELECT class_id FROM class WHERE class_name LIKE %?1%", nativeQuery=true)
    public List<BigInteger> findClassIdsWhereClassNameLike(String var1);

    @Query(value="SELECT * FROM class WHERE class_id = ?1", nativeQuery=true)
    public Class findByClassId(long var1);

    @Query(value="SELECT * FROM class WHERE class_id = ?1", nativeQuery=true)
    public ClassView findClassViewByClassId(long var1);

    @Query(value="SELECT * FROM student WHERE student_id IN(SELECT student_id FROM student_class WHERE class_id = ?1)", nativeQuery=true)
    public List<StudentView> findStudentViewsByClassId(long var1);

    @Query(value="SELECT * FROM class WHERE class_id = ?1 AND instructor_id = ?2", nativeQuery=true)
    public Class findByClassIdAndInstructorId(long var1, long var3);

    @Query(value="SELECT * FROM class WHERE class_id IN(?1) ORDER BY class_id ASC", nativeQuery=true)
    public List<Class> findByClassIds(List<Long> var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM class WHERE class_id IN(?1)", nativeQuery=true)
    public void deleteByClassIds(List<Long> var1);

    @Query(value="SELECT * FROM class WHERE school_id = ?1", nativeQuery=true)
    public List<Class> findBySchoolId(long var1);

    @Query(value="SELECT * FROM class WHERE school_id = ?1", nativeQuery=true)
    public List<ClassView> findClassViewsBySchoolId(long var1);

    @Query(value="SELECT * FROM class WHERE clever_id = ?1", nativeQuery=true)
    public Class findByCleverId(String var1);

    @Query(value="SELECT * FROM class cl WHERE class_id IN(SELECT class_id FROM student_class st_cl WHERE st_cl.student_id = ?1 ORDER BY cl.class_id ASC)", nativeQuery=true)
    public LinkedList<ClassView> findClassViewByStudentId(long var1);
}

